package eu.pb4.polymer.core.mixin.item.packet;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.impl.interfaces.SkipCheck;
import eu.pb4.polymer.core.impl.networking.TransformingPacketCodec;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.ArrayList;
import net.minecraft.class_10302;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

@Mixin(class_10302.class)
public interface SlotDisplayMixin {
    @SuppressWarnings("DataFlowIssue")
    @ModifyExpressionValue(method = "<clinit>", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/codec/PacketCodec;dispatch(Ljava/util/function/Function;Ljava/util/function/Function;)Lnet/minecraft/network/codec/PacketCodec;"))
    private static class_9139<class_9129, class_10302> transformDisplays(class_9139<class_9129, class_10302> original) {
        return TransformingPacketCodec.encodeOnly(original, (buf, display) -> switch (display) {
            case SlotDisplay.ItemSlotDisplay item when PolymerSyncedObject.getSyncedObject(Registries.ITEM, item.item().value()) instanceof PolymerItem ->
                    new SlotDisplay.StackSlotDisplay(item.item().value().getDefaultStack());
            case SlotDisplay.TagSlotDisplay tagSlot when !((SkipCheck) (Object) tagSlot).polymer$skipped() -> {
                var tag = buf.getRegistryManager().getOrThrow(RegistryKeys.ITEM).getOptional(tagSlot.tag());
                if (tag.isEmpty()) {
                    yield tagSlot;
                }

                var array = new ArrayList<SlotDisplay>();
                for (var entry : tag.get()) {
                    if (PolymerSyncedObject.getSyncedObject(Registries.ITEM, entry.value()) instanceof PolymerItem) {
                        array.add(new SlotDisplay.StackSlotDisplay(entry.value().getDefaultStack()));
                    }
                }
                if (!array.isEmpty()) {
                    var out = new SlotDisplay.TagSlotDisplay(tagSlot.tag());
                    ((SkipCheck) (Object) out).polymer$setSkipped();

                    if (CompatStatus.POLYMC) {
                        if (((SkipCheck) (Object) tagSlot).polymc$skipped()) {
                            ((SkipCheck) (Object) out).polymc$setSkipped();
                        }
                    }

                    array.addFirst(out);
                    yield new SlotDisplay.CompositeSlotDisplay(array);
                }
                yield tagSlot;
            }
            default -> display;
        });
    }
}
