/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.mixin.block;

import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.compat.ImmersivePortalsUtils;
import eu.pb4.polymer.core.impl.interfaces.PolymerBlockPosStorage;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.BitSet;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2596;
import net.minecraft.class_2676;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3227;
import net.minecraft.class_3568;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3215.class})
public abstract class ServerChunkManagerMixin {
    @Unique
    private final Object2LongMap<class_4076> polymer$scheduledLightUpdates = new Object2LongArrayMap();
    @Shadow
    @Final
    public class_3898 field_17254;
    @Shadow
    @Final
    private class_3218 field_13945;
    @Shadow
    @Final
    private class_3227 field_13921;

    @Shadow
    @Nullable
    public abstract class_2818 method_21730(int var1, int var2);

    @Inject(method={"tickChunks()V"}, at={@At(value="TAIL")})
    private void polymer$sendChunkUpdates(CallbackInfo ci) {
        if (this.polymer$scheduledLightUpdates.isEmpty()) {
            return;
        }
        int currentTime = this.field_13945.method_8503().method_3780();
        this.polymer$scheduledLightUpdates.object2LongEntrySet().removeIf(entry -> {
            class_2826 patt0$temp;
            class_4076 sectionPos = (class_4076)entry.getKey();
            long sendAfterTime = entry.getLongValue();
            if ((long)currentTime <= sendAfterTime) {
                return false;
            }
            class_2818 chunk = this.method_21730(sectionPos.method_10263(), sectionPos.method_10260());
            if (chunk == null) {
                return true;
            }
            class_2826[] sections = chunk.method_12006();
            int sectionIndex = chunk.method_31603(sectionPos.method_18683());
            if (sectionIndex >= 0 && sectionIndex < sections.length && (patt0$temp = sections[sectionIndex]) instanceof PolymerBlockPosStorage) {
                PolymerBlockPosStorage section = (PolymerBlockPosStorage)patt0$temp;
                section.polymer$setRequireLights(false);
            }
            this.polymer$broadcastBlockLightForSection(sectionPos);
            return true;
        });
    }

    @Unique
    private List<class_3222> getPlayersWatchingChunk(class_1923 chunkPos) {
        if (CompatStatus.IMMERSIVE_PORTALS) {
            return ImmersivePortalsUtils.getPlayerTracking((class_5321<class_1937>)this.field_13945.method_27983(), chunkPos);
        }
        return this.field_17254.method_17210(chunkPos, false);
    }

    @Unique
    private void polymer$broadcastBlockLightForSection(class_4076 pos) {
        List<class_3222> players = this.getPlayersWatchingChunk(pos.method_18692());
        if (players.isEmpty()) {
            return;
        }
        BitSet dirtyBlockLightSections = new BitSet();
        dirtyBlockLightSections.set(pos.method_18683() - this.field_13921.method_31929());
        class_2676 packet = new class_2676(pos.method_18692(), (class_3568)this.field_13921, new BitSet(), dirtyBlockLightSections);
        for (class_3222 player : players) {
            player.field_13987.method_14364((class_2596)packet);
        }
    }

    @Inject(method={"onLightUpdate"}, at={@At(value="TAIL")})
    private void polymer$scheduleChunkUpdates(class_1944 type, class_4076 pos, CallbackInfo ci) {
        if (type == class_1944.field_9282) {
            this.field_13945.method_8503().execute(() -> {
                if (this.polymer$hasPendingLightUpdateAround(pos) || PolymerBlockUtils.SEND_LIGHT_UPDATE_PACKET.invoke(c -> c.test(this.field_13945, pos))) {
                    int sendAfterTime = this.field_13945.method_8503().method_3780() + PolymerImpl.LIGHT_UPDATE_TICK_DELAY;
                    this.polymer$scheduledLightUpdates.put((Object)pos, (long)sendAfterTime);
                }
            });
        }
    }

    @Unique
    private boolean polymer$hasPendingLightUpdateAround(class_4076 pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2818 chunk = this.method_21730(pos.method_10263() + x, pos.method_10260() + z);
                if (chunk == null) continue;
                class_2826[] sections = chunk.method_12006();
                int max = Math.min(chunk.method_31603(pos.method_18683() + 1), sections.length - 1);
                for (int i = Math.max(0, chunk.method_31603(pos.method_18683() - 1)); i <= max; ++i) {
                    class_2826 section = sections[i];
                    if (section == null || section.method_38292() || !((PolymerBlockPosStorage)section).polymer$requireLights()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

