/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.item;

import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.core.api.utils.PolymerRegistry;
import eu.pb4.polymer.core.impl.InternalServerRegistry;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.interfaces.CreativeModeTabExtra;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class PolymerItemGroupUtils {
    public static final PolymerRegistry<class_1761> REGISTRY = InternalServerRegistry.ITEM_GROUPS;
    public static final SimpleEvent<ItemGroupEventListener> LIST_EVENT = new SimpleEvent();
    private static final Map<ItemGroupKey, Contents> CONTENT_CACHE = new HashMap<ItemGroupKey, Contents>();

    private PolymerItemGroupUtils() {
    }

    public static Contents getContentsFor(class_3222 player, class_1761 group) {
        return PolymerItemGroupUtils.getContentsFor(group, (class_7225.class_7874)player.method_51469().method_8503().method_30611(), player.method_51469().method_45162(), CommonImplUtils.permissionCheck((class_3222)player, (String)"op_items", (int)2));
    }

    public static Contents getContentsFor(class_1761 group, class_7225.class_7874 lookup, class_7699 featureSet, boolean operator) {
        ItemGroupKey key = new ItemGroupKey(PolymerItemGroupUtils.getId(group), operator);
        Contents value = CONTENT_CACHE.get(key);
        if (value == null) {
            try {
                value = ((CreativeModeTabExtra)group).polymer$getContentsWith(PolymerItemGroupUtils.getId(group), featureSet, operator, lookup);
            }
            catch (Throwable t) {
                PolymerImpl.LOGGER.warn("Failed to load contents for an ItemGroup", t);
                value = new Contents(List.of(), List.of());
            }
            CONTENT_CACHE.put(key, value);
        }
        return value;
    }

    public static List<class_1761> getItemGroups(class_3222 player) {
        final LinkedHashSet<class_1761> list = new LinkedHashSet<class_1761>();
        for (class_1761 g : class_7706.method_47341()) {
            try {
                if (g.method_47312() != class_1761.class_7916.field_41052 || !((CreativeModeTabExtra)g).polymer$isSyncable()) continue;
                list.add(g);
            }
            catch (Throwable e) {
                PolymerImpl.LOGGER.warn("Something broke!", e);
            }
        }
        Iterator<Object> iterator = InternalServerRegistry.ITEM_GROUPS.iterator();
        while (iterator.hasNext()) {
            class_1761 g;
            g = (class_1761)iterator.next();
            try {
                if (g.method_47312() != class_1761.class_7916.field_41052 || !((CreativeModeTabExtra)g).polymer$isSyncable()) continue;
                list.add(g);
            }
            catch (Throwable e) {
                PolymerImpl.LOGGER.warn("Something broke!", e);
            }
        }
        ItemGroupListBuilder sync = new ItemGroupListBuilder(){

            @Override
            public void add(class_1761 group) {
                list.add(group);
            }

            @Override
            public void remove(class_1761 group) {
                list.remove(group);
            }
        };
        LIST_EVENT.invoke(arg_0 -> PolymerItemGroupUtils.lambda$getItemGroups$0(player, sync, arg_0));
        return new ArrayList<class_1761>(list);
    }

    public static boolean isPolymerItemGroup(class_1761 group) {
        return InternalServerRegistry.ITEM_GROUPS.containsEntry(group);
    }

    public static class_1761.class_7913 builder() {
        return new class_1761.class_7913(class_1761.class_7915.field_41050, -1);
    }

    public static void registerPolymerItemGroup(class_2960 identifier, class_1761 group) {
        if (class_7923.field_44687.method_10250(identifier)) {
            PolymerImpl.LOGGER.warn("ItemGroup '{}' is already registered in vanilla registry!", (Object)identifier);
        } else if (PolymerItemGroupUtils.contains(identifier).booleanValue()) {
            PolymerImpl.LOGGER.warn("ItemGroup '{}' is already registered under the same id!", (Object)identifier);
        } else if (PolymerItemGroupUtils.isPolymerItemGroup(group)) {
            PolymerImpl.LOGGER.warn("ItemGroup '{}' is already registered as '{}'! ", (Object)identifier, (Object)REGISTRY.method_10206(group));
        } else {
            InternalServerRegistry.ITEM_GROUPS.set(identifier, group);
        }
    }

    public static Boolean contains(class_2960 identifier) {
        return InternalServerRegistry.ITEM_GROUPS.contains(identifier);
    }

    public static void registerPolymerItemGroup(class_5321<class_1761> identifier, class_1761 group) {
        PolymerItemGroupUtils.registerPolymerItemGroup(identifier.method_29177(), group);
    }

    public static class_2960 getId(class_1761 group) {
        class_2960 x = REGISTRY.getEntryId(group);
        if (x == null) {
            return class_7923.field_44687.method_10221((Object)group);
        }
        return x;
    }

    public static class_5321<class_1761> getKey(class_1761 group) {
        class_2960 x = REGISTRY.getEntryId(group);
        if (x == null) {
            return (class_5321)class_7923.field_44687.method_29113((Object)group).orElseThrow();
        }
        return class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)x);
    }

    public static void invalidateItemGroupCache() {
        CONTENT_CACHE.clear();
    }

    private static /* synthetic */ void lambda$getItemGroups$0(class_3222 player, 1 sync, ItemGroupEventListener x) {
        x.onItemGroupGet(player, sync);
    }

    public record Contents(Collection<class_1799> main, Collection<class_1799> search) {
    }

    private record ItemGroupKey(class_2960 identifier, boolean operator) {
    }

    @FunctionalInterface
    public static interface ItemGroupEventListener {
        public void onItemGroupGet(class_3222 var1, ItemGroupListBuilder var2);
    }

    public static interface ItemGroupListBuilder {
        public void add(class_1761 var1);

        public void remove(class_1761 var1);
    }
}

