/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.networking.payloads.s2c;

import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.networking.S2CPackets;
import eu.pb4.polymer.networking.api.ContextByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import xyz.nucleoid.packettweaker.PacketContext;

public record PolymerItemGroupContentAddS2CPayload(class_2960 groupId, List<Entry> stacksMain, List<Entry> stacksSearch) implements class_8710
{
    public static final class_8710.class_9154<PolymerItemGroupContentAddS2CPayload> ID = new class_8710.class_9154(S2CPackets.SYNC_ITEM_GROUP_CONTENTS_ADD);
    public static final class_9139<ContextByteBuf, PolymerItemGroupContentAddS2CPayload> CODEC = class_9139.method_56438(PolymerItemGroupContentAddS2CPayload::write, PolymerItemGroupContentAddS2CPayload::read);

    public static PolymerItemGroupContentAddS2CPayload of(int version, class_1761 group, class_3244 handler) {
        List<Object> entrySearch;
        List<Entry> entryMain;
        PolymerItemGroupUtils.Contents contents = PolymerItemGroupUtils.getContentsFor(handler.field_14140, group);
        if (PolymerItemGroupUtils.isPolymerItemGroup(group)) {
            entryMain = List.of(new Entry(Mode.INSERT_END, class_1799.field_8037, List.copyOf(contents.main())));
            entrySearch = List.of(new Entry(Mode.INSERT_END, class_1799.field_8037, List.copyOf(contents.search())));
        } else if (version == 9) {
            PacketContext.NotNullWithPlayer ctx = PacketContext.create((class_3244)handler);
            ArrayList<class_1799> stackMain = new ArrayList<class_1799>();
            ArrayList<class_1799> stackSearch = new ArrayList<class_1799>();
            entryMain = List.of(new Entry(Mode.INSERT_END, class_1799.field_8037, stackMain));
            entrySearch = List.of(new Entry(Mode.INSERT_END, class_1799.field_8037, stackSearch));
            for (class_1799 item : contents.main()) {
                if (!PolymerItemUtils.isPolymerServerItem(item, (PacketContext)ctx) && !PolymerImplUtils.isServerSideSyncableEntry((class_2378)class_7923.field_41178, item.method_7909())) continue;
                stackMain.add(item);
            }
            for (class_1799 item : contents.search()) {
                if (!PolymerItemUtils.isPolymerServerItem(item, (PacketContext)ctx) && !PolymerImplUtils.isServerSideSyncableEntry((class_2378)class_7923.field_41178, item.method_7909())) continue;
                stackSearch.add(item);
            }
        } else {
            PacketContext.NotNullWithPlayer ctx = PacketContext.create((class_3244)handler);
            entryMain = new ArrayList<Entry>();
            entrySearch = new ArrayList();
            PolymerItemGroupContentAddS2CPayload.groupEntries(entryMain, contents.main(), ctx);
            PolymerItemGroupContentAddS2CPayload.groupEntries(entrySearch, contents.search(), ctx);
        }
        return new PolymerItemGroupContentAddS2CPayload(PolymerItemGroupUtils.getId(group), entryMain, entrySearch);
    }

    private static void groupEntries(List<Entry> entry, Collection<class_1799> main, PacketContext.NotNullWithPlayer ctx) {
        ArrayList<Object> stacks = new ArrayList<class_1799>();
        class_1799 previous = class_1799.field_8037;
        for (class_1799 item : main) {
            if (PolymerItemUtils.isPolymerServerItem(item, (PacketContext)ctx) || PolymerImplUtils.isServerSideSyncableEntry((class_2378)class_7923.field_41178, item.method_7909())) {
                stacks.add(item);
                continue;
            }
            if (!stacks.isEmpty()) {
                Mode mode = previous.method_7960() ? Mode.INSERT_BEGINNING : Mode.RELATIVE;
                entry.add(new Entry(mode, previous, stacks));
                stacks = new ArrayList();
            }
            previous = item;
        }
        if (!stacks.isEmpty()) {
            Mode mode = previous.method_7960() ? Mode.INSERT_END : Mode.RELATIVE;
            entry.add(new Entry(mode, previous, stacks));
        }
    }

    public void write(ContextByteBuf buf) {
        buf.method_10812(this.groupId);
        if (buf.version() == 9) {
            class_1799.field_49269.encode((Object)buf, this.stacksMain.isEmpty() ? List.of() : this.stacksMain.getFirst().stacks());
            class_1799.field_49269.encode((Object)buf, this.stacksSearch.isEmpty() ? List.of() : this.stacksSearch.getFirst().stacks());
            return;
        }
        Entry.LIST_PACKET_CODEC.encode((Object)buf, this.stacksMain);
        Entry.LIST_PACKET_CODEC.encode((Object)buf, this.stacksSearch);
    }

    public boolean isNonEmpty() {
        return !this.stacksMain.isEmpty() || !this.stacksSearch.isEmpty();
    }

    public static PolymerItemGroupContentAddS2CPayload read(ContextByteBuf buf) {
        if (buf.version() == 9) {
            return new PolymerItemGroupContentAddS2CPayload(buf.method_10810(), List.of(new Entry(Mode.INSERT_END, class_1799.field_8037, (List)class_1799.field_49269.decode((Object)buf))), List.of(new Entry(Mode.INSERT_END, class_1799.field_8037, (List)class_1799.field_49269.decode((Object)buf))));
        }
        return new PolymerItemGroupContentAddS2CPayload(buf.method_10810(), (List)Entry.LIST_PACKET_CODEC.decode((Object)buf), (List)Entry.LIST_PACKET_CODEC.decode((Object)buf));
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public record Entry(Mode mode, class_1799 relative, List<class_1799> stacks) {
        public static final class_9139<ContextByteBuf, Entry> PACKET_CODEC = class_9139.method_56437(Entry::write, Entry::read);
        public static final class_9139<ContextByteBuf, List<Entry>> LIST_PACKET_CODEC = PACKET_CODEC.method_56433(class_9135.method_56363());

        private static Entry read(ContextByteBuf byteBuf) {
            Mode mode = Mode.values()[byteBuf.method_10816()];
            class_1799 stack = class_1799.field_8037;
            if (mode == Mode.RELATIVE) {
                stack = (class_1799)class_1799.field_48349.decode((Object)byteBuf);
            }
            List list = (List)class_1799.field_49269.decode((Object)byteBuf);
            return new Entry(mode, stack, list);
        }

        private static void write(ContextByteBuf byteBuf, Entry entry) {
            byteBuf.method_10804(entry.mode.ordinal());
            if (entry.mode == Mode.RELATIVE) {
                class_1799.field_48349.encode((Object)byteBuf, (Object)entry.relative);
            }
            class_1799.field_49269.encode((Object)byteBuf, entry.stacks);
        }
    }

    public static enum Mode {
        RELATIVE,
        INSERT_BEGINNING,
        INSERT_END;

    }
}

