/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.utils;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.interfaces.RegistryExtension;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import net.minecraft.class_2378;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public interface PolymerSyncedObject<T>
extends PolymerObject {
    public T getPolymerReplacement(T var1, PacketContext var2);

    default public boolean canSynchronizeToPolymerClient(PacketContext context) {
        return true;
    }

    default public boolean canSyncRawToClient(PacketContext context) {
        return false;
    }

    public static <T> boolean canSyncRawToClient(class_2378<T> registry, T obj, PacketContext context) {
        PolymerSyncedObject<T> pol = PolymerSyncedObject.getSyncedObject(registry, obj);
        return pol != null ? pol.canSyncRawToClient(context) : !PolymerUtils.isServerOnly(registry, obj);
    }

    public static <T> void setSyncedObject(class_2378<T> registry, T obj, PolymerSyncedObject<T> object) {
        PolymerSyncedObject.setPlainSyncedObject(registry, obj, object);
        RegistrySyncUtils.setServerEntry(registry, obj);
    }

    public static <T> void setPlainSyncedObject(class_2378<T> registry, T obj, PolymerSyncedObject<T> object) {
        ((RegistryExtension)registry).polymer$setOverlay(obj, object);
    }

    @Nullable
    public static <T> PolymerSyncedObject<T> getSyncedObject(class_2378<T> registry, T obj) {
        PolymerSyncedObject<T> polymerSyncedObject;
        if (obj instanceof PolymerSyncedObject) {
            PolymerSyncedObject instance = (PolymerSyncedObject)obj;
            return instance;
        }
        if (registry instanceof RegistryExtension) {
            RegistryExtension extension = (RegistryExtension)registry;
            polymerSyncedObject = extension.polymer$getOverlay(obj);
        } else {
            polymerSyncedObject = null;
        }
        return polymerSyncedObject;
    }

    public static <T> boolean canSynchronizeToPolymerClient(class_2378<T> registry, T entry, PacketContext.NotNullWithPlayer ctx) {
        PolymerSyncedObject<T> obj = PolymerSyncedObject.getSyncedObject(registry, entry);
        return obj == null || obj.canSynchronizeToPolymerClient((PacketContext)ctx);
    }
}

