/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.block;

import eu.pb4.polymer.common.api.events.BooleanEvent;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.core.api.block.BlockMapper;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.impl.compat.polymc.PolyMcUtils;
import eu.pb4.polymer.core.impl.interfaces.BlockStateExtra;
import eu.pb4.polymer.core.impl.networking.PacketPatcher;
import eu.pb4.polymer.core.mixin.block.BlockEntityUpdateS2CPacketAccessor;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4076;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public final class PolymerBlockUtils {
    public static final int NESTED_DEFAULT_DISTANCE = 32;
    public static final Predicate<class_2680> IS_POLYMER_BLOCK_STATE_PREDICATE = state -> PolymerSyncedObject.getSyncedObject(class_7923.field_41175, state.method_26204()) instanceof PolymerBlock;
    public static final BooleanEvent<MineEventListener> SERVER_SIDE_MINING_CHECK = new BooleanEvent();
    public static final SimpleEvent<BreakingProgressListener> BREAKING_PROGRESS_UPDATE = new SimpleEvent();
    public static final BooleanEvent<PolymerBlockInteractionListener> POLYMER_BLOCK_INTERACTION_CHECK = new BooleanEvent();
    public static final BooleanEvent<PolymerIgnoreSoundExceptionListener> POLYMER_IGNORE_SOUND_EXCEPTED_ENTITY = new BooleanEvent();
    public static final BooleanEvent<BiPredicate<class_3218, class_4076>> SEND_LIGHT_UPDATE_PACKET = new BooleanEvent();
    private static final class_2487 STATIC_COMPOUND = new class_2487();

    private PolymerBlockUtils() {
    }

    public static void registerBlockEntity(class_2591<?> ... types) {
        for (class_2591<?> type : types) {
            PolymerBlockUtils.registerBlockEntity(type, (class_2591<?> obj, PacketContext ctx) -> null);
        }
    }

    public static void registerBlockEntity(class_2591<?> type, PolymerSyncedObject<class_2591<?>> syncedObject) {
        PolymerSyncedObject.setSyncedObject(class_7923.field_41181, type, syncedObject);
    }

    public static boolean isPolymerBlockEntityType(class_2591<?> type) {
        return PolymerSyncedObject.getSyncedObject(class_7923.field_41181, type) != null;
    }

    public static boolean forceLightUpdates(class_2680 blockState) {
        PolymerSyncedObject<class_2248> polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41175, blockState.method_26204());
        if (polymerSyncedObject instanceof PolymerBlock) {
            PolymerBlock virtualBlock = (PolymerBlock)polymerSyncedObject;
            if (virtualBlock.forceLightUpdates(blockState)) {
                return true;
            }
            return ((BlockStateExtra)blockState).polymer$isPolymerLightSource();
        }
        return false;
    }

    public static class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return BlockMapper.getFrom(context.getPlayer()).toClientSideState(state, context);
    }

    public static class_2248 getPolymerBlock(class_2248 block, PacketContext context) {
        return BlockMapper.getFrom(context.getPlayer()).toClientSideState(block.method_9564(), context).method_26204();
    }

    public static void registerOverlay(class_2248 block, PolymerBlock polymerBlock) {
        PolymerBlock.registerOverlay(block, polymerBlock);
    }

    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState, int maxDistance, PacketContext context) {
        PolymerBlock newBlock;
        PolymerSyncedObject<class_2248> polymerSyncedObject;
        class_2680 out = block.getPolymerBlockState(blockState, context);
        for (int req = 0; (polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41175, out.method_26204())) instanceof PolymerBlock && (newBlock = (PolymerBlock)polymerSyncedObject) != block && req < maxDistance; ++req) {
            out = newBlock.getPolymerBlockState(out, context);
        }
        return out;
    }

    public static class_2680 getBlockBreakBlockStateSafely(PolymerBlock block, class_2680 blockState, int maxDistance, PacketContext context) {
        PolymerBlock newBlock;
        PolymerSyncedObject<class_2248> polymerSyncedObject;
        class_2680 out = block.getPolymerBreakEventBlockState(blockState, context);
        for (int req = 0; (polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41175, out.method_26204())) instanceof PolymerBlock && (newBlock = (PolymerBlock)polymerSyncedObject) != block && req < maxDistance; ++req) {
            out = newBlock.getPolymerBreakEventBlockState(blockState, context);
        }
        return out;
    }

    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState, PacketContext context) {
        return PolymerBlockUtils.getBlockStateSafely(block, blockState, 32, context);
    }

    public static class_2622 createBlockEntityPacket(class_2338 pos, class_2591<?> type, @Nullable class_2487 nbtCompound) {
        return BlockEntityUpdateS2CPacketAccessor.createBlockEntityUpdateS2CPacket(pos.method_10062(), type, nbtCompound != null ? nbtCompound : STATIC_COMPOUND);
    }

    public static boolean shouldMineServerSide(class_3222 player, class_2338 pos, class_2680 state) {
        PolymerItem item;
        PolymerBlock block;
        PolymerSyncedObject<class_2248> polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41175, state.method_26204());
        return polymerSyncedObject instanceof PolymerBlock && (block = (PolymerBlock)polymerSyncedObject).handleMiningOnServer(player.method_6047(), state, pos, player) || (polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41178, player.method_6047().method_7909())) instanceof PolymerItem && (item = (PolymerItem)polymerSyncedObject).handleMiningOnServer(player.method_6047(), state, pos, player) || SERVER_SIDE_MINING_CHECK.invoke(x -> x.onBlockMine(state, pos, player));
    }

    public static class_2680 getServerSideBlockState(class_2680 state, PacketContext context) {
        return PolyMcUtils.toVanilla(PolymerBlockUtils.getPolymerBlockState(state, context), context.getPlayer());
    }

    public static class_2487 transformBlockEntityNbt(PacketContext context, class_2591<?> type, class_2487 original) {
        return PacketPatcher.transformBlockEntityNbt(context, type, original);
    }

    public static boolean isPolymerBlockInteraction(class_3222 player, class_1799 stack, class_1268 hand, class_2680 preInteractionState, class_3965 blockHitResult, class_3218 world, class_1269 actionResult) {
        PolymerItem polymerItem;
        PolymerBlock polymerBlock;
        PolymerBlock polymerBlock2;
        class_2680 blockState = world.method_8320(blockHitResult.method_17777());
        PolymerSyncedObject<class_2248> polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41175, blockState.method_26204());
        if (polymerSyncedObject instanceof PolymerBlock && (polymerBlock2 = (PolymerBlock)polymerSyncedObject).isPolymerBlockInteraction(blockState, player, hand, stack, world, blockHitResult, actionResult)) {
            return true;
        }
        if (!blockState.method_27852(preInteractionState.method_26204()) && (polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41175, preInteractionState.method_26204())) instanceof PolymerBlock && (polymerBlock = (PolymerBlock)polymerSyncedObject).isPolymerBlockInteraction(preInteractionState, player, hand, stack, world, blockHitResult, actionResult)) {
            return true;
        }
        polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41178, stack.method_7909());
        if (polymerSyncedObject instanceof PolymerItem && (polymerItem = (PolymerItem)polymerSyncedObject).isPolymerBlockInteraction(blockState, player, hand, stack, world, blockHitResult, actionResult)) {
            return true;
        }
        return POLYMER_BLOCK_INTERACTION_CHECK.invoke(x -> x.isPolymerBlockInteraction(blockState, player, hand, stack, world, blockHitResult, actionResult));
    }

    public static boolean isIgnoringPlaySoundExceptedEntity(class_3222 player, class_1799 stack, class_1268 hand, class_2680 state, class_3965 blockHitResult, class_3218 world) {
        PolymerItem polymerItem;
        PolymerBlock polymerBlock;
        PolymerSyncedObject<class_2248> polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41175, state.method_26204());
        if (polymerSyncedObject instanceof PolymerBlock && (polymerBlock = (PolymerBlock)polymerSyncedObject).isIgnoringBlockInteractionPlaySoundExceptedEntity(state, player, hand, stack, world, blockHitResult)) {
            return true;
        }
        polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41178, stack.method_7909());
        if (polymerSyncedObject instanceof PolymerItem && (polymerItem = (PolymerItem)polymerSyncedObject).isIgnoringBlockInteractionPlaySoundExceptedEntity(state, player, hand, stack, world, blockHitResult)) {
            return true;
        }
        return POLYMER_IGNORE_SOUND_EXCEPTED_ENTITY.invoke(x -> x.isIgnoringBlockInteractionPlaySoundExceptedEntity(state, player, hand, stack, world, blockHitResult));
    }

    @FunctionalInterface
    public static interface PolymerIgnoreSoundExceptionListener {
        public boolean isIgnoringBlockInteractionPlaySoundExceptedEntity(class_2680 var1, class_3222 var2, class_1268 var3, class_1799 var4, class_3218 var5, class_3965 var6);
    }

    @FunctionalInterface
    public static interface PolymerBlockInteractionListener {
        public boolean isPolymerBlockInteraction(class_2680 var1, class_3222 var2, class_1268 var3, class_1799 var4, class_3218 var5, class_3965 var6, class_1269 var7);
    }

    @FunctionalInterface
    public static interface MineEventListener {
        public boolean onBlockMine(class_2680 var1, class_2338 var2, class_3222 var3);
    }

    @FunctionalInterface
    public static interface BreakingProgressListener {
        public void onBreakingProgressUpdate(class_3222 var1, class_2338 var2, class_2680 var3, int var4);
    }
}

