/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.item;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.api.events.BooleanEvent;
import eu.pb4.polymer.common.api.events.FunctionEvent;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.core.api.other.PolymerComponent;
import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.TransformingComponent;
import eu.pb4.polymer.core.impl.compat.polymc.PolyMcUtils;
import eu.pb4.polymer.core.impl.other.PacketTooltipContext;
import eu.pb4.polymer.core.mixin.CustomDataAccessor;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSortedSets;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_10130;
import net.minecraft.class_10131;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1759;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1809;
import net.minecraft.class_1812;
import net.minecraft.class_1833;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5135;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9276;
import net.minecraft.class_9278;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9299;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import net.minecraft.class_9701;
import net.minecraft.class_9720;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import xyz.nucleoid.packettweaker.PacketContext;

public final class PolymerItemUtils {
    public static final String POLYMER_STACK = "$polymer:stack";
    public static final String POLYMER_COUNTED = "$polymer:counted";
    private static final String POLYMC_STACK = "PolyMcOriginal";
    private static final Codec<class_2960> STACK_ID_CODEC = class_2960.field_25139.fieldOf("id").codec();
    private static final Codec<Map<class_2960, class_2520>> COMPONENTS_CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        class_2520 nbt = (class_2520)dynamic.convert((DynamicOps)class_2509.field_11560).getValue();
        return DataResult.success((Object)(nbt == dynamic.getValue() ? nbt.method_10707() : nbt));
    }, nbt -> new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10707()))).optionalFieldOf("components", Map.of()).codec();
    public static final class_2583 CLEAN_STYLE = class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1068);
    public static final BooleanEvent<BiPredicate<class_1799, PacketContext>> CONTEXT_ITEM_CHECK = new BooleanEvent();
    @Deprecated(forRemoval=true)
    public static final BooleanEvent<Predicate<class_1799>> ITEM_CHECK = new BooleanEvent();
    public static final FunctionEvent<ItemModificationEventHandler, class_1799> ITEM_MODIFICATION_EVENT = new FunctionEvent();
    public static final BooleanEvent<PolymerItemInteractionListener> POLYMER_ITEM_INTERACTION_CHECK = new BooleanEvent();
    public static final BooleanEvent<PolymerIgnoreSoundExceptionListener> POLYMER_IGNORE_SOUND_EXCEPTED_ENTITY = new BooleanEvent();
    public static final BooleanEvent<ServerItemPredicate> IS_SERVER_ITEM_EVENT = new BooleanEvent();
    private static final IdentityHashMap<class_1792, List<class_9331<?>>> FORCE_SYNCED_COMPONENTS = new IdentityHashMap();
    private static final class_9331<?>[] COMPONENTS_TO_COPY = new class_9331[]{class_9334.field_49635, class_9334.field_49634, class_9334.field_49611, class_9334.field_49607, class_9334.field_50077, class_9334.field_50071, class_9334.field_49646, class_9334.field_49645, class_9334.field_49647, class_9334.field_49648, class_9334.field_50075, class_9334.field_54273, class_9334.field_49616, class_9334.field_49615, class_9334.field_49629, class_9334.field_50072, class_9334.field_49636, class_9334.field_49619, class_9334.field_49620, class_9334.field_49635, class_9334.field_49634, class_9334.field_49639, class_9334.field_49650, class_9334.field_54198, class_9334.field_50073, class_9334.field_49614, class_9334.field_49633, class_9334.field_49643, class_9334.field_49651, class_9334.field_49631, class_9334.field_52175, class_9334.field_49653, class_9334.field_49606, class_9334.field_49622, class_9334.field_53695, class_9334.field_53966, class_9334.field_53964, class_9334.field_54196, class_9334.field_54197, class_9334.field_49637, class_9334.field_49644, class_9334.field_53696, class_9334.field_56396, class_9334.field_56399, class_9334.field_56398, class_9334.field_56397, class_9334.field_49649, class_9334.field_55878, class_9334.field_56400, class_9334.field_63632, class_9334.field_63631, class_9334.field_64680, class_9334.field_63635, class_9334.field_63633, class_9334.field_63634};
    private static boolean stonecutterFix = PolymerImpl.FIX_STONECUTER;
    private static final ReferenceSet<class_9331<?>> FORCE_HIDE_TOOLTIP = ReferenceSet.of((Object[])new class_9331[]{class_9334.field_49630, class_9334.field_49636, class_9334.field_49611, class_9334.field_49635, class_9334.field_49634});
    private static final ReferenceSet<class_9331<?>> IGNORE_TOOLTIP_HIDING = ReferenceSet.of((Object)class_9334.field_49632);

    private PolymerItemUtils() {
    }

    public static class_1799 getPolymerItemStack(class_1799 itemStack, PacketContext context) {
        return PolymerItemUtils.getPolymerItemStack(itemStack, PolymerUtils.getTooltipType(context.getPlayer()), context);
    }

    public static class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipContext, PacketContext context) {
        if (PolymerItemUtils.getPolymerIdentifier(itemStack) != null) {
            return itemStack;
        }
        PolymerSyncedObject<class_1792> polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41178, itemStack.method_7909());
        if (polymerSyncedObject instanceof PolymerItem) {
            PolymerItem item = (PolymerItem)polymerSyncedObject;
            return item.getPolymerItemStack(itemStack, tooltipContext, context);
        }
        if (PolymerItemUtils.isPolymerServerItem(itemStack, context)) {
            return PolymerItemUtils.createItemStack(itemStack, tooltipContext, context);
        }
        if (CONTEXT_ITEM_CHECK.invoke(x -> x.test(itemStack, context))) {
            return PolymerItemUtils.createItemStack(itemStack, tooltipContext, context);
        }
        return itemStack;
    }

    public static class_1799 getRealItemStack(class_1799 itemStack, class_7225.class_7874 lookup) {
        block5: {
            class_9279 custom = (class_9279)itemStack.method_58694(class_9334.field_49628);
            if (custom != null) {
                class_2487 val = ((CustomDataAccessor)custom).polymer$getNbtUnsafe();
                if (!val.method_10545(POLYMER_STACK)) {
                    return itemStack;
                }
                try {
                    boolean counted = val.method_68566(POLYMER_COUNTED, false);
                    class_1799 x = val.method_67492(POLYMER_STACK, counted ? class_1799.field_24671 : class_1799.field_49747, (DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560)).orElseGet(() -> ((class_1799)itemStack).method_7972());
                    if (!counted) {
                        x.method_7939(itemStack.method_7947());
                    }
                    return x;
                }
                catch (Throwable e) {
                    if (!PolymerImpl.LOG_MORE_ERRORS) break block5;
                    PolymerImpl.LOGGER.warn("Failed to decode Item Stack!", e);
                }
            }
        }
        return itemStack;
    }

    @Nullable
    public static class_2960 getPolymerIdentifier(class_1799 itemStack) {
        return PolymerItemUtils.getPolymerIdentifier((class_9279)itemStack.method_58694(class_9334.field_49628));
    }

    public static class_2960 getPolymerIdentifier(@Nullable class_9279 custom) {
        if (custom != null) {
            class_2487 val = ((CustomDataAccessor)custom).polymer$getNbtUnsafe();
            if (!val.method_10545(POLYMER_STACK)) {
                return null;
            }
            try {
                return val.method_67491(POLYMER_STACK, STACK_ID_CODEC).orElse(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static class_2960 getServerIdentifier(class_1799 itemStack) {
        return PolymerItemUtils.getServerIdentifier((class_9279)itemStack.method_58694(class_9334.field_49628));
    }

    @Nullable
    public static class_2960 getServerIdentifier(@Nullable class_9279 nbtData) {
        if (nbtData == null) {
            return null;
        }
        class_2960 x = PolymerItemUtils.getPolymerIdentifier(nbtData);
        if (x != null) {
            return x;
        }
        try {
            class_2487 nbt = ((CustomDataAccessor)nbtData).polymer$getNbtUnsafe();
            if (nbt.method_10545(POLYMC_STACK)) {
                return nbt.method_67491(POLYMC_STACK, STACK_ID_CODEC).orElse(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static Map<class_2960, class_2520> getServerComponents(class_1799 stack) {
        return PolymerItemUtils.getServerComponents((class_9279)stack.method_58694(class_9334.field_49628));
    }

    @Nullable
    public static Map<class_2960, class_2520> getPolymerComponents(class_1799 stack) {
        return PolymerItemUtils.getPolymerComponents((class_9279)stack.method_58694(class_9334.field_49628));
    }

    @Nullable
    public static Map<class_2960, class_2520> getServerComponents(@Nullable class_9279 nbtData) {
        if (nbtData == null) {
            return null;
        }
        Map<class_2960, class_2520> x = PolymerItemUtils.getPolymerComponents(nbtData);
        if (x != null) {
            return x;
        }
        class_2487 nbt = ((CustomDataAccessor)nbtData).polymer$getNbtUnsafe();
        if (nbt.method_10545(POLYMC_STACK)) {
            return nbt.method_67491(POLYMC_STACK, COMPONENTS_CODEC).orElse(Map.of());
        }
        return null;
    }

    @Nullable
    public static Map<class_2960, class_2520> getPolymerComponents(@Nullable class_9279 nbtData) {
        if (nbtData == null || PolymerItemUtils.getPolymerIdentifier(nbtData) == null) {
            return null;
        }
        class_2487 nbt = ((CustomDataAccessor)nbtData).polymer$getNbtUnsafe();
        if (!nbt.method_10545(POLYMER_STACK)) {
            return null;
        }
        return nbt.method_67491(POLYMER_STACK, COMPONENTS_CODEC).orElse(Map.of());
    }

    public static void registerOverlay(class_1792 item, PolymerItem polymerItem) {
        PolymerItem.registerOverlay(item, polymerItem);
    }

    public static boolean isPolymerServerItem(class_1799 itemStack) {
        return PolymerItemUtils.isPolymerServerItem(itemStack, PacketContext.get());
    }

    public static boolean isPolymerServerItem(class_1799 itemStack, PacketContext context) {
        if (PolymerItemUtils.getPolymerIdentifier(itemStack) != null) {
            return false;
        }
        if (PolymerSyncedObject.getSyncedObject(class_7923.field_41178, itemStack.method_7909()) instanceof PolymerItem) {
            return true;
        }
        for (Map.Entry x2 : itemStack.method_57380().method_57846()) {
            TransformingComponent t;
            Object object;
            if (!PolymerComponent.canSync((class_9331)x2.getKey(), ((Optional)x2.getValue()).orElse(null), context)) {
                return true;
            }
            if (x2.getValue() == null || !((Optional)x2.getValue()).isPresent() || !((object = ((Optional)x2.getValue()).get()) instanceof TransformingComponent) || !(t = (TransformingComponent)object).polymer$requireModification(context)) continue;
            return true;
        }
        if (itemStack.method_57826(class_9334.field_49633) && ((class_10712)itemStack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318)).method_67214(class_9334.field_49636)) {
            for (class_6880 ench : ((class_9304)itemStack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385)).method_57534()) {
                List attributes = ((class_1887)ench.comp_349()).method_60034(class_9701.field_51668);
                if (attributes == null) continue;
                for (class_9720 attr : attributes) {
                    if (!PolymerEntityUtils.isPolymerEntityAttribute((class_6880<class_1320>)attr.comp_2718()) || !class_5135.method_26873((class_1299)class_1299.field_6097).method_27310(attr.comp_2718())) continue;
                    return true;
                }
            }
        }
        return CONTEXT_ITEM_CHECK.invoke(x -> x.test(itemStack, context));
    }

    public static class_1799 createItemStack(class_1799 itemStack, PacketContext context) {
        return PolymerItemUtils.createItemStack(itemStack, PolymerUtils.getTooltipType(context.getPlayer()), context);
    }

    public static class_1799 createItemStack(class_1799 itemStack, class_1836 tooltipContext, PacketContext context) {
        class_1799 out;
        block22: {
            Object key;
            boolean storeCount;
            class_1792 item = itemStack.method_7909();
            class_2960 model = null;
            PolymerSyncedObject<class_1792> polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41178, itemStack.method_7909());
            if (polymerSyncedObject instanceof PolymerItem) {
                PolymerItem virtualItem = (PolymerItem)polymerSyncedObject;
                ItemWithMetadata data = PolymerItemUtils.getItemSafely(virtualItem, itemStack, context);
                item = data.item();
                storeCount = virtualItem.shouldStorePolymerItemStackCount();
                model = data.itemModel != null ? data.itemModel : (class_2960)item.method_57347().method_58694(class_9334.field_54199);
            } else {
                storeCount = false;
                model = (class_2960)itemStack.method_58694(class_9334.field_54199);
            }
            out = new class_1799((class_1935)item, itemStack.method_7947());
            for (class_9331 x : out.method_57353().method_57831()) {
                if (itemStack.method_57353().method_58694(x) != null) continue;
                out.method_57379(x, null);
            }
            if (model != null) {
                out.method_57379(class_9334.field_54199, (Object)model);
            }
            for (int i = 0; i < COMPONENTS_TO_COPY.length; ++i) {
                key = COMPONENTS_TO_COPY[i];
                Object x = itemStack.method_58694(key);
                if (x instanceof TransformingComponent) {
                    TransformingComponent t = (TransformingComponent)x;
                    out.method_57379(key, t.polymer$getTransformed(context));
                    continue;
                }
                out.method_57379(key, itemStack.method_58694(key));
            }
            key = PolymerSyncedObject.getSyncedObject(class_7923.field_41178, itemStack.method_7909());
            if (key instanceof PolymerItem) {
                PolymerItem polymerItem = (PolymerItem)key;
                polymerItem.modifyBasePolymerItemStack(out, itemStack, context);
            }
            class_7225.class_7874 lookup = context.getRegistryWrapperLookup();
            class_10130 current = (class_10130)itemStack.method_58694(class_9334.field_53966);
            if (current == null) {
                out.method_57379(class_9334.field_53966, (Object)new class_10130(1.0E-5f, Optional.of(class_7923.field_41178.method_10221((Object)itemStack.method_7909()))));
            } else if (current.comp_3092().isEmpty()) {
                out.method_57379(class_9334.field_53966, (Object)new class_10130(current.comp_3091(), Optional.of(class_7923.field_41178.method_10221((Object)itemStack.method_7909()))));
            }
            out.method_57379(class_9334.field_49641, (Object)itemStack.method_7958());
            class_2561 name = itemStack.method_63693();
            out.method_57379(class_9334.field_50239, (Object)name);
            if (!out.method_57826(class_9334.field_49631) && (item instanceof class_1759 && out.method_57826(class_9334.field_49614) || (item instanceof class_1812 || item instanceof class_1833) && out.method_57826(class_9334.field_49651) || item instanceof class_1809 && out.method_57826(class_9334.field_49617) && Objects.requireNonNull((class_9296)out.method_58694(class_9334.field_49617)).method_73317().isPresent())) {
                out.method_57379(class_9334.field_49631, (Object)class_2561.method_43473().method_10852(name).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
            }
            try {
                out.method_57379(class_9334.field_49628, (Object)((class_9279)PolymerCommonUtils.executeWithoutNetworkingLogic(() -> {
                    class_2487 nbt = new class_2487();
                    nbt.method_67493(POLYMER_STACK, storeCount ? class_1799.field_24671 : class_1799.field_49747, (DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)itemStack);
                    if (storeCount) {
                        nbt.method_10556(POLYMER_COUNTED, true);
                    }
                    return class_9279.method_57456((class_2487)nbt);
                })));
            }
            catch (Throwable e) {
                GameProfile profile = context.getGameProfile();
                CommonImpl.LOGGER.error("Failed to encode Polymer item stack data {} for {}", (Object)itemStack, (Object)(profile != null ? profile.name() : "<Unknown>"));
            }
            class_10712 display = (class_10712)out.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
            for (class_9336 x : out.method_57353()) {
                if (IGNORE_TOOLTIP_HIDING.contains((Object)x.comp_2443()) || !(x.comp_2444() instanceof class_9299) && !FORCE_HIDE_TOOLTIP.contains((Object)x.comp_2443())) continue;
                display = display.method_67215(x.comp_2443(), true);
            }
            if (out.method_57826(class_9334.field_49629) && !itemStack.method_57826(class_9334.field_49629)) {
                display = display.method_67215(class_9334.field_49629, true);
            }
            display.comp_3601().removeIf(PolymerComponent::isPolymerComponent);
            out.method_57379(class_9334.field_56400, (Object)display);
            try {
                List tooltip = itemStack.method_7950((class_1792.class_9635)new PacketTooltipContext(context), (class_1657)context.getPlayer(), tooltipContext);
                if (!tooltip.isEmpty()) {
                    tooltip.removeFirst();
                    PolymerSyncedObject<class_1792> polymerSyncedObject2 = PolymerSyncedObject.getSyncedObject(class_7923.field_41178, itemStack.method_7909());
                    if (polymerSyncedObject2 instanceof PolymerItem) {
                        PolymerItem polymerItem = (PolymerItem)polymerSyncedObject2;
                        polymerItem.modifyClientTooltip(tooltip, itemStack, context);
                    }
                    if (!tooltip.isEmpty()) {
                        ArrayList<class_5250> lore = new ArrayList<class_5250>();
                        for (class_2561 t : tooltip) {
                            lore.add(class_2561.method_43473().method_10852(t).method_10862(CLEAN_STYLE));
                        }
                        out.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
                    }
                } else {
                    out.method_57379(class_9334.field_56400, (Object)new class_10712(true, (SequencedSet)ReferenceSortedSets.emptySet()));
                }
            }
            catch (Throwable e) {
                if (!PolymerImpl.LOG_MORE_ERRORS) break block22;
                PolymerImpl.LOGGER.error("Failed to get tooltip of " + String.valueOf(itemStack), e);
            }
        }
        return (class_1799)ITEM_MODIFICATION_EVENT.invoke(col -> {
            class_1799 custom = out;
            for (ItemModificationEventHandler in : col) {
                custom = in.modifyItem(itemStack, custom, context);
            }
            return custom;
        });
    }

    public static ItemWithMetadata getItemSafely(PolymerItem item, class_1799 stack, PacketContext context, int maxDistance) {
        PolymerItem newItem;
        PolymerSyncedObject<class_1792> polymerSyncedObject;
        class_1792 out = item.getPolymerItem(stack, context);
        PolymerItem lastVirtual = item;
        for (int req = 0; (polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41178, out)) instanceof PolymerItem && (newItem = (PolymerItem)polymerSyncedObject) != item && req < maxDistance; ++req) {
            out = newItem.getPolymerItem(stack, context);
            lastVirtual = newItem;
        }
        return new ItemWithMetadata(out, lastVirtual.getPolymerItemModel(stack, context));
    }

    public static ItemWithMetadata getItemSafely(PolymerItem item, class_1799 stack, PacketContext context) {
        return PolymerItemUtils.getItemSafely(item, stack, context, 32);
    }

    public static class_1799 getClientItemStack(class_1799 stack, PacketContext context) {
        class_1799 out = PolymerItemUtils.getPolymerItemStack(stack, context);
        if (CompatStatus.POLYMC) {
            out = PolyMcUtils.toVanilla(out, context.getPlayer());
        }
        return out;
    }

    public static boolean isPolymerItemInteraction(class_3222 player, class_1799 stack, class_1268 hand, class_3218 world, class_1269 actionResult) {
        PolymerItem polymerItem;
        PolymerSyncedObject<class_1792> polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41178, stack.method_7909());
        if (polymerSyncedObject instanceof PolymerItem && (polymerItem = (PolymerItem)polymerSyncedObject).isPolymerItemInteraction(player, hand, stack, world, actionResult)) {
            return true;
        }
        return POLYMER_ITEM_INTERACTION_CHECK.invoke(x -> x.isPolymerItemInteraction(player, hand, stack, world, actionResult));
    }

    public static boolean isIgnoringPlaySoundExceptedEntity(class_3222 player, class_1799 stack, class_1268 hand, class_3218 world) {
        PolymerItem polymerItem;
        PolymerSyncedObject<class_1792> polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41178, stack.method_7909());
        if (polymerSyncedObject instanceof PolymerItem && (polymerItem = (PolymerItem)polymerSyncedObject).isIgnoringItemInteractionPlaySoundExceptedEntity(player, hand, stack, world)) {
            return true;
        }
        return POLYMER_IGNORE_SOUND_EXCEPTED_ENTITY.invoke(x -> x.isIgnoringItemInteractionPlaySoundExceptedEntity(player, hand, stack, world));
    }

    public static void syncDefaultComponent(class_1792 item, class_9331<?> ... types) {
        List list = FORCE_SYNCED_COMPONENTS.computeIfAbsent(item, i -> new ReferenceArrayList());
        for (class_9331<?> type : types) {
            if (list.contains(type)) continue;
            list.add(type);
        }
    }

    public static boolean isStonecutterFixEnabled() {
        return stonecutterFix;
    }

    public static void enableStonecutterFix() {
        stonecutterFix = true;
    }

    public static @UnmodifiableView List<class_9331<?>> getSyncedDefaultComponents(class_1792 item) {
        return FORCE_SYNCED_COMPONENTS.getOrDefault(item, List.of());
    }

    public static boolean isServerItem(class_1799 stack, PacketContext context) {
        class_10131 remainder;
        class_9276 bundle;
        if (PolymerItemUtils.isPolymerServerItem(stack, context)) {
            return true;
        }
        if (CompatStatus.POLYMC && PolyMcUtils.isServerSide((class_2378)class_7923.field_41178, stack.method_7909())) {
            return true;
        }
        class_9288 container = (class_9288)stack.method_58694(class_9334.field_49622);
        if (container != null) {
            for (Object inner : container.method_59714()) {
                if (!PolymerItemUtils.isServerItem((class_1799)inner, context)) continue;
                return true;
            }
        }
        if ((bundle = (class_9276)stack.method_58694(class_9334.field_49650)) != null) {
            for (class_1799 inner : bundle.method_57421()) {
                if (!PolymerItemUtils.isServerItem(inner, context)) continue;
                return true;
            }
        }
        if ((remainder = (class_10131)stack.method_58694(class_9334.field_53965)) != null && PolymerItemUtils.isServerItem(remainder.comp_3093(), context)) {
            return true;
        }
        class_9278 projectile = (class_9278)stack.method_58694(class_9334.field_49649);
        if (projectile != null) {
            for (class_1799 inner : projectile.method_57437()) {
                if (!PolymerItemUtils.isServerItem(inner, context)) continue;
                return true;
            }
        }
        return IS_SERVER_ITEM_EVENT.invoke(x -> x.isServerItem(stack, context));
    }

    static {
        CONTEXT_ITEM_CHECK.register((stack, context) -> ITEM_CHECK.invoke(x -> x.test(stack)));
    }

    public record ItemWithMetadata(class_1792 item, @Nullable class_2960 itemModel) {
    }

    @FunctionalInterface
    public static interface ServerItemPredicate {
        public boolean isServerItem(class_1799 var1, PacketContext var2);
    }

    @FunctionalInterface
    public static interface PolymerIgnoreSoundExceptionListener {
        public boolean isIgnoringItemInteractionPlaySoundExceptedEntity(class_3222 var1, class_1268 var2, class_1799 var3, class_3218 var4);
    }

    @FunctionalInterface
    public static interface PolymerItemInteractionListener {
        public boolean isPolymerItemInteraction(class_3222 var1, class_1268 var2, class_1799 var3, class_3218 var4, class_1269 var5);
    }

    @FunctionalInterface
    public static interface ItemModificationEventHandler {
        public class_1799 modifyItem(class_1799 var1, class_1799 var2, PacketContext var3);
    }
}

