/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.utils;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.api.ScopedOverride;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.api.other.PolymerComponent;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.interfaces.PolymerGamePacketListenerExtension;
import eu.pb4.polymer.core.impl.networking.PacketPatcher;
import eu.pb4.polymer.core.mixin.StaticAccessor;
import eu.pb4.polymer.core.mixin.block.packet.ServerMapAccessor;
import eu.pb4.polymer.core.mixin.entity.ServerLevelAccessor;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3852;
import net.minecraft.class_3898;
import net.minecraft.class_3902;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7696;
import net.minecraft.class_8609;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public final class PolymerUtils {
    public static final String ID = "polymer";
    public static final String NO_TEXTURE_HEAD_VALUE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGUyY2UzMzcyYTNhYzk3ZmRkYTU2MzhiZWYyNGIzYmM0OWY0ZmFjZjc1MWZlOWNhZDY0NWYxNWE3ZmI4Mzk3YyJ9fX0=";
    private static final Set<class_7696> ENABLED_FEATURE_FLAGS = new HashSet<class_7696>();
    private static final Set<class_5321<? extends class_2378<?>>> SERVER_ONLY_REGISTRIES = new HashSet();

    private PolymerUtils() {
    }

    public static String getVersion() {
        return CommonImpl.VERSION;
    }

    public static void addClientEnabledFeatureFlags(class_7696 ... flags) {
        ENABLED_FEATURE_FLAGS.addAll(List.of(flags));
    }

    public static Collection<class_7696> getClientEnabledFeatureFlags() {
        return ENABLED_FEATURE_FLAGS;
    }

    public static ScopedOverride ignorePlaySoundExclusion() {
        if (PolymerImplUtils.IGNORE_PLAY_SOUND_EXCLUSION.get() != null) {
            return ScopedOverride.NO_OP;
        }
        PolymerImplUtils.IGNORE_PLAY_SOUND_EXCLUSION.set(class_3902.field_17274);
        return PolymerImplUtils.IGNORE_PLAY_SOUND_EXCLUSION::remove;
    }

    public static void schedulePacket(class_3244 handler, class_2596<?> packet, int duration) {
        ((PolymerGamePacketListenerExtension)handler).polymer$schedulePacket(packet, duration);
    }

    public static void reloadWorld(class_3222 player) {
        player.method_51469().method_8503().execute(() -> {
            PolymerImplUtils.IS_RELOADING_WORLD.set(class_3902.field_17274);
            try {
                player.field_7512.method_34252();
                class_3218 world = player.method_51469();
                ServerMapAccessor tacsAccess = (ServerMapAccessor)world.method_14178().field_17254;
                for (class_1297 e : ((ServerLevelAccessor)world).polymer_getEntityManager().method_31841().method_31803()) {
                    class_3898.class_3208 tracker = (class_3898.class_3208)tacsAccess.polymer$getEntityTrackers().get(e.method_5628());
                    if (tracker == null) continue;
                    tracker.method_18733(player);
                }
                player.method_52372().method_52363(chunkPos -> {
                    class_2818 chunk = world.method_8497(chunkPos.field_9181, chunkPos.field_9180);
                    player.field_13987.field_45026.method_52387(player, chunk.method_12004());
                    player.field_13987.field_45026.method_52390(chunk);
                });
            }
            catch (Throwable e) {
                PolymerImpl.LOGGER.warn("Failed to reload player's world view!", e);
            }
            PolymerImplUtils.IS_RELOADING_WORLD.remove();
        });
    }

    public static void reloadInventory(class_3222 player) {
        player.field_7512.method_34252();
    }

    public static class_1836 getTooltipType(@Nullable class_3222 player) {
        return PolymerImplUtils.getTooltipContext(player);
    }

    public static class_1836 getCreativeTooltipType(@Nullable class_3222 player) {
        return PolymerImplUtils.getTooltipContext(player).withCreative();
    }

    public static class_9296 createProfileComponent(String value) {
        return PolymerUtils.createProfileComponent(value, null);
    }

    public static class_9296 createProfileComponent(String value, @Nullable String signature) {
        PropertyMap profile = new PropertyMap((Multimap)ImmutableMultimap.of((Object)"textures", (Object)new Property("textures", value, signature)));
        return class_9296.method_73307((GameProfile)new GameProfile(class_156.field_25140, "", profile));
    }

    public static class_9296 createProfileComponent(class_8685.class_11892 override) {
        return StaticAccessor.createStatic((Either<GameProfile, class_9296.class_11757>)Either.right((Object)class_9296.class_11757.field_63032), override);
    }

    public static class_1799 createPlayerHead(String value) {
        return PolymerUtils.createPlayerHead(value, null);
    }

    public static class_1799 createPlayerHead(String value, String signature) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        stack.method_57379(class_9334.field_49617, (Object)PolymerUtils.createProfileComponent(value, signature));
        return stack;
    }

    public static class_1937 getFakeWorld() {
        return PolymerCommonUtils.getFakeWorld();
    }

    @Nullable
    public static Path getClientJar() {
        return PolymerCommonUtils.getClientJar();
    }

    @Deprecated(forRemoval=true)
    public static boolean isServerOnly(Object obj) {
        class_3852 villagerProfession;
        class_9331 componentType;
        class_6880 entry;
        class_2591 typeBE;
        class_1299 type;
        class_1799 stack;
        return obj instanceof PolymerObject || obj instanceof class_1799 && PolymerItemUtils.isPolymerServerItem(stack = (class_1799)obj) || obj instanceof class_1299 && PolymerEntityUtils.isPolymerEntityType(type = (class_1299)obj) || obj instanceof class_2591 && PolymerBlockUtils.isPolymerBlockEntityType(typeBE = (class_2591)obj) || obj instanceof class_6880 && (entry = (class_6880)obj).comp_349() instanceof class_1320 && PolymerEntityUtils.isPolymerEntityAttribute((class_6880<class_1320>)entry) || obj instanceof class_9331 && PolymerComponent.isPolymerComponent(componentType = (class_9331)obj) || obj instanceof class_3852 && PolymerEntityUtils.getPolymerProfession(villagerProfession = (class_3852)obj) != null;
    }

    public static <T> boolean isServerOnly(class_2378<T> registry, T obj) {
        return RegistrySyncUtils.isServerEntry(registry, obj) || PolymerUtils.isServerOnly(obj);
    }

    public static boolean hasResourcePack(@Nullable class_3222 player, UUID uuid) {
        return PolymerCommonUtils.hasResourcePack((class_3222)player, (UUID)uuid);
    }

    public static class_2596<?> replacePacket(class_8609 handler, class_2596<?> packet) {
        return PacketPatcher.replace(handler, packet);
    }

    public static boolean shouldPreventPacket(class_8609 handler, class_2596<?> packet) {
        return PacketPatcher.prevent(handler, packet);
    }

    public static boolean isServerOnlyRegistry(class_5321<? extends class_2378<?>> key) {
        return SERVER_ONLY_REGISTRIES.contains(key);
    }

    public static void markAsServerOnlyRegistry(class_5321<? extends class_2378<?>> key) {
        if (key.method_29177().method_12836().equals("minecraft")) {
            return;
        }
        SERVER_ONLY_REGISTRIES.add(key);
    }
}

