package eu.pb4.polymer.core.api.block;

import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

/**
 * Interface used for creation of server side blocks
 */
public interface PolymerBlock extends PolymerSyncedObject<class_2248> {

    /**
     * Generic method used for replacing BlockStates in case of no player context
     * It also controls some server side things like collisions
     *
     * @param state Server side/real BlockState
     * @return BlockState visible on client
     */
    class_2680 getPolymerBlockState(class_2680 state);

    /**
     * Main method used for replacing BlockStates for players
     * Keep in mind you should ideally use blocks with the same hitbox as generic/non-player ones!
     *
     * @param state Server side BlocksState
     * @param player Player viewing it
     * @return Client side BlockState
     */
    default class_2680 getPolymerBlockState(class_2680 state, class_3222 player) {
        return this.getPolymerBlockState(state);
    }

    /**
     * This method is called when block gets send to player
     * Allows to add client-only BlockEntities (for signs, heads, etc)
     *
     * @param blockState Real BlockState of block
     * @param pos Position of block. Keep in mind it's mutable,
 *            so make sure to use {@link class_2338.class_2339#method_10062()}
 *            in case of using in packets, as it's reused for other positions!
     * @param player Player packets should be send to
     */
    default void onPolymerBlockSend(class_2680 blockState, class_2338.class_2339 pos, class_3222 player) { }

    /**
     * You can override this method in case of issues with light updates of this block. In most cases it's not needed.
     * @param blockState
     */
    default boolean forceLightUpdates(class_2680 blockState) { return false; }

    /**
     * Overrides breaking particle used by the block
     * @param state
     * @param player
     * @return
     */
    default class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return state;
    }

    @Override
    default class_2248 getPolymerReplacement(class_3222 player) {
        return PolymerBlockUtils.getPolymerBlock((class_2248) this, player);
    }

    default boolean handleMiningOnServer(class_1799 tool, class_2680 state, class_2338 pos, class_3222 player) {
        return true;
    }
}
