package eu.pb4.polymer.core.api.block;

import com.mojang.serialization.DataResult;
import eu.pb4.polymer.common.api.events.BooleanEvent;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.api.other.PolymerComponent;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.TransformingComponent;
import eu.pb4.polymer.core.impl.compat.polymc.PolyMcUtils;
import eu.pb4.polymer.core.impl.interfaces.BlockStateExtra;
import eu.pb4.polymer.core.mixin.block.BlockEntityUpdateS2CPacketAccessor;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.Arrays;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_6903;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9336;

public final class PolymerBlockUtils {
    public static final int NESTED_DEFAULT_DISTANCE = 32;
    public static final Predicate<class_2680> IS_POLYMER_BLOCK_STATE_PREDICATE = state -> state.method_26204() instanceof PolymerBlock;
    /**
     * This event allows you to force server side mining for any block/item
     */
    public static final BooleanEvent<MineEventListener> SERVER_SIDE_MINING_CHECK = new BooleanEvent<>();
    public static final SimpleEvent<BreakingProgressListener> BREAKING_PROGRESS_UPDATE = new SimpleEvent<>();
    /**
     * This event allows you to force syncing of light updates between server and clinet
     */
    public static final BooleanEvent<BiPredicate<class_3218, class_4076>> SEND_LIGHT_UPDATE_PACKET = new BooleanEvent<>();
    private static final class_2487 STATIC_COMPOUND = new class_2487();
    private static final Set<class_2591<?>> BLOCK_ENTITY_TYPES = new ObjectOpenCustomHashSet<>(CommonImplUtils.IDENTITY_HASH);
    private static boolean requireStrictBlockUpdates = false;

    private PolymerBlockUtils() {
    }

    /**
     * Marks BlockEntity type as server-side only
     *
     * @param types BlockEntityTypes
     */
    public static void registerBlockEntity(class_2591<?>... types) {
        BLOCK_ENTITY_TYPES.addAll(Arrays.asList(types));

        for (var type : types) {
            RegistrySyncUtils.setServerEntry(class_7923.field_41181, type);
        }
    }

    /**
     * Checks if BlockEntity is server-side only
     *
     * @param type BlockEntities type
     */
    public static boolean isPolymerBlockEntityType(class_2591<?> type) {
        return BLOCK_ENTITY_TYPES.contains(type);
    }

    /**
     * This method is used to check if BlockState should force sending of light updates to client
     *
     * @param blockState
     * @return
     */
    public static boolean forceLightUpdates(class_2680 blockState) {
        if (blockState.method_26204() instanceof PolymerBlock virtualBlock) {
            if (virtualBlock.forceLightUpdates(blockState)) {
                return true;
            }

            return ((BlockStateExtra) blockState).polymer$isPolymerLightSource();
        }
        return false;
    }

    /**
     * Gets BlockState used on client side
     *
     * @param state server side BlockState
     * @return Client side BlockState
     */
    public static class_2680 getPolymerBlockState(class_2680 state) {
        return getPolymerBlockState(state, null);
    }

    /**
     * Gets BlockState used on client side
     *
     * @param state server side BlockState
     * @param player      Possible target player
     * @return Client side BlockState
     */
    public static class_2680 getPolymerBlockState(class_2680 state, @Nullable class_3222 player) {
        return BlockMapper.getFrom(player).toClientSideState(state, player);
    }

    public static class_2248 getPolymerBlock(class_2248 block, @Nullable class_3222 player) {
        return BlockMapper.getFrom(player).toClientSideState(block.method_9564(), player).method_26204();
    }

    /**
     * This method is minimal wrapper around {@link PolymerBlock#getPolymerBlockState(class_2680)} )} to make sure
     * It gets replaced if it represents other PolymerBlock
     *
     * @param block       PolymerBlock
     * @param blockState  Server side BlockState
     * @param maxDistance Maximum number of checks for nested virtual blocks
     * @return Client side BlockState
     */
    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState, int maxDistance) {
        class_2680 out = block.getPolymerBlockState(blockState);

        int req = 0;
        while (out.method_26204() instanceof PolymerBlock newBlock && newBlock != block && req < maxDistance) {
            out = newBlock.getPolymerBlockState(out);
            req++;
        }
        return out;
    }

    /**
     * This method is minimal wrapper around {@link PolymerBlock#getPolymerBlockState(class_2680)} )} to make sure
     * It gets replaced if it represents other PolymerBlock
     *
     * @param block       PolymerBlock
     * @param blockState  Server side BlockState
     * @param maxDistance Maximum number of checks for nested virtual blocks
     * @param player      Possible target player
     * @return Client side BlockState
     */
    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState, int maxDistance, @Nullable class_3222 player) {
        if (player == null) {
            return getBlockStateSafely(block, blockState, maxDistance);
        }

        class_2680 out = block.getPolymerBlockState(blockState, player);

        int req = 0;
        while (out.method_26204() instanceof PolymerBlock newBlock && newBlock != block && req < maxDistance) {
            out = newBlock.getPolymerBlockState(blockState, player);
            req++;
        }
        return out;
    }

    public static class_2680 getBlockBreakBlockStateSafely(PolymerBlock block, class_2680 blockState, int maxDistance, @Nullable class_3222 player) {
        if (player == null) {
            return getBlockStateSafely(block, blockState, maxDistance);
        }

        class_2680 out = block.getPolymerBreakEventBlockState(blockState, player);

        int req = 0;
        while (out.method_26204() instanceof PolymerBlock newBlock && newBlock != block && req < maxDistance) {
            out = newBlock.getPolymerBreakEventBlockState(blockState, player);
            req++;
        }
        return out;
    }

    /**
     * This method is minimal wrapper around {@link PolymerBlock#getPolymerBlockState(class_2680)} )} to make sure
     * It gets replaced if it represents other PolymerBlock
     *
     * @param block       PolymerBlock
     * @param blockState  Server side BlockState
     * @param player      Possible target player
     * @return Client side BlockState
     */
    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState, @Nullable class_3222 player) {
        return getBlockStateSafely(block, blockState, NESTED_DEFAULT_DISTANCE, player);
    }

    /**
     * This method is minimal wrapper around {@link PolymerBlock#getPolymerBlockState(class_2680)} to make sure
     * It gets replaced if it represents other PolymerBlock
     *
     * @param block      PolymerBlock
     * @param blockState Server side BlockState
     * @return Client side BlockState
     */
    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState) {
        return getBlockStateSafely(block, blockState, NESTED_DEFAULT_DISTANCE);
    }

    public static class_2622 createBlockEntityPacket(class_2338 pos, class_2591<?> type, @Nullable class_2487 nbtCompound) {
        return BlockEntityUpdateS2CPacketAccessor.createBlockEntityUpdateS2CPacket(pos.method_10062(), type, nbtCompound != null ? nbtCompound : STATIC_COMPOUND);
    }

    @ApiStatus.Experimental
    public static void requireStrictBlockUpdates() {
        requireStrictBlockUpdates = true;
    }

    public static boolean isStrictBlockUpdateRequired() {
        return requireStrictBlockUpdates;
    }

    public static boolean shouldMineServerSide(class_3222 player, class_2338 pos, class_2680 state) {
        return (state.method_26204() instanceof PolymerBlock block && block.handleMiningOnServer(player.method_6047(), state, pos, player))
                || (player.method_6047().method_7909() instanceof PolymerItem item && item.handleMiningOnServer(player.method_6047(), state, pos, player))
                || PolymerBlockUtils.SERVER_SIDE_MINING_CHECK.invoke((x) -> x.onBlockMine(state, pos, player));
    }

    public static class_2680 getServerSideBlockState(class_2680 state, class_3222 player) {
        return PolyMcUtils.toVanilla(getPolymerBlockState(state, player), player);
    }

    public static class_2487 transformBlockEntityNbt(PacketContext context, class_2591<?> type, class_2487 original) {
        if (original.method_33133()) {
            return original;
        }
        class_2487 override = null;

        var lookup = context.getRegistryWrapperLookup() != null ? context.getRegistryWrapperLookup() : PolymerImplUtils.FALLBACK_LOOKUP;

        if (original.method_10573("Items", class_2520.field_33259)) {
            var list = original.method_10554("Items", class_2520.field_33260);
            for (int i = 0; i < list.size(); i++) {
                var nbt = list.method_10602(i);
                var stack = class_1799.method_57359(lookup, nbt);
                if (PolymerItemUtils.isPolymerServerItem(stack, context)) {
                    if (override == null) {
                        override = original.method_10553();
                    }
                    nbt = nbt.method_10553();
                    nbt.method_10551("id");
                    nbt.method_10551("components");
                    nbt.method_10551("count");
                    stack = PolymerItemUtils.getPolymerItemStack(stack, context);
                    override.method_10554("Items", class_2520.field_33260).method_10606(i, stack.method_7960() ? new class_2487() : stack.method_57376(lookup, nbt));
                }
            }
        }

        if (original.method_10573("item", class_2520.field_33260)) {
            var stack = class_1799.method_57359(lookup, original.method_10562("item"));
            if (PolymerItemUtils.isPolymerServerItem(stack, context)) {
                if (override == null) {
                    override = original.method_10553();
                }
                stack = PolymerItemUtils.getPolymerItemStack(stack, context);
                override.method_10566("item", stack.method_57375(lookup));
            }
        }

        if (original.method_10573("components", class_2520.field_33260)) {
            var ops = lookup.method_57093(class_2509.field_11560);

            var comp = class_9323.field_50234.decode(ops, original.method_10562("components"));
            if (comp.isSuccess()) {
                var map = comp.getOrThrow().getFirst();
                class_9323.class_9324 builder = null;

                for (var component : map) {
                    if (component.comp_2444() instanceof TransformingComponent transformingComponent && transformingComponent.polymer$requireModification(context)) {
                        if (builder == null) {
                            builder = class_9323.method_57827();
                            builder.method_57839(map);
                        }
                        //noinspection unchecked
                        builder.method_57840((class_9331<? super Object>) component.comp_2443(), transformingComponent.polymer$getTransformed(context));
                    } else if (!PolymerComponent.canSync(component.comp_2443(), component.comp_2444(), context)) {
                        if (builder == null) {
                            builder = class_9323.method_57827();
                            builder.method_57839(map);
                        }
                        builder.method_57840(component.comp_2443(), null);
                    }
                }

                if (builder != null) {
                    if (override == null) {
                        override = original.method_10553();
                    }
                    override.method_10566("components", class_9323.field_50234.encodeStart(ops, builder.method_57838()).result().orElse(new class_2487()));
                }
            }
        }

        return override != null ? override : original;
    }

    @FunctionalInterface
    public interface MineEventListener {
        boolean onBlockMine(class_2680 state, class_2338 pos, class_3222 player);
    }

    @FunctionalInterface
    public interface BreakingProgressListener {
        void onBreakingProgressUpdate(class_3222 player, class_2338 pos, class_2680 finalState, int i);
    }
}
