package eu.pb4.polymer.core.api.entity;

import com.mojang.datafixers.util.Pair;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2781;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_5629;

/**
 * Interface used for creation of server-side entities
 */
public interface PolymerEntity extends PolymerObject {
    /**
     * This method is used to determine what this entity will look like on client for specific player
     *
     * @return Vanilla/Modded entity type
     */
    class_1299<?> getPolymerEntityType(class_3222 player);

    /**
     * This method is used for replacing entity's equipment on client for a player
     *
     * @param items List of a Pair of EquipmentSlot and ItemStack on entity server-side
     * @return List of a Pair of EquipmentSlot and ItemStack sent to client
     */
    default List<Pair<class_1304, class_1799>> getPolymerVisibleEquipment(List<Pair<class_1304, class_1799>> items, class_3222 player) {
        return items;
    }

    /**
     * Allows sending packets before entity's spawn packet, useful for Player Entities
     */
    default void onBeforeSpawnPacket(class_3222 player, Consumer<class_2596<?>> packetConsumer) {}

    /**
     * This method allows to modify raw serialized DataTracker entries before they are send to the client
     * @param data Current values
     * @param initial
     */
    default void modifyRawTrackedData(List<class_2945.class_7834<?>> data, class_3222 player, boolean initial) {

    }

    default void modifyRawEntityAttributeData(List<class_2781.class_2782> data, PacketContext context, boolean initial) {

    }


    default void onEntityPacketSent(Consumer<class_2596<?>> consumer, class_2596<?> packet) {
        consumer.accept(packet);
    }

    /**
     * This method allows to modify position of entity on client
     * @param vec3d Real position
     * @return Client-side position
     */
    default class_243 getClientSidePosition(class_243 vec3d) {
        return vec3d;
    }

    /**
     * This method allows to modify yaw of entity on client
     * @param yaw Real yaw stateValue
     * @return Client-side yaw stateValue
     */
    default float getClientSideYaw(float yaw) {
        return yaw;
    }

    /**
     * This method allows to modify head yaw of entity on client
     * @param yaw Real yaw stateValue
     * @return Client-side yaw stateValue
     */
    default float getClientSideHeadYaw(float yaw) {
        return yaw;
    }

    /**
     * This method allows to modify pitch of entity on client
     * @param pitch Real pitch stateValue
     * @return Client-side pitch stateValue
     */
    default float getClientSidePitch(float pitch) {
        return pitch;
    }

    /**
     * Allows disabling sending packets to player
     * @param player
     * @return true to allow, false to disable
     */
    default boolean sendPacketsTo(class_3222 player) {
        return true;
    }

    /**
     * This method is executed after tracker tick
     */
    default void onEntityTrackerTick(Set<class_5629> listeners) {};

    default void beforeEntityTrackerTick(Set<class_5629> listeners) {}

    /**
     * Sends real id to clients with polymer
     */
    default boolean canSynchronizeToPolymerClient(class_3222 player) {
        return true;
    }

    default boolean sendEmptyTrackerUpdates(class_3222 player) {
        return true;
    }
}
