package eu.pb4.polymer.core.api.item;

import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;

/**
 * Interface used for creation of server-side items
 */
public interface PolymerItem extends PolymerSyncedObject<class_1792> {
    /**
     * Returns main/default item used on client for specific player
     *
     * @param itemStack ItemStack of virtual item
     * @param player    Player for which it's send
     * @return Vanilla (or other) Item instance
     */
    class_1792 getPolymerItem(class_1799 itemStack, @Nullable class_3222 player);

    /**
     * Method used for creation of client-side ItemStack
     *
     * @param itemStack Server-side ItemStack
     * @param player    Player for which it's send
     * @return Client-side ItemStack
     */
    default class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        return PolymerItemUtils.createItemStack(itemStack, tooltipType, lookup, player);
    }


    /**
     * Method used for getting custom model data of items
     *
     * @param itemStack Server-side ItemStack
     * @param player    Player for which it's send
     * @return Custom model data or -1 if not present
     */
    default int getPolymerCustomModelData(class_1799 itemStack, @Nullable class_3222 player) {
        return -1;
    }

    /**
     * Method used for getting custom armor color of items
     * It's designed to be used alongside {@link eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils#requestArmor(class_2960)}
     * Make sure colors isn't even so it won't get wrong texture
     *
     * @param itemStack Server-side ItemStack
     * @param player    Player for which it's send
     * @return Custom color or -1 if not present
     */
    default int getPolymerArmorColor(class_1799 itemStack, @Nullable class_3222 player) {
        return -1;
    }

    /**
     * This method allows to modify tooltip text
     * If you just want to add your own one, use {@link class_1792#method_7851(class_1799, class_1792.class_9635, List, class_1836)}
     *
     * @param tooltip Current tooltip text
     * @param stack   Server-side ItemStack
     * @param player  Target player
     */
    default void modifyClientTooltip(List<class_2561> tooltip, class_1799 stack, @Nullable class_3222 player) {
    }
    @Override
    default class_1792 getPolymerReplacement(class_3222 player) {
        return this.getPolymerItem(((class_1792) this).method_7854(), player);
    }

    default boolean handleMiningOnServer(class_1799 tool, class_2680 targetBlock, class_2338 pos, class_3222 player) {
        return false;
    }

    default boolean shouldStorePolymerItemStackCount() {
        return false;
    }
}