package eu.pb4.polymer.core.api.item;

import I;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.MapCodec;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.api.events.BooleanEvent;
import eu.pb4.polymer.common.api.events.FunctionEvent;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import eu.pb4.polymer.core.api.other.PolymerComponent;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.TransformingComponent;
import eu.pb4.polymer.core.impl.compat.polymc.PolyMcUtils;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import net.minecraft.class_5135;
import net.minecraft.class_6538;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8053;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9282;
import net.minecraft.class_9285;
import net.minecraft.class_9290;
import net.minecraft.class_9300;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.minecraft.class_9720;
import net.minecraft.class_9792;
import net.minecraft.component.type.*;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.*;
import java.util.Map.Entry;
import java.util.function.Predicate;

public final class PolymerItemUtils {
    public static final String POLYMER_STACK = "$polymer:stack";
    private static final String POLYMC_STACK = "PolyMcOriginal";
    public static final MapCodec<class_1799> POLYMER_STACK_CODEC = class_1799.field_24671.fieldOf(POLYMER_STACK);
    public static final MapCodec<class_1799> POLYMER_STACK_UNCOUNTED_CODEC = class_1799.field_49747.fieldOf(POLYMER_STACK);
    public static final MapCodec<Boolean> POLYMER_STACK_HAS_COUNT_CODEC = Codec.BOOL.optionalFieldOf("$polymer:counted", false);
    public static final MapCodec<class_2960> POLYMER_STACK_ID_CODEC = class_2960.field_25139.fieldOf("id").fieldOf(POLYMER_STACK);

    private static final Codec<Map<class_2960, class_2520>> COMPONENTS_CODEC = Codec.unboundedMap(class_2960.field_25139,
            Codec.PASSTHROUGH.comapFlatMap((dynamic) -> {
                var nbt = dynamic.convert(class_2509.field_11560).getValue();
                return DataResult.success(nbt == dynamic.getValue() ? nbt.method_10707() : nbt);
            }, (nbt) -> new Dynamic<>(class_2509.field_11560, nbt.method_10707())));

    public static final MapCodec<Map<class_2960, class_2520>> POLYMER_STACK_COMPONENTS_CODEC = COMPONENTS_CODEC
            .optionalFieldOf("components", Map.of()).fieldOf(POLYMER_STACK);


    private static final MapCodec<class_1799> POLYMC_STACK_CODEC = class_1799.field_49747.fieldOf(POLYMC_STACK);
    private static final MapCodec<class_2960> POLYMC_STACK_ID_CODEC = class_2960.field_25139.fieldOf("id").fieldOf(POLYMC_STACK);
    private static final MapCodec<Map<class_2960, class_2520>> POLYMC_STACK_COMPONENTS_CODEC = COMPONENTS_CODEC.optionalFieldOf("components", Map.of()).fieldOf(POLYMC_STACK);

    public static final class_2583 CLEAN_STYLE = class_2583.field_24360.method_10978(false).method_10977(class_124.field_1068);
    /**
     * Allows to force rendering of some items as polymer one (for example vanilla ones)
     */
    public static final BooleanEvent<Predicate<class_1799>> ITEM_CHECK = new BooleanEvent<>();
    /**
     * Allows to modify how virtual items looks before being sent to client (only if using build in methods!)
     * It can modify virtual version directly, as long as it's returned at the end.
     * You can also return new ItemStack, however please keep previous nbt so other modifications aren't removed if not needed!
     */
    public static final FunctionEvent<ItemModificationEventHandler, class_1799> ITEM_MODIFICATION_EVENT = new FunctionEvent<>();
    private static final class_9331<?>[] COMPONENTS_TO_COPY = {class_9334.field_49635, class_9334.field_49634,
            class_9334.field_49611, class_9334.field_49607,
            class_9334.field_50077,
            class_9334.field_50071,
            class_9334.field_50075,
            class_9334.field_50076,
            class_9334.field_49616,
            class_9334.field_49615,
            class_9334.field_49629,
            class_9334.field_50072,
            class_9334.field_49636,
            class_9334.field_49619,
            class_9334.field_49620,
            class_9334.field_50074,
            class_9334.field_49635,
            class_9334.field_49634,
            class_9334.field_49639,
            class_9334.field_49650,
            class_9334.field_50073,
            class_9334.field_49614,
            class_9334.field_49633,
            class_9334.field_49643,
            class_9334.field_49651,
            class_9334.field_49631,
            class_9334.field_52175,
            class_9334.field_49653,
            class_9334.field_49606,
            class_9334.field_49622,
    };
    @SuppressWarnings("rawtypes")
    private static final List<HideableTooltip> HIDEABLE_TOOLTIPS = List.of(
            HideableTooltip.of(class_9334.field_49636, class_9285::method_58423),
            HideableTooltip.of(class_9334.field_49607, class_8053::method_58421),
            HideableTooltip.ofNeg(class_9334.field_49633, class_9304::method_57543, class_9304::method_58449),
            HideableTooltip.ofNeg(class_9334.field_49643, class_9304::method_57543, class_9304::method_58449),
            HideableTooltip.of(class_9334.field_49630, class_9300::method_58435),
            HideableTooltip.of(class_9334.field_49635, class_6538::method_58402),
            HideableTooltip.of(class_9334.field_49634, class_6538::method_58402),
            HideableTooltip.of(class_9334.field_52175, class_9792::method_60749)
    );
    private static final Set<class_1741> ARMOR_MATERIALS = new ReferenceOpenHashSet<>();

    private PolymerItemUtils() {
    }

    /**
     * This method creates a client side ItemStack representation
     *
     * @param itemStack Server side ItemStack
     * @param context   Networking context
     * @return Client side ItemStack
     */
    public static class_1799 getPolymerItemStack(class_1799 itemStack, PacketContext context) {
        return getPolymerItemStack(itemStack, context.getRegistryWrapperLookup() != null ? context.getRegistryWrapperLookup() : PolymerImplUtils.FALLBACK_LOOKUP,
                context.getPlayer());
    }

    /**
     * This method creates a client side ItemStack representation
     *
     * @param itemStack Server side ItemStack
     * @param player    Player being sent to
     * @return Client side ItemStack
     */
    public static class_1799 getPolymerItemStack(class_1799 itemStack, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        return getPolymerItemStack(itemStack, PolymerUtils.getTooltipType(player), lookup, player);
    }

    /**
     * This method creates a client side ItemStack representation
     *
     * @param itemStack      Server side ItemStack
     * @param tooltipContext Tooltip Context
     * @param player         Player being sent to
     * @return Client side ItemStack
     */
    public static class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipContext, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        if (getPolymerIdentifier(itemStack) != null) {
            return itemStack;
        } else if (itemStack.method_7909() instanceof PolymerItem item) {
            return item.getPolymerItemStack(itemStack, tooltipContext, lookup, player);
        } else if (isPolymerServerItem(itemStack, player)) {
            return createItemStack(itemStack, tooltipContext, lookup, player);
        }

        if (ITEM_CHECK.invoke((x) -> x.test(itemStack))) {
            return createItemStack(itemStack, tooltipContext, lookup, player);
        }

        return itemStack;
    }

    /**
     * This method gets real ItemStack from Virtual/Client side one
     *
     * @param itemStack Client side ItemStack
     * @return Server side ItemStack
     */
    public static class_1799 getRealItemStack(class_1799 itemStack, class_7225.class_7874 lookup) {
        var custom = itemStack.method_57824(class_9334.field_49628);

        if (custom != null && custom.method_57450(POLYMER_STACK)) {
            try {
                var counted = custom.method_57446(POLYMER_STACK_HAS_COUNT_CODEC).result().orElse(Boolean.FALSE);

                //noinspection deprecation
                var x = (counted ? POLYMER_STACK_CODEC : POLYMER_STACK_UNCOUNTED_CODEC).decode(class_6903.method_46632(class_2509.field_11560, lookup), class_2509.field_11560.method_29163(custom.method_57463()).getOrThrow()).getOrThrow();

                if (!counted) {
                    x.method_7939(itemStack.method_7947());
                }

                return x;
            } catch (Throwable exception) {
                if (CommonImpl.LOG_MORE_ERRORS) {
                    var context = PacketContext.get();
                    class_2520 nbt = null;
                    try {
                        nbt = itemStack.method_57375(lookup);
                    } catch (Throwable e) {
                        CommonImpl.LOGGER.error("Failed to encode ItemStack for debugging! See lower warning for more info!", exception);
                    }

                    CommonImpl.LOGGER.warn("Failed to decode seemingly polymeric ItemStack for {}!\nClient item data: {}",
                            context.getGameProfile() != null ? context.getGameProfile().getName() : "<UNKNOWN>",
                            nbt != null ? class_2512.method_36118(nbt) : "<ERROR>",
                            exception);
                }
            }
        }

        return itemStack;
    }

    /**
     * Returns stored identifier of Polymer ItemStack. If it's invalid, null is returned instead.
     */
    @Nullable
    public static class_2960 getPolymerIdentifier(class_1799 itemStack) {
        return getPolymerIdentifier(itemStack.method_57824(class_9334.field_49628));
    }

    public static class_2960 getPolymerIdentifier(@Nullable class_9279 custom) {
        if (custom != null && custom.method_57450(POLYMER_STACK)) {
            try {
                return custom.method_57446(POLYMER_STACK_ID_CODEC).result().orElse(null);
            } catch (Throwable ignored) {

            }
        }

        return null;
    }

    /**
     * Returns stored identifier of Polymer/other supported server mod ItemStack. If it's invalid, null is returned instead.
     */
    @Nullable
    public static class_2960 getServerIdentifier(class_1799 itemStack) {
        return getServerIdentifier(itemStack.method_57824(class_9334.field_49628));
    }

    @Nullable
    public static class_2960 getServerIdentifier(@Nullable class_9279 nbtData) {
        if (nbtData == null) {
            return null;
        }
        var x = getPolymerIdentifier(nbtData);
        if (x != null) {
            return x;
        }

        if (nbtData.method_57450(POLYMC_STACK)) {
            try {
                return nbtData.method_57446(POLYMC_STACK_ID_CODEC).result().orElse(null);
            } catch (Throwable ignored) {

            }
        }

        return null;
    }

    @Nullable
    public static Map<class_2960, class_2520> getServerComponents(class_1799 stack) {
        return getServerComponents(stack.method_57824(class_9334.field_49628));
    }

    @Nullable
    public static Map<class_2960, class_2520> getPolymerComponents(class_1799 stack) {
        return getPolymerComponents(stack.method_57824(class_9334.field_49628));
    }

    @Nullable
    public static Map<class_2960, class_2520> getServerComponents(@Nullable class_9279 nbtData) {
        if (nbtData == null) {
            return null;
        }
        var x = getPolymerComponents(nbtData);
        if (x != null) {
            return x;
        }

        if (nbtData.method_57450(POLYMC_STACK)) {
            try {
                return nbtData.method_57446(POLYMC_STACK_COMPONENTS_CODEC).result().orElse(Map.of());
            } catch (Throwable ignored) {

            }
        }

        return null;
    }

    @Nullable
    public static Map<class_2960, class_2520> getPolymerComponents(@Nullable class_9279 nbtData) {
        if (nbtData == null || getPolymerIdentifier(nbtData) == null) {
            return null;
        }

        return nbtData.method_57446(POLYMER_STACK_COMPONENTS_CODEC).result().orElse(Map.of());
    }

    public static boolean isPolymerServerItem(class_1799 itemStack) {
        return isPolymerServerItem(itemStack, PolymerUtils.getPlayerContext());
    }

    public static boolean isPolymerServerItem(class_1799 itemStack, PacketContext context) {
        return isPolymerServerItem(itemStack, context.getPlayer());
    }

    public static boolean isPolymerServerItem(class_1799 itemStack, @Nullable class_3222 player) {
        if (getPolymerIdentifier(itemStack) != null) {
            return false;
        }
        if (itemStack.method_7909() instanceof PolymerItem) {
            return true;
        }
        var ctx = PacketContext.get();
        if (player != null && ctx.getPlayer() != player) {
            ctx = PacketContext.of(player);
        }

        for (var x : itemStack.method_57380().method_57846()) {
            if (!PolymerComponent.canSync(x.getKey(), x.getValue().orElse(null), ctx)) {
                return true;
            } else if (x.getValue() != null && x.getValue().isPresent()
                    && x.getValue().get() instanceof TransformingComponent t
                    && t.polymer$requireModification(ctx)) {
                return true;
            }
        }

        if (itemStack.method_57826(class_9334.field_49633) && itemStack.method_57825(class_9334.field_49636, class_9285.field_49326).comp_2394()) {
            for (var ench : itemStack.method_57825(class_9334.field_49633, class_9304.field_49385).method_57534()) {
                var attributes = ench.comp_349().method_60034(class_9701.field_51668);
                if (attributes != null) {
                    for (var attr : attributes) {
                        if (PolymerEntityUtils.isPolymerEntityAttribute(attr.comp_2718())
                                && class_5135.method_26873(class_1299.field_6097).method_27310(attr.comp_2718())) {
                            return true;
                        }
                    }
                }
            }
        }

        if (CompatStatus.POLYMER_RESOURCE_PACK) {
            var display = itemStack.method_57824(class_9334.field_49644);
            if (display != null) {
                return PolymerResourcePackUtils.isColorTaken(display.comp_2384());
            }
        }


        return ITEM_CHECK.invoke((x) -> x.test(itemStack));
    }

    /**
     * This method creates minimal representation of ItemStack
     *
     * @param itemStack Server side ItemStack
     * @param player    Player seeing it
     * @return Client side ItemStack
     */
    public static class_1799 createMinimalItemStack(class_1799 itemStack, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        class_1792 item = itemStack.method_7909();
        var x = itemStack.method_57824(class_9334.field_49637);
        int cmd = x != null ? x.comp_2382() : -1;
        if (itemStack.method_7909() instanceof PolymerItem virtualItem) {
            var data = PolymerItemUtils.getItemSafely(virtualItem, itemStack, player);
            item = data.item();
            cmd = data.customModelData();
        }

        class_1799 out = new class_1799(item, itemStack.method_7947());

        try {
            PolymerCommonUtils.executeWithoutNetworkingLogic(() -> {
                out.method_57379(class_9334.field_49628, class_9279.method_57456(
                        (class_2487) POLYMER_STACK_CODEC.encoder().encodeStart(class_6903.method_46632(class_2509.field_11560, lookup), itemStack).getOrThrow()
                ));
            });
        } catch (Throwable e) {
            out.method_57379(class_9334.field_49628, class_9279.field_49302.method_57447(class_6903.method_46632(class_2509.field_11560, lookup), POLYMER_STACK_ID_CODEC, class_7923.field_41178.method_10221(itemStack.method_7909())).getOrThrow());
        }

        if (cmd != -1) {
            out.method_57379(class_9334.field_49637, new class_9280(cmd));
        }

        return out;
    }

    public static int getSafeColor(int inputColor) {
        if (inputColor % 2 == 1) {
            return Math.max(0, inputColor - 1);
        }
        return inputColor;
    }

    /**
     * This method creates full (vanilla like) representation of ItemStack
     *
     * @param itemStack Server side ItemStack
     * @param player    Player seeing it
     * @return Client side ItemStack
     */

    public static class_1799 createItemStack(class_1799 itemStack, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        return createItemStack(itemStack, PolymerUtils.getTooltipType(player), lookup, player);
    }

    /**
     * This method creates full (vanilla like) representation of ItemStack
     *
     * @param itemStack      Server side ItemStack
     * @param tooltipContext TooltipContext
     * @param player         Player seeing it
     * @return Client side ItemStack
     */
    public static class_1799 createItemStack(class_1799 itemStack, class_1836 tooltipContext, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        class_1792 item = itemStack.method_7909();
        int cmd = -1;
        int color = -1;
        boolean storeCount;
        if (itemStack.method_7909() instanceof PolymerItem virtualItem) {
            var data = PolymerItemUtils.getItemSafely(virtualItem, itemStack, player);
            item = data.item();
            cmd = data.customModelData();
            color = data.color();
            storeCount = virtualItem.shouldStorePolymerItemStackCount();
        } else {
            storeCount = false;
        }

        class_1799 out = new class_1799(item, itemStack.method_7947());
        for (var x : out.method_57353().method_57831()) {
            if (itemStack.method_57353().method_57829(x) == null) {
                out.method_57379(x, null);
            }
        }

        var ctx = PacketContext.get();
        if (player != null && ctx.getPlayer() != player) {
            ctx = PacketContext.of(player);
        }

        for (var i = 0; i < COMPONENTS_TO_COPY.length; i++) {
            var key = COMPONENTS_TO_COPY[i];
            var x = itemStack.method_57824(key);

            if (x instanceof TransformingComponent t) {
                //noinspection unchecked,rawtypes
                out.method_57379((class_9331) key, t.polymer$getTransformed(ctx));
            } else {
                //noinspection unchecked,rawtypes
                out.method_57379((class_9331) key, (Object) itemStack.method_57824(key));
            }
        }
        try {
            PolymerCommonUtils.executeWithoutNetworkingLogic(() -> {
                var comp = class_9279.method_57456(
                        (class_2487) (storeCount ? POLYMER_STACK_CODEC : POLYMER_STACK_UNCOUNTED_CODEC).encoder()
                                .encodeStart(class_6903.method_46632(class_2509.field_11560, lookup), itemStack).getOrThrow()
                );
                if (storeCount) {
                    out.method_57379(class_9334.field_49628, comp.method_57447(class_6903.method_46632(class_2509.field_11560, lookup), POLYMER_STACK_HAS_COUNT_CODEC, true).getOrThrow());
                } else {
                    out.method_57379(class_9334.field_49628, comp);
                }
            });
        } catch (Throwable e) {
            out.method_57379(class_9334.field_49628, class_9279.field_49302.method_57447(class_6903.method_46632(class_2509.field_11560, lookup), POLYMER_STACK_ID_CODEC, class_7923.field_41178.method_10221(itemStack.method_7909())).getOrThrow());
        }


        if (cmd == -1 && itemStack.method_57826(class_9334.field_49637)) {
            out.method_57379(class_9334.field_49637, itemStack.method_57824(class_9334.field_49637));
        } else if (cmd != -1) {
            out.method_57379(class_9334.field_49637, new class_9280(cmd));
        }

        if (color == -1 && itemStack.method_57826(class_9334.field_49644)) {
            out.method_57379(class_9334.field_49644, new class_9282(getSafeColor(itemStack.method_57824(class_9334.field_49644).comp_2384()), false));
        } else if (color != -1) {
            out.method_57379(class_9334.field_49644, new class_9282(color, false));
        }

        out.method_57379(class_9334.field_49638, class_3902.field_17274);

        for (var x : HIDEABLE_TOOLTIPS) {
            var a = out.method_57824(x.type);
            //noinspection unchecked
            if (a != null && x.shouldSet.test(a)) {
                //noinspection unchecked
                out.method_57379(x.type, x.setter.setTooltip(a, false));
            }
        }

        out.method_57379(class_9334.field_49641, itemStack.method_7958());

        try {
            var tooltip = itemStack.method_7950(player != null ? class_1792.class_9635.method_59528(player.method_37908()) : class_1792.class_9635.field_51353, player, tooltipContext);
            if (!tooltip.isEmpty()) {
                out.method_57379(class_9334.field_50239, tooltip.remove(0));

                if (itemStack.method_7909() instanceof PolymerItem) {
                    ((PolymerItem) itemStack.method_7909()).modifyClientTooltip(tooltip, itemStack, player);
                }

                var lore = new ArrayList<class_2561>();
                for (class_2561 t : tooltip) {
                    lore.add(class_2561.method_43473().method_10852(t).method_10862(PolymerItemUtils.CLEAN_STYLE));
                }
                out.method_57379(class_9334.field_49632, new class_9290(lore));
            }
        } catch (Throwable e) {
            if (PolymerImpl.LOG_MORE_ERRORS) {
                PolymerImpl.LOGGER.error("Failed to get tooltip of " + itemStack, e);
            }
            out.method_57379(class_9334.field_50239, itemStack.method_57825(class_9334.field_50239,
                    itemStack.method_7909().method_7864(itemStack)));
        }
        return ITEM_MODIFICATION_EVENT.invoke((col) -> {
            var custom = out;

            for (var in : col) {
                custom = in.modifyItem(itemStack, custom, player);
            }

            return custom;
        });
    }

    /**
     * This method is minimal wrapper around {@link PolymerItem#getPolymerItem(class_1799, class_3222)} to make sure
     * It gets replaced if it represents other PolymerItem
     *
     * @param item        PolymerItem
     * @param stack       Server side ItemStack
     * @param maxDistance Maximum number of checks for nested virtual blocks
     * @return Client side ItemStack
     */
    public static ItemWithMetadata getItemSafely(PolymerItem item, class_1799 stack, @Nullable class_3222 player, int maxDistance) {
        class_1792 out = item.getPolymerItem(stack, player);
        PolymerItem lastVirtual = item;

        int req = 0;
        while (out instanceof PolymerItem newItem && newItem != item && req < maxDistance) {
            out = newItem.getPolymerItem(stack, player);
            lastVirtual = newItem;
            req++;
        }
        return new ItemWithMetadata(out, lastVirtual.getPolymerCustomModelData(stack, player), lastVirtual.getPolymerArmorColor(stack, player));
    }

    /**
     * This method is minimal wrapper around {@link PolymerItem#getPolymerItem(class_1799, class_3222)} to make sure
     * It gets replaced if it represents other PolymerItem
     *
     * @param item  PolymerItem
     * @param stack Server side ItemStack
     * @return Client side ItemStack
     */
    public static ItemWithMetadata getItemSafely(PolymerItem item, class_1799 stack, @Nullable class_3222 player) {
        return getItemSafely(item, stack, player, PolymerBlockUtils.NESTED_DEFAULT_DISTANCE);
    }

    /**
     * Marks ArmorMaterial as server-side only
     *
     * @param types ArmorMaterials
     */
    @SafeVarargs
    public static void registerArmorMaterial(class_6880<class_1741>... types) {
        for (var type : types) {
            RegistrySyncUtils.setServerEntry(class_7923.field_48976, type.comp_349());
            ARMOR_MATERIALS.add(type.comp_349());

        }
    }

    /**
     * Checks if ArmorMaterial is server-side only
     *
     * @param type ArmorMaterials
     */
    public static boolean isPolymerArmorMaterial(class_6880<class_1741> type) {
        return ARMOR_MATERIALS.contains(type.comp_349());
    }

    /**
     * @deprecated Use {@link PolymerComponent#registerDataComponent(class_9331[])} instead
     */
    @Deprecated
    public static void markAsPolymer(class_9331<?>... types) {
        PolymerComponent.registerDataComponent(types);
    }

    /**
     * @deprecated Use {@link PolymerComponent#isPolymerComponent(class_9331)} instead
     */
    @Deprecated
    public static boolean isPolymerComponent(class_9331<?> type) {
        return PolymerComponent.isPolymerComponent(type);
    }

    public static class_1799 getClientItemStack(class_1799 stack, class_3222 player) {
        var out = getPolymerItemStack(stack, player.method_56673(), player);
        if (CompatStatus.POLYMC) {
            out = PolyMcUtils.toVanilla(out, player);
        }
        return out;
    }

    @FunctionalInterface
    public interface ItemModificationEventHandler {
        class_1799 modifyItem(class_1799 original, class_1799 client, class_3222 player);
    }

    public record ItemWithMetadata(class_1792 item, int customModelData, int color) {
    }

    private record HideableTooltip<T>(class_9331<T> type, Predicate<T> shouldSet, TooltipSetter<T> setter) {

        public static <T> HideableTooltip<T> of(class_9331<T> type, TooltipSetter<T> setter) {
            return new HideableTooltip<>(type, x -> true, setter);
        }

        public static <T> HideableTooltip<T> of(class_9331<T> type, Predicate<T> shouldSet, TooltipSetter<T> setter) {
            return new HideableTooltip<>(type, shouldSet, setter);
        }

        public static <T> HideableTooltip<T> ofNeg(class_9331<T> type, Predicate<T> shouldntSet, TooltipSetter<T> setter) {
            return new HideableTooltip<>(type, shouldntSet.negate(), setter);
        }

        interface TooltipSetter<T> {
            T setTooltip(T val, boolean value);
        }
    }
}
