package eu.pb4.polymer.core.api.item;

import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_7709;
import net.minecraft.class_7710;
import net.minecraft.class_8060;
import net.minecraft.recipe.*;
import org.jetbrains.annotations.Nullable;

/**
 * Interface used for creation of server-side recipes
 */
public interface PolymerRecipe extends PolymerSyncedObject<class_1860<?>> {
    /**
     * Returns client-side recipe used on client for specific player
     * This allows the client to still display Recipe Unlocked toast messages to the player.
     *
     * The provided methods for generating a recipe unsure that the
     * recipe will not appear in the incorrect recipe book screen.
     * @see PolymerRecipe#createBlastingRecipe(class_1860) - For a Blast Furnace Toast Icon
     * @see PolymerRecipe#createCraftingRecipe(class_1860) - For a Crafting Table Toast Icon
     * @see PolymerRecipe#createCampfireCookingRecipe(class_1860) - For a Campfire Toast Icon
     * @see PolymerRecipe#createSmeltingRecipe(class_1860) - For a Furnace Toast Icon
     * @see PolymerRecipe#createSmithingRecipe(class_1860) - For a Smithing Table Toast Icon
     * @see PolymerRecipe#createSmokingRecipe(class_1860) - For a Smoker Toast Icon
     * @see PolymerRecipe#createStonecuttingRecipe(class_1860) - For a Stonecutter Toast Icon
     *
     * @param player Player recipe is send to
     * @return Vanilla (or other) Recipe instance, or null if the recipe is hidden from the client
     */
    @Nullable
    @Override
    default class_1860<?> getPolymerReplacement(class_3222 player) {
        return null;
    }

    /**
     * Make the client display as a {@link class_3956#field_17547}.
     * Icon Used: {@link class_1802#field_16306}
     * @param input the Modded recipe
     * @return the Vanilla recipe
     */
    static class_1860<?> createBlastingRecipe(class_1860<?> input) {
        return new class_3859("impossible", class_7709.field_40244, class_1856.field_9017, input.method_8110(null), 0, 0);
    }

    /**
     * Make the client display as a {@link class_3956#field_17545}.
     * Icon Used: {@link class_1802#field_8465}
     * @param input the Modded recipe
     * @return the Vanilla recipe
     */
    static class_1860<?> createCraftingRecipe(class_1860<?> input) {
        return new class_1867("impossible", class_7710.field_40251, input.method_8110(null), class_2371.method_10211());
    }

    /**
     * Make the client display as a {@link class_3956#field_17549}.
     * Icon Used: {@link class_1802#field_17346}
     * @param input the Modded recipe
     * @return the Vanilla recipe
     */
    static class_1860<?> createCampfireCookingRecipe(class_1860<?> input) {
        return new class_3920("impossible", class_7709.field_40244, class_1856.field_9017, input.method_8110(null), 0, 0);
    }

    /**
     * Make the client display as a {@link class_3956#field_17546}.
     * Icon Used: {@link class_1802#field_8732}
     * @param input the Modded recipe
     * @return the Vanilla recipe
     */
    static class_1860<?> createSmeltingRecipe(class_1860<?> input) {
        return new class_3861("impossible", class_7709.field_40244, class_1856.field_9017, input.method_8110(null), 0, 0);
    }

    /**
     * Make the client display as a {@link class_3956#field_25388}.
     * Icon Used: {@link class_1802#field_16308}
     * @param input the Modded recipe
     * @return the Vanilla recipe
     */
    static class_1860<?> createSmithingRecipe(class_1860<?> input) {
        return new class_8060(class_1856.field_9017, class_1856.field_9017, class_1856.field_9017, input.method_8110(null));
    }

    /**
     * Make the client display as a {@link class_3956#field_17548}.
     * Icon Used: {@link class_1802#field_16309}
     * @param input the Modded recipe
     * @return the Vanilla recipe
     */
    static class_1860<?> createSmokingRecipe(class_1860<?> input) {
        return new class_3862("impossible", class_7709.field_40244, class_1856.field_9017, input.method_8110(null), 0, 0);
    }

    /**
     * Make the client display as a {@link class_3956#field_17641}.
     * Icon Used: {@link class_1802#field_16305}
     * @param input the Modded recipe
     * @return the Vanilla recipe
     */
    static class_1860<?> createStonecuttingRecipe(class_1860<?> input) {
        return new class_3975("impossible", class_1856.field_9017, input.method_8110(null));
    }
}
