package eu.pb4.polymer.core.api.other;

import com.mojang.serialization.*;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_9704;
import net.minecraft.class_9712;
import net.minecraft.class_9721;
import net.minecraft.class_9722;
import net.minecraft.class_9723;

public class PolymerMapCodec<T> extends MapCodec<T> implements PolymerObject {
    private final MapCodec<T> selfCodec;
    private final MapCodec<Object> fallbackCodec;
    private final Object fallbackValue;

    public <K> PolymerMapCodec(MapCodec<T> selfCodec, MapCodec<K> fallbackCodec, K fallbackValue) {
        this.selfCodec = selfCodec;
        //noinspection unchecked
        this.fallbackCodec = (MapCodec<Object>) fallbackCodec;
        this.fallbackValue = fallbackValue;
    }

    public static <T extends class_9723> MapCodec<T> ofEnchantmentValueEffect(MapCodec<T> codec) {
        return new PolymerMapCodec<T>(codec, class_9712.class_9715.field_51700, new class_9712.class_9715(List.of()));
    }

    public static <T extends class_9722> MapCodec<T> ofEnchantmentLocationBasedEffect(MapCodec<T> codec) {
        return new PolymerMapCodec<T>(codec, class_9712.class_9714.field_51699, new class_9712.class_9714(List.of()));
    }

    public static <T extends class_9721> MapCodec<T> ofEnchantmentEntityEffect(MapCodec<T> codec) {
        return new PolymerMapCodec<T>(codec, class_9712.class_9713.field_51698, new class_9712.class_9713(List.of()));
    }

    public static <T extends class_9704> MapCodec<T> ofEnchantmentLevelBasedValue(MapCodec<T> codec) {
        return new PolymerMapCodec<T>(codec, class_9704.class_9706.field_51693, new class_9704.class_9706(0));
    }

    public Object fallbackValue() {
        return fallbackValue;
    }

    public MapCodec<Object> fallbackCodec() {
        return fallbackCodec;
    }

    @Override
    public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
        return this.selfCodec.keys(ops);
    }

    @Override
    public <T1> DataResult<T> decode(DynamicOps<T1> ops, MapLike<T1> input) {
        return this.selfCodec.decode(ops, input);
    }

    @Override
    public <T1> RecordBuilder<T1> encode(T input, DynamicOps<T1> ops, RecordBuilder<T1> prefix) {
        if (PolymerCommonUtils.isServerNetworkingThreadWithContext()) {
            return this.fallbackCodec.encode(this.fallbackValue, ops, prefix);
        }

        return this.selfCodec.encode(input, ops, prefix);
    }
}
