package eu.pb4.polymer.core.api.other;

import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

/**
 * This class allows for creation of custom sound effects
 * It can be used to play custom sounds for players with resourcepack while keeping fallback for vanilla clients
 */
public class PolymerSoundEvent extends class_3414 implements PolymerSyncedObject<class_3414> {
    @Nullable
    protected final class_3414 polymerSound;

    @Nullable
    protected final UUID source;

    public static PolymerSoundEvent of(class_2960 identifier, @Nullable class_3414 vanillaEvent) {
        return new PolymerSoundEvent(null, identifier, 16.0F, false, vanillaEvent);
    }

    static PolymerSoundEvent of(class_2960 identifier, float distanceToTravel, @Nullable class_3414 vanillaEvent) {
        return new PolymerSoundEvent(null, identifier, distanceToTravel, true, vanillaEvent);
    }

    public static PolymerSoundEvent of(UUID uuid, class_2960 identifier, @Nullable class_3414 vanillaEvent) {
        return new PolymerSoundEvent(uuid, identifier, 16.0F, false, vanillaEvent);
    }

    static PolymerSoundEvent of(UUID uuid, class_2960 identifier, float distanceToTravel, @Nullable class_3414 vanillaEvent) {
        return new PolymerSoundEvent(uuid, identifier, distanceToTravel, true, vanillaEvent);
    }

    public PolymerSoundEvent(@Nullable UUID uuid, class_2960 id, float distanceToTravel, boolean useStaticDistance, @Nullable class_3414 vanillaEvent) {
        super(id, distanceToTravel, useStaticDistance);
        this.source = uuid;
        this.polymerSound = vanillaEvent;
    }

    @Override
    public class_3414 getPolymerReplacement(class_3222 player) {
        return this.source == null || this.polymerSound == null || PolymerUtils.hasResourcePack(player, this.source) ? this : (this.polymerSound instanceof PolymerSoundEvent pe ? pe.getPolymerReplacement(player) : this.polymerSound);
    }
}
