package eu.pb4.polymer.core.api.utils;

import net.minecraft.class_2378;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

/**
 * Used to mark client-synchronized polymer objects like BlockEntities, Enchantments, Recipes, etc
 */

public interface PolymerSyncedObject<T> extends PolymerObject {

    /**
     * Generic method to get polymer replacement sent to player
     *
     * @param player target player
     * @return a replacement. It shouldn't be a null unless specified otherwise
     */
    T getPolymerReplacement(class_3222 player);

    /**
     * Allows to gate syncing of this object with clients running polymer
     */
    default boolean canSynchronizeToPolymerClient(class_3222 player) {
        return true;
    }

    /**
     * Allows to mark it to still send it to supported clients (for client optional setups)
     * Currently used for tags
     */
    default boolean canSyncRawToClient(@Nullable class_3222 player) {
        return false;
    }

    @Deprecated
    static boolean canSyncRawToClient(Object obj, class_3222 player) {
        return obj instanceof PolymerSyncedObject<?> pol ? pol.canSyncRawToClient(player) : !PolymerUtils.isServerOnly(obj);
    }

    static <T> boolean canSyncRawToClient(class_2378<T> registry, T obj, class_3222 player) {
        return obj instanceof PolymerSyncedObject<?> pol ? pol.canSyncRawToClient(player) : !PolymerUtils.isServerOnly(registry, obj);
    }
}
