package eu.pb4.polymer.core.impl;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.core.api.block.BlockMapper;
import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.api.other.PolymerStat;
import eu.pb4.polymer.core.api.utils.PolymerSyncUtils;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.compat.ServerTranslationUtils;
import eu.pb4.polymer.core.impl.networking.PolymerServerProtocol;
import eu.pb4.polymer.core.impl.ui.CreativeTabListUi;
import eu.pb4.polymer.core.impl.ui.CreativeTabUi;
import eu.pb4.polymer.core.impl.ui.PotionUi;
import eu.pb4.polymer.core.mixin.block.PalettedContainerAccessor;
import eu.pb4.polymer.networking.impl.ExtClientConnection;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap.Entry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import javax.naming.spi.StateFactory;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1675;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2841.class_6561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3908;
import net.minecraft.class_3916;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import net.minecraft.class_5628;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import D;
import I;
import Z;

@SuppressWarnings("ResultOfMethodCallIgnored")
@ApiStatus.Internal
public class Commands {
    public static void register(LiteralArgumentBuilder<class_2168> command, class_7157 access) {
        command.then(method_9247("stats")
                        .requires(CommonImplUtils.permission("command.stats", 0))
                        .executes(Commands::statsGeneral)
                        .then(method_9244("type", class_7733.method_45603(access, class_7924.field_41226)).executes(Commands::stats))
                )
                .then(method_9247("effects")
                        .requires(CommonImplUtils.permission("command.effects", 0))
                        .executes(Commands::effects)
                )
                .then(method_9247("client-item")
                        .requires(CommonImplUtils.permission("command.client-item", 3))
                        .executes(Commands::displayClientItem)
                        .then(method_9247("get").executes(Commands::getClientItem))
                )
                .then(method_9247("export-registry")
                        .requires(CommonImplUtils.permission("command.export-registry", 3))
                        .executes(Commands::dumpRegistries)
                )
                .then(method_9247("target-block")
                        .requires(CommonImplUtils.permission("command.target-block", 3))
                        .executes(Commands::targetBlock)
                )
                .then(method_9247("target-item")
                        .requires(CommonImplUtils.permission("command.target-item", 3))
                        .executes(Commands::targetItem)
                )
                .then(method_9247("pick")
                        .requires(CommonImplUtils.permission("command.pick", 0))
                        .executes((ctx) -> Commands.pickTarget(ctx, false))
                        .then(
                                method_9247("withnbt").executes((ctx) -> Commands.pickTarget(ctx, true))
                        )

                )
                .then(method_9247("creative")
                        .requires(CommonImplUtils.permission("command.creative", 0))
                        .then(method_9244("itemGroup", class_2232.method_9441())
                                .suggests((context, builder) -> {
                                    var remaining = builder.getRemaining().toLowerCase(Locale.ROOT);

                                    var groups = PolymerItemGroupUtils.getItemGroups(context.getSource().method_9207());

                                    class_2172.method_9268(groups, remaining, class_7923.field_44687::method_10221, group -> builder.suggest(class_7923.field_44687.method_10221(group).toString(), group.method_7737()));
                                    return builder.buildFuture();
                                })
                                .executes(Commands::creativeTab)
                        )
                        .executes(Commands::creativeTab));
    }

    private static int pickTarget(CommandContext<class_2168> serverCommandSourceCommandContext, boolean withNbt) throws CommandSyntaxException {
        var player = serverCommandSourceCommandContext.getSource().method_9207();
        var range = player.method_55755();

        var min = player.method_5836(0);
        var rot = player.method_5828(0);
        var max = min.method_1031(rot.field_1352 * range, rot.field_1351 * range, rot.field_1350 * range);

        var box = player.method_5829().method_18804(rot.method_1021(range)).method_1009(1.0, 1.0, 1.0);
        var entityHit = class_1675.method_18075(player, min, max, box, entity -> !player.method_7325() && entity.method_5863(), range);

        if (entityHit != null) {
            PolymerImplUtils.pickEntity(player, entityHit.method_17782());
            return 1;
        }

        var hit = player.method_5745(player.method_55754(), 0, false);
        if (hit instanceof class_3965 result && hit.method_17783() != class_239.class_240.field_1333) {
            PolymerImplUtils.pickBlock(player, result.method_17777(), withNbt);
            return 2;
        }

        return 0;
    }

    public static void registerDev(LiteralArgumentBuilder<class_2168> dev) {
        dev
                .then(method_9247("reload-world")
                        .executes((ctx) -> {
                            PolymerUtils.reloadWorld(ctx.getSource().method_44023());
                            return 0;
                        })
                )
                .then(method_9247("get-mapper")
                        .executes((ctx) -> {
                            ctx.getSource().method_9226(() -> class_2561.method_43470(BlockMapper.getFrom(ctx.getSource().method_44023()).getMapperName()), false);
                            return 0;
                        })
                )
                .then(method_9247("reset-mapper")
                        .executes((ctx) -> {
                            BlockMapper.resetMapper(ctx.getSource().method_44023());
                            return 0;
                        })
                )
                .then(method_9247("run-sync")
                        .executes((ctx) -> {
                            PolymerSyncUtils.synchronizePolymerRegistries(ctx.getSource().method_44023().field_13987);
                            return 0;
                        }))
                .then(method_9247("protocol-info")
                        .executes((ctx) -> {
                            ctx.getSource().method_9226(() -> class_2561.method_43470("Protocol supported by your client:"), false);
                            for (var entry : ExtClientConnection.of(ctx.getSource().method_44023().field_13987).polymerNet$getSupportMap().object2IntEntrySet()) {
                                ctx.getSource().method_9226(() -> class_2561.method_43470("- " + entry.getKey() + " = " + entry.getIntValue()), false);
                            }
                            return 0;
                        })
                )
                .then(method_9247("validate_states")
                        .executes((ctx) -> {
                            PolymerServerProtocol.sendDebugValidateStatesPackets(ctx.getSource().method_44023().field_13987);
                            return 0;
                        })
                )
                .then(method_9247("set-pack-status")
                        .then(method_9244("status", BoolArgumentType.bool())
                                .then(method_9244("uuid", class_5242.method_27643())
                                        .executes((ctx) -> {
                                            var status = ctx.getArgument("status", Boolean.class);
                                            PolymerCommonUtils.setHasResourcePack(ctx.getSource().method_9207(), class_5242.method_27645(ctx, "uuid"), status);
                                            ctx.getSource().method_9226(() -> class_2561.method_43470("New resource pack status: " + status), false);
                                            return 0;
                                        }))
                        )
                )
                .then(method_9247("get-pack-status")
                        .executes((ctx) -> {
                            var status = PolymerUtils.hasResourcePack(ctx.getSource().method_44023(), PolymerResourcePackUtils.getMainUuid());
                            ctx.getSource().method_9226(() -> class_2561.method_43470("Resource pack status: " + status), false);
                            return 0;
                        })
                )
                .then(method_9247("chunk_section_info")
                        .executes((ctx) -> {
                            var chunk = ctx.getSource().method_9225().method_22350(ctx.getSource().method_44023().method_24515());
                            var s = chunk.method_38259(ctx.getSource().method_9225().method_31602(ctx.getSource().method_44023().method_31478()));

                            var a = ((PalettedContainerAccessor<class_2680>) s.method_12265()).getData();

                            ctx.getSource().method_9226(() -> class_2561.method_43470("Chunk: " + chunk.method_12004() + " Palette: " + a.palette() + " | " + " Storage: " + a.storage() + " | Bits: " + a.storage().getElementBits()), false);
                            return 0;
                        })
                );
    }

    private static int targetBlock(CommandContext<class_2168> context) {
        var raycast = (class_3965) context.getSource().method_44023().method_5745(10, 0, true);

        var builder = new StringBuilder();
        var state = context.getSource().method_9225().method_8320(raycast.method_17777());

        builder.append(class_7923.field_41175.method_10221(state.method_26204()));

        if (!state.method_26204().method_9595().method_11659().isEmpty()) {
            builder.append("[");
            var iterator = state.method_26204().method_9595().method_11659().iterator();

            while (iterator.hasNext()) {
                var property = iterator.next();
                builder.append(property.method_11899());
                builder.append("=");
                builder.append(((class_2769) property).method_11901(state.method_11654(property)));

                if (iterator.hasNext()) {
                    builder.append(",");
                }
            }
            builder.append("]");
        }

        context.getSource().method_9226(() -> class_2561.method_43470(builder.toString()), false);

        return 0;
    }

    private static int targetItem(CommandContext<class_2168> context) throws CommandSyntaxException {
        var itemStack = context.getSource().method_9207().method_6047();
        context.getSource().method_9226(() -> class_2561.method_54154(class_7923.field_41178.method_10221(itemStack.method_7909())), false);
        return 0;
    }

    private static int dumpRegistries(CommandContext<class_2168> context) {
        var path = PolymerImplUtils.dumpRegistry();
        if (path != null) {
            context.getSource().method_9226(() -> class_2561.method_43470("Exported registry state as " + path), false);
        } else {
            context.getSource().method_9213(class_2561.method_43470("Couldn't export registry!"));
        }
        return 0;
    }

    private static int effects(CommandContext<class_2168> context) throws CommandSyntaxException {
        new PotionUi(context.getSource().method_44023());
        return 1;
    }

    private static int statsGeneral(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_44023();

        var list = new ArrayList<class_9262<class_2561>>();

        int line = 0;
        class_5250 text = null;

        for (var statType : class_7923.field_41193) {
            if (text == null) {
                text = class_2561.method_43470("");
            }
            text.method_10852(class_2561.method_43473().method_27693(class_7923.field_41193.method_10221(statType).toString()).method_27693("\n").method_27694(x -> x.method_30938(true).method_10977(class_124.field_1078).method_10958(new class_2558(class_2558.class_2559.field_11750, "/polymer stats " + class_7923.field_41193.method_10221(statType)))));
            line++;

            if (line == 13) {
                list.add(class_9262.method_57137(text));
                text = null;
                line = 0;
            }
        }

        if (text != null) {
            list.add(class_9262.method_57137(text));
        }

        var stack = new class_1799(class_1802.field_8360);
        stack.method_57379(class_9334.field_49606, new class_9302(
                class_9262.method_57137("/polymer start"),
                player.method_7334().getName(),
                0,
                list,
                false
        ));


        player.method_17355(new class_3908() {
            @Override
            public class_2561 method_5476() {
                return class_2561.method_43473();
            }

            @Nullable
            @Override
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                var lectern = new class_3916(syncId) {
                    @Override
                    public boolean method_7613(class_1799 stack, class_1735 slot) {
                        return false;
                    }

                    @Override
                    public boolean method_7615(class_1735 slot) {
                        return false;
                    }

                    @Override
                    public boolean method_7604(class_1657 player, int id) {
                        if (id == 3) {
                            return false;
                        } else {
                            return super.method_7604(player, id);
                        }
                    }

                    @Override
                    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
                        // noop
                    }
                };
                lectern.method_7611(0).method_53512(stack);
                return lectern;
            }
        });

        return 1;
    }

    private static int stats(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_44023();

        var list = new ArrayList<class_9262<class_2561>>();

        int line = 0;
        class_5250 text = null;

        var type = (class_3448<Object>) class_7733.method_45602(context, "type", class_7924.field_41226).comp_349();

        for (var statObj : type.method_14959()) {
            if (PolymerUtils.isServerOnly(statObj) && type.method_14958(statObj)) {


                var stat = type.method_14956(statObj);

                if (text == null) {
                    text = class_2561.method_43470("");
                }

                var statVal = player.method_14248().method_15025(stat);

                class_2561 title;

                if (statObj instanceof class_2960 stat1) {
                    title = PolymerStat.getName(stat1);
                } else if (statObj instanceof class_1792 item) {
                    title = item.method_7848();
                } else if (statObj instanceof class_2248 item) {
                    title = item.method_9518();
                } else if (statObj instanceof class_1299 item) {
                    title = item.method_5897();
                } else {
                    title = class_2561.method_43471(class_156.method_646(type.method_14959().method_30517().method_29177().method_12832(), type.method_14959().method_10221(statObj)));
                }

                text.method_10852(title).method_10852(class_2561.method_43470(": ").method_27692(class_124.field_1080)).method_10852(class_2561.method_43470(stat.method_14953(statVal) + "\n").method_27692(class_124.field_1063));
                line++;

                if (line == 13) {
                    list.add(class_9262.method_57137(text));
                    text = null;
                    line = 0;
                }
            }
        }

        if (text != null) {
            list.add(class_9262.method_57137(text));
        }

        var stack = new class_1799(class_1802.field_8360);
        stack.method_57379(class_9334.field_49606, new class_9302(
                class_9262.method_57137("/polymer start"),
                player.method_7334().getName(),
                0,
                list,
                false
        ));


        player.method_17355(new class_3908() {
            @Override
            public class_2561 method_5476() {
                return class_2561.method_43473();
            }

            @Nullable
            @Override
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                var lectern = new class_3916(syncId) {
                    @Override
                    public boolean method_7613(class_1799 stack, class_1735 slot) {
                        return false;
                    }

                    @Override
                    public boolean method_7615(class_1735 slot) {
                        return false;
                    }

                    @Override
                    public boolean method_7604(class_1657 player, int id) {
                        if (id == 3) {
                            return false;
                        } else {
                            return super.method_7604(player, id);
                        }
                    }

                    @Override
                    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
                        // noop
                    }
                };
                lectern.method_7611(0).method_53512(stack);
                return lectern;
            }
        });

        return 1;
    }

    private static int creativeTab(CommandContext<class_2168> context) {
        if (context.getSource().method_44023().method_7337()) {
            try {
                var id = context.getArgument("itemGroup", class_2960.class);

                var itemGroup = class_7923.field_44687.method_10223(id);
                if (itemGroup != null) {
                    new CreativeTabUi(context.getSource().method_44023(), itemGroup);
                    return 2;
                }
            } catch (Exception e) {
                //
            }

            new CreativeTabListUi(context.getSource().method_44023());
            return 1;
        } else {
            return 0;
        }
    }

    private static int displayClientItem(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_44023();
        var stack = PolymerItemUtils.getPolymerItemStack(player.method_6047(), context.getSource().method_30497(), player).method_7972();
        stack.method_57381(class_9334.field_49628);

        context.getSource().method_9226(() -> (new class_5628("")).method_32305(stack.method_57358(context.getSource().method_30497())), false);

        return 1;
    }

    private static int getClientItem(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_44023();

        var stack = PolymerItemUtils.getPolymerItemStack(player.method_6047(), context.getSource().method_30497(), player);
        stack.method_57381(class_9334.field_49628);
        player.method_7270(stack);
        context.getSource().method_9226(() -> class_2561.method_43470("Given client representation to player"), true);

        return 1;
    }
}
