package eu.pb4.polymer.core.impl.client.compat;

import eu.pb4.polymer.core.api.client.ClientPolymerBlock;
import eu.pb4.polymer.core.api.client.PolymerClientUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import ITooltipComponent;
import eu.pb4.polymer.common.impl.entity.InternalEntityHelpers;
import mcp.mobius.waila.api.*;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.component.PairComponent;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class WthitCompatibility implements IWailaPlugin {
    private static final class_2960 BLOCK_STATES = class_2960.method_12829("attribute.block_state");

    @Override
    public void register(IRegistrar registrar) {
        registrar.addRedirect(BlockOverride.INSTANCE, class_2248.class, 400);
        registrar.addComponent(BlockOverride.INSTANCE, TooltipPosition.HEAD, class_2248.class, 100000);
        registrar.addComponent(BlockOverride.INSTANCE, TooltipPosition.BODY, class_2248.class, 100000);
        registrar.addComponent(BlockOverride.INSTANCE, TooltipPosition.TAIL, class_2248.class, 100000);
        registrar.addIcon(BlockOverride.INSTANCE, class_2248.class, 500);

        registrar.addComponent(ItemEntityOverride.INSTANCE, TooltipPosition.HEAD, class_1542.class, 100000);
        registrar.addComponent(ItemEntityOverride.INSTANCE, TooltipPosition.TAIL, class_1542.class, 100000);

        registrar.addComponent(EntityOverride.INSTANCE, TooltipPosition.HEAD, class_1297.class, 100000);
        registrar.addComponent(EntityOverride.INSTANCE, TooltipPosition.TAIL, class_1297.class, 100000);

        registrar.addEventListener(OtherOverrides.INSTANCE);
    }

    private static class OtherOverrides implements IEventListener {
        public static final OtherOverrides INSTANCE = new OtherOverrides();

        @Override
        public @Nullable String getHoveredItemModName(class_1799 stack, IPluginConfig config) {
            return CompatUtils.getModName(stack);
        }
    }

    private static class BlockOverride implements IBlockComponentProvider {
        public static final BlockOverride INSTANCE = new BlockOverride();

        @Override
        public @Nullable ITargetRedirector.Result redirect(ITargetRedirector redirect, IBlockAccessor accessor, IPluginConfig config) {
            if (InternalClientRegistry.getBlockAt(accessor.getPosition()) != ClientPolymerBlock.NONE_STATE) return redirect.toSelf();
            return null;
        }

        @Override
        public @Nullable ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
            var block = InternalClientRegistry.getBlockAt(accessor.getPosition());
            if (block != ClientPolymerBlock.NONE_STATE) {
                class_2680 state = accessor.getWorld().getBlockState(accessor.getPosition());

                var itemStack = block.block().displayStack();
                if (itemStack.isEmpty()) {
                    itemStack = state.method_26204().method_9574(accessor.getWorld(), accessor.getPosition(), state);
                    if (!itemStack.isEmpty() && state.method_31709()) {
                        var blockEntity = accessor.getWorld().getBlockEntity(accessor.getPosition());

                        if (blockEntity != null) {
                            itemStack.applyComponentsFrom(blockEntity.getComponents());
                        }
                    }
                }

                return new ItemComponent(itemStack);
            }
            return null;
        }

        @Override
        public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            var block = InternalClientRegistry.getBlockAt(accessor.getPosition());
            if (block != ClientPolymerBlock.NONE_STATE) {
                var formatting = IWailaConfig.get().getFormatter();
                tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatting.blockName(block.block().name().getString()));
                if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
                    tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatting.registryName(block.block().identifier().toString()));
                }
            }
        }

        @Override
        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            if (config.getBoolean(BLOCK_STATES)) {
                var block = InternalClientRegistry.getBlockAt(accessor.getPosition());
                if (block != ClientPolymerBlock.NONE_STATE) {
                    for (var state : block.states().entrySet()) {
                        var value = state.getValue();
                        var valueText = class_2561.method_43470(value).setStyle(class_2583.field_24360.method_10977(value.equals("true") ? class_124.field_1060 : value.equals("false") ? class_124.field_1061 : class_124.field_1070));
                        tooltip.addLine(new PairComponent(class_2561.method_43470(state.getKey()), valueText));
                    }
                }
            }
        }

        @Override
        public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
                var block = InternalClientRegistry.getBlockAt(accessor.getPosition());
                if (block != ClientPolymerBlock.NONE_STATE) {
                    String modName = IModInfo.get(block.block().identifier()).getName();

                    if (modName == null || modName.isEmpty() || modName.equals("Minecraft")) {
                        modName = InternalClientRegistry.getModName(block.block().identifier());
                    }

                    tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(modName));
                }
            }
        }
    }

    private static final class ItemEntityOverride implements IEntityComponentProvider {
        public static final ItemEntityOverride INSTANCE = new ItemEntityOverride();

        @Override
        public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
            if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {

                var stack = accessor.<class_1542>getEntity().getStack();
                var id = PolymerItemUtils.getServerIdentifier(stack);

                if (id != null) {
                    var formatting = IWailaConfig.get().getFormatter();
                    tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatting.registryName(id));
                }
            }
        }


        @Override
        public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
            if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
                var stack = accessor.<class_1542>getEntity().getStack();
                var id = PolymerItemUtils.getServerIdentifier(stack);
                if (id != null) {
                    String modName = null;
                    var regBlock = class_7923.field_41178.method_10223(id);
                    if (regBlock != null) {
                        modName = IModInfo.get(regBlock).getName();
                    }

                    if (modName == null || modName.isEmpty() || (modName.equals("Minecraft") && !id.getNamespace().equals("minecraft"))) {
                        modName = InternalClientRegistry.getModName(id);
                    }

                    tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(modName));
                }
            }
        }
    }


    private static final class EntityOverride implements IEntityComponentProvider {
        public static final EntityOverride INSTANCE = new EntityOverride();

        @Override
        public @Nullable ITargetRedirector.Result redirect(ITargetRedirector redirect, IEntityAccessor accessor, IPluginConfig config) {
            if (PolymerClientUtils.getEntityType(accessor.getEntity()) != null) return redirect.toSelf();
            return null;
        }

        @Override
        public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
            if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {

                var entity = accessor.getEntity();
                var type = PolymerClientUtils.getEntityType(entity);
                if (type != null) {
                    var formatting = IWailaConfig.get().getFormatter();
                    tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatting.registryName(type.identifier()));
                }
            }
        }

        @Override
        public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
            if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
                var type = PolymerClientUtils.getEntityType(accessor.<class_1542>getEntity());
                if (type != null) {
                    String modName = null;
                    var regBlock = class_7923.field_41177.method_10223(type.identifier());
                    if (regBlock != null) {
                        modName = IModInfo.get(InternalEntityHelpers.getEntity(regBlock)).getName();
                    }

                    if (modName == null || modName.isEmpty() || (modName.equals("Minecraft") && !type.identifier().getNamespace().equals("minecraft"))) {
                        modName = InternalClientRegistry.getModName(type.identifier());
                    }

                    tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(modName));
                }
            }
        }
    }
}
