package eu.pb4.polymer.core.impl.client.networking;

import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import eu.pb4.polymer.core.impl.networking.C2SPackets;
import eu.pb4.polymer.core.impl.networking.payloads.c2s.PolymerChangeTooltipC2SPayload;
import eu.pb4.polymer.core.impl.networking.payloads.c2s.PolymerPickBlockC2SPayload;
import eu.pb4.polymer.core.impl.networking.payloads.c2s.PolymerPickEntityC2SPayload;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2817;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_634;
import org.jetbrains.annotations.ApiStatus;


@ApiStatus.Internal
@Environment(EnvType.CLIENT)
public class PolymerClientProtocol {
    public static void sendPickBlock(class_634 handler, class_2338 pos) {
        if (InternalClientRegistry.getClientProtocolVer(C2SPackets.WORLD_PICK_BLOCK) != -1) {
            handler.method_52787(new class_2817(new PolymerPickBlockC2SPayload(pos, class_437.method_25441())));
        }
    }

    public static void sendTooltipContext(class_634 handler) {
        if (InternalClientRegistry.getClientProtocolVer(C2SPackets.CHANGE_TOOLTIP) != -1) {
            InternalClientRegistry.delayAction(C2SPackets.CHANGE_TOOLTIP.toString(), 200, () -> {
                handler.method_52787(new class_2817(new PolymerChangeTooltipC2SPayload(class_310.method_1551().field_1690.field_1827)));
            });
        }
    }

    public static void sendPickEntity(class_634 handler, int id) {
        if (InternalClientRegistry.getClientProtocolVer(C2SPackets.WORLD_PICK_ENTITY) != -1) {
            handler.method_52787(new class_2817(new PolymerPickEntityC2SPayload(id, class_437.method_25441())));
        }
    }
}
