package eu.pb4.polymer.core.impl.networking;

import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.common.impl.entity.InternalEntityHelpers;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.core.api.other.PolymerStatusEffect;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.compat.ImmersivePortalsUtils;
import eu.pb4.polymer.core.impl.interfaces.EntityAttachedPacket;
import eu.pb4.polymer.core.impl.interfaces.StatusEffectPacketExtension;
import net.minecraft.class_1297;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2744;
import net.minecraft.class_2781;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7832;
import net.minecraft.class_8042;
import net.minecraft.class_8609;
import net.minecraft.class_8610;
import net.minecraft.network.packet.s2c.play.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class PacketPatcher {

    public static class_2596<?> replace(class_8609 handler, class_2596<?> packet) {
        if (handler.getClass() == class_3244.class) {
            if (packet instanceof class_2744 original && EntityAttachedPacket.get(original, original.method_11820()) instanceof PolymerEntity polymerEntity) {
                return EntityAttachedPacket.setIfEmpty(
                        new class_2744(((class_1297) polymerEntity).method_5628(), polymerEntity.getPolymerVisibleEquipment(original.method_30145(), ((class_3244) handler).method_32311())),
                        (class_1297) polymerEntity
                );
            }

            if (packet instanceof class_8042 bundleS2CPacket) {
                var list = new ArrayList<class_2596<? super class_2602>>();
                var iterator = bundleS2CPacket.method_48324().iterator();
                while (iterator.hasNext()) {
                    var x = replace(handler, iterator.next());
                    if (!prevent(handler, x)) {
                        list.add((class_2596<class_2602>) x);
                    }
                }

                return new class_8042(list);
            }
        } else if (handler.getClass() == class_8610.class) {
            if (packet instanceof class_7832 featuresS2CPacket) {
                var x = PolymerUtils.getClientEnabledFeatureFlags();

                if (x.isEmpty()) {
                    return packet;
                }

                class_7699 set = class_7701.field_40180.method_45390(x.toArray(new class_7696[0]));

                if (featuresS2CPacket.comp_1113().getClass() == HashSet.class) {
                    featuresS2CPacket.comp_1113().addAll(class_7701.field_40180.method_45392(set));
                } else {
                    var y = new HashSet<class_2960>();
                    y.addAll(featuresS2CPacket.comp_1113());
                    y.addAll(class_7701.field_40180.method_45392(set));
                    return new class_7832(y);
                }
            }

        }

        return packet;
    }

    public static void sendExtra(class_8609 handler, class_2596<?> packet) {
        if (handler.getClass() == class_3244.class) {
            if (CompatStatus.IMMERSIVE_PORTALS) {
                ImmersivePortalsUtils.sendBlockPackets((class_3244) handler, packet);
            } else {
                BlockPacketUtil.sendFromPacket(packet, (class_3244) handler);
            }
        }
    }

    public static boolean prevent(class_8609 handler, class_2596<?> packet) {
        if (handler.getClass() == class_3244.class) {
            var player = ((class_3244) handler).field_14140;
            if ((
                    packet instanceof StatusEffectPacketExtension packet2
                            && ((packet2.polymer$getStatusEffect() instanceof PolymerStatusEffect pol && pol.getPolymerReplacement(player) == null))
            ) || !EntityAttachedPacket.shouldSend(packet, player)
            ) {
                return true;
            } else if ((packet instanceof class_2744 original && original.method_30145().isEmpty()) || !EntityAttachedPacket.shouldSend(packet, player)) {
                return true;
            } else if ((packet instanceof class_2781 original
                    && EntityAttachedPacket.get(packet, original.method_11937()) instanceof PolymerEntity entity
                    && !InternalEntityHelpers.isLivingEntity(entity.getPolymerEntityType(player)))) {
                return true;
            } else if (packet instanceof class_2622 be && PolymerBlockUtils.isPolymerBlockEntityType(be.method_11291())) {
                return true;
            }
        }

        return false;
    }
}
