package eu.pb4.polymer.core.impl.networking;

import Z;
import eu.pb4.polymer.core.api.utils.PolymerSyncUtils;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.ServerMetadataKeys;
import eu.pb4.polymer.core.impl.interfaces.PolymerPlayNetworkHandlerExtension;
import eu.pb4.polymer.core.impl.networking.payloads.c2s.PolymerChangeTooltipC2SPayload;
import eu.pb4.polymer.core.impl.networking.payloads.c2s.PolymerPickBlockC2SPayload;
import eu.pb4.polymer.core.impl.networking.payloads.c2s.PolymerPickEntityC2SPayload;
import eu.pb4.polymer.networking.api.server.PolymerServerNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PolymerServerProtocolHandler {
    @SuppressWarnings("ResultOfMethodCallIgnored")
    public static void register() {
        PolymerServerNetworking.registerPlayHandler(PolymerPickBlockC2SPayload.class, PolymerServerProtocolHandler::handlePickBlock);
        PolymerServerNetworking.registerPlayHandler(PolymerPickEntityC2SPayload.class, PolymerServerProtocolHandler::handlePickEntity);
        PolymerServerNetworking.registerPlayHandler(PolymerChangeTooltipC2SPayload.class, PolymerServerProtocolHandler::handleTooltipChange);

        PolymerServerNetworking.ON_PLAY_SYNC.register((handler, x) -> {
            PolymerServerProtocol.sendSyncPackets(handler, true);
        });

        ServerMetadataKeys.setup();
        S2CPackets.SYNC_BLOCK.method_12836();
        C2SPackets.WORLD_PICK_BLOCK.method_12836();
    }

    private static void handleTooltipChange(MinecraftServer server, class_3244 handler, PolymerChangeTooltipC2SPayload payload) {
        handler.method_32311().method_5682().execute(() -> {
            PolymerPlayNetworkHandlerExtension.of(handler).polymer$setAdvancedTooltip(payload.advanced());

            if (PolymerServerNetworking.getLastPacketReceivedTime(handler, C2SPackets.CHANGE_TOOLTIP) + 1000 < System.currentTimeMillis()) {
                PolymerSyncUtils.synchronizeCreativeTabs(handler);
                PolymerUtils.reloadInventory(handler.field_14140);
            }
        });
    }

    private static void handlePickBlock(MinecraftServer server, class_3244 handler, PolymerPickBlockC2SPayload payload) {
        var pos = payload.pos();
        var ctr = payload.control();


        server.execute(() -> {
            if (pos.method_19455(handler.field_14140.method_24515()) <= 32) {
                PolymerImplUtils.pickBlock(handler.field_14140, pos, ctr);
            }
        });
    }

    private static void handlePickEntity(MinecraftServer server, class_3244 handler, PolymerPickEntityC2SPayload payload) {
        server.execute(() -> {
            var entity = handler.field_14140.method_51469().method_8469(payload.entityId());

            if (entity != null && entity.method_19538().method_1035(handler.field_14140.method_19538()).method_1027() < 1024) {
                PolymerImplUtils.pickEntity(handler.field_14140, entity);
            }
        });
    }
}
