package eu.pb4.polymer.core.impl.networking.entry;

import I;
import eu.pb4.polymer.networking.api.ContextByteBuf;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;


@ApiStatus.Internal
public record PolymerBlockEntry(class_2960 identifier, int numId, class_2561 text, class_2680 visual, class_1799 visualStack) {
    private static final class_9139<ByteBuf, class_2680> STATE = class_9135.method_56371(class_2248.field_10651);
    public static final class_9139<ContextByteBuf, PolymerBlockEntry> CODEC = class_9139.method_56438(PolymerBlockEntry::write, PolymerBlockEntry::read);
    public void write(ContextByteBuf buf) {
        buf.method_10812(identifier);
        buf.method_10804(numId);
        class_8824.field_49668.encode(buf, text);
        STATE.encode(buf, visual);
        if (buf.version() >= 7) {
            class_1799.field_49268.encode(buf, this.visualStack);
        }
    }

    public static PolymerBlockEntry of(class_2248 block) {
        return new PolymerBlockEntry(class_7923.field_41175.method_10221(block), class_7923.field_41175.method_10206(block),
                block.method_9518(), block.method_9564(), block.method_8389() != null ? block.method_8389().method_7854() : class_1799.field_8037);
    }

    public static PolymerBlockEntry read(ContextByteBuf buf) {
        var id = buf.method_10810();
        var numId = buf.method_10816();
        var name = class_8824.field_49668.decode(buf);
        var visual = STATE.decode(buf);
        var visualStack = buf.version() >= 7 ? class_1799.field_49268.decode(buf)
                : (visual.method_26204().method_8389() != null ? visual.method_26204().method_8389().method_7854() : class_1799.field_8037);
        return new PolymerBlockEntry(id, numId, name, visual, visualStack);
    }
}
