package eu.pb4.polymer.core.mixin.client.rendering;

import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.core.api.utils.PolymerKeepModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1091;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_773;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(EnvType.CLIENT)
@Mixin(class_773.class)
public class BlockModelsMixin {
    @Inject(method = "getModelId(Lnet/minecraft/block/BlockState;)Lnet/minecraft/client/util/ModelIdentifier;", at = @At("HEAD"), cancellable = true, require = 0)
    private static void polymer$skipModels(class_2680 state, CallbackInfoReturnable<class_1091> cir) {
        if (PolymerKeepModel.useServerModel(state.method_26204())) {
            cir.setReturnValue(new class_1091(class_2960.method_60655("minecraft", "air"), ""));
        }
    }

    @ModifyVariable(method = "getModel", at = @At("HEAD"), require = 0)
    private class_2680 polymer$replaceBlockState(class_2680 state) {
        return state.method_26204() instanceof PolymerBlock block && !PolymerKeepModel.is(block) ? class_2246.field_10124.method_9564() : state;
    }
}
