package eu.pb4.polymer.core.mixin.entity;

import eu.pb4.polymer.core.api.entity.PolymerEntity;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2777;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2777.class)
public class EntityPositionS2CPacketMixin {

    @Shadow @Mutable
    private double x;

    @Shadow @Mutable
    private double y;

    @Shadow @Mutable
    private double z;

    @Shadow @Mutable
    private byte yaw;

    @Shadow @Mutable
    private byte pitch;

    @Inject(method = "<init>(Lnet/minecraft/entity/Entity;)V", at = @At("TAIL"))
    private void polymer$replaceForVirtual(class_1297 entity, CallbackInfo ci) {
        if (entity instanceof PolymerEntity virtualEntity) {
            class_243 vec3d = virtualEntity.getClientSidePosition(entity.method_19538());
            this.x = vec3d.field_1352;
            this.y = vec3d.field_1351;
            this.z = vec3d.field_1350;
            this.yaw = (byte)((int)(virtualEntity.getClientSideYaw(entity.method_36454()) * 256.0F / 360.0F));
            this.pitch = (byte)((int)(virtualEntity.getClientSidePitch(entity.method_36455()) * 256.0F / 360.0F));
        }
    }


}
