package eu.pb4.polymer.core.mixin.entity;

import eu.pb4.polymer.common.impl.client.ClientUtils;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.core.api.utils.PolymerClientDecoded;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import eu.pb4.polymer.core.impl.interfaces.EntityAttachedPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2604;
import net.minecraft.class_3231;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;


@Mixin(class_2604.class)
public class EntitySpawnS2CPacketMixin {
    @Shadow @Final private int entityData;

    @Shadow @Mutable
    private double x;

    @Shadow @Mutable
    private double y;

    @Shadow @Mutable
    private double z;

    @Shadow @Mutable
    private byte yaw;

    @Shadow @Mutable
    private byte pitch;

    @Shadow @Final private class_1299<?> entityType;

    @Shadow @Final private int entityId;

    @ModifyArg(method = "write", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/codec/PacketCodec;encode(Ljava/lang/Object;Ljava/lang/Object;)V"), index = 1)
    private Object polymer$replaceWithPolymer(@Nullable Object value) {
        if (EntityAttachedPacket.get(this, this.entityId) instanceof PolymerEntity polymerEntity && value == ((class_1297) polymerEntity).method_5864()) {
            return polymerEntity.getPolymerEntityType(PolymerUtils.getPlayerContext());
        } else {
            return value;
        }
    }

    @ModifyArg(method = "write", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/RegistryByteBuf;writeVarInt(I)Lnet/minecraft/network/PacketByteBuf;", ordinal = 1))
    private int polymer$replaceValue(int data) {
        if (this.entityType == class_1299.field_6089) {
            return class_2248.method_9507(PolymerBlockUtils.getPolymerBlockState(class_2248.method_9531(data), PolymerUtils.getPlayerContext()));
        }

        return data;
    }

    @Inject(method = "<init>(Lnet/minecraft/entity/Entity;Lnet/minecraft/server/network/EntityTrackerEntry;I)V", at = @At("TAIL"))
    private void polymer$changePosition(class_1297 entity, class_3231 entityTrackerEntry, int entityData, CallbackInfo ci) {
        if (entity instanceof PolymerEntity virtualEntity) {
            class_243 vec3d = virtualEntity.getClientSidePosition(entityTrackerEntry.method_60942());
            this.x = vec3d.field_1352;
            this.y = vec3d.field_1351;
            this.z = vec3d.field_1350;
            this.yaw = (byte)((int)(virtualEntity.getClientSideYaw(entityTrackerEntry.method_60945()) * 256.0F / 360.0F));
            this.pitch = (byte)((int)(virtualEntity.getClientSidePitch(entityTrackerEntry.method_60944()) * 256.0F / 360.0F));
        }
    }

    @Inject(method = "<init>(Lnet/minecraft/entity/Entity;ILnet/minecraft/util/math/BlockPos;)V", at = @At("TAIL"))
    private void polymer$changePosition2(class_1297 entity, int entityTypeId, class_2338 pos, CallbackInfo ci) {
        if (entity instanceof PolymerEntity virtualEntity) {
            class_243 vec3d = virtualEntity.getClientSidePosition(entity.method_19538());
            this.x = vec3d.field_1352;
            this.y = vec3d.field_1351;
            this.z = vec3d.field_1350;
            this.yaw = (byte)((int)(virtualEntity.getClientSideYaw(entity.method_36454()) * 256.0F / 360.0F));
            this.pitch = (byte)((int)(virtualEntity.getClientSidePitch(entity.method_36455()) * 256.0F / 360.0F));
        }
    }
}
