package eu.pb4.polymer.core.mixin.entity;

import com.llamalad7.mixinextras.sugar.Local;
import eu.pb4.polymer.core.api.other.PlayerBoundConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2596;
import net.minecraft.class_3898;
import net.minecraft.class_5629;

@Mixin(class_3898.class_3208.class)
public abstract class EntityTrackerMixin {

    @Shadow @Final private Set<class_5629> listeners;

    @ModifyArg(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/EntityTrackerEntry;<init>(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/Entity;IZLjava/util/function/Consumer;)V"))
    private Consumer<class_2596<?>> replaceReceiver(Consumer<class_2596<?>> receiver, @Local(argsOnly = true) class_1297 entity) {
        return PlayerBoundConsumer.createPacketFor(this.listeners, entity, receiver);
    }
}
