package eu.pb4.polymer.core.mixin.item;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.Codec;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.other.PolymerTooltipType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_3222;
import net.minecraft.class_7225.class_7874;


@Mixin(class_1799.class)
public class ItemStackMixin {
    @ModifyExpressionValue(method = "getTooltip", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/tooltip/TooltipType;isAdvanced()Z"))
    private boolean removeAdvanced(boolean original, @Local(ordinal = 0, argsOnly = true) class_1836 type) {
        return original && !(type instanceof PolymerTooltipType);
    }

    @ModifyArg(method = "<clinit>", at = @At(value = "INVOKE", target = "Lcom/mojang/serialization/Codec;lazyInitialized(Ljava/util/function/Supplier;)Lcom/mojang/serialization/Codec;"))
    private static Supplier<Codec<class_1799>> patchCodec(Supplier<Codec<class_1799>> codec) {
        return () -> codec.get().xmap(content -> { // Decode
            if (PolymerCommonUtils.isServerNetworkingThread()) {
                var context = PacketContext.get().getRegistryWrapperLookup();
                var player = PolymerCommonUtils.getPlayerContext();
                var lookup = context != null ? context : (player != null ? player.method_56673() : PolymerImplUtils.FALLBACK_LOOKUP);
                return PolymerItemUtils.getRealItemStack(content, lookup);
            }
            return content;
        }, content -> { // Encode
            if (PolymerCommonUtils.isServerNetworkingThreadWithContext()) {
                var ctx = PacketContext.get();
                if (ctx.getPacketListener() == null) {
                    return content;
                }
                var context = ctx.getRegistryWrapperLookup();
                var player = PolymerCommonUtils.getPlayerContext();
                var lookup = context != null ? context : (player != null ? player.method_56673() : PolymerImplUtils.FALLBACK_LOOKUP);
                return PolymerItemUtils.getPolymerItemStack(content, lookup, player);
            }
            return content;
        });
    }
}
