package eu.pb4.polymer.core.mixin.item;

import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils.ItemWithMetadata;
import eu.pb4.polymer.core.impl.ClientMetadataKeys;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.interfaces.PolymerPlayNetworkHandlerExtension;
import eu.pb4.polymer.core.impl.networking.PolymerServerProtocol;
import eu.pb4.polymer.networking.api.server.PolymerServerNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1747;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2535;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2626;
import net.minecraft.class_2653;
import net.minecraft.class_2680;
import net.minecraft.class_2788;
import net.minecraft.class_2790;
import net.minecraft.class_2803;
import net.minecraft.class_2813;
import net.minecraft.class_2885;
import net.minecraft.class_2886;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5151;
import net.minecraft.class_6864;
import net.minecraft.class_8609;
import net.minecraft.class_8792;
import net.minecraft.network.packet.s2c.play.*;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;

@Mixin(value = class_3244.class, priority = 1200)
public abstract class ServerPlayNetworkHandlerMixin extends class_8609 {
    @Shadow
    public class_3222 player;
    @Unique
    private final List<class_1799> polymerCore$armorItems = new ArrayList<>();
    @Unique
    private String polymerCore$language;

    public ServerPlayNetworkHandlerMixin(MinecraftServer server, class_2535 connection, class_8792 clientData) {
        super(server, connection, clientData);
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    private void polymerCore$storeLanguage(MinecraftServer server, class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        this.polymerCore$language = clientData.comp_1961().comp_1951();
    }


    @Inject(method = "onClientOptions", at = @At("TAIL"))
    private void polymerCore$resendLanguage(class_2803 packet, CallbackInfo ci) {
        if (CommonImplUtils.isMainPlayer(this.player)) {
            return;
        }

        if (!this.polymerCore$language.equals(packet.comp_1963().comp_1951())) {
            this.polymerCore$language = packet.comp_1963().comp_1951();
            PolymerServerProtocol.sendSyncPackets(player.field_13987, true);
            this.method_14364(new class_2790(class_6864.method_40105(this.player.method_51469().method_8503().method_46221())));
            this.method_14364(new class_2788(this.player.method_51469().method_8433().method_8126()));
            this.player.method_14253().method_14904(this.player);
        }
    }

    @Inject(method = "onPlayerInteractBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/NetworkThreadUtils;forceMainThread(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/listener/PacketListener;Lnet/minecraft/server/world/ServerWorld;)V", shift = At.Shift.AFTER))
    private void polymer$resendHandOnPlace(class_2885 packet, CallbackInfo ci) {
        class_1799 itemStack = this.player.method_5998(packet.method_12546());

        if (itemStack.method_7909() instanceof PolymerItem polymerItem) {
            var data = PolymerItemUtils.getItemSafely(polymerItem, itemStack, this.player);
            if (data.item() instanceof class_1747 || data.item() instanceof class_1755) {
                this.method_14364(new class_2653(this.player.field_7498.field_7763, this.player.field_7498.method_37422(), packet.method_12546() == class_1268.field_5808 ? 36 + this.player.method_31548().field_7545 : 45, itemStack));
            }
        }
    }

    @Inject(method = "onPlayerInteractItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/NetworkThreadUtils;forceMainThread(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/listener/PacketListener;Lnet/minecraft/server/world/ServerWorld;)V", shift = At.Shift.AFTER))
    private void polymer$resendHandOnUse(class_2886 packet, CallbackInfo ci) {
        class_1799 itemStack = this.player.method_5998(packet.method_12551());

        if (itemStack.method_7909() instanceof PolymerItem polymerItem) {
            var data = PolymerItemUtils.getItemSafely(polymerItem, itemStack, this.player);
            if (data.item() instanceof class_5151 equipment) {
                if (equipment.method_7685().method_5925() == class_1304.class_1305.field_6178) {
                    this.method_14364(new class_2653(this.player.field_7498.field_7763, this.player.field_7498.method_37422(),
                            packet.method_12551() == class_1268.field_5808 ? 36 + this.player.method_31548().field_7545 : 45, itemStack));

                    this.method_14364(new class_2653(this.player.field_7498.field_7763, this.player.field_7498.method_37422(),
                            8 - equipment.method_7685().method_5927(), this.player.method_6118(equipment.method_7685())));
                } else if (equipment.method_7685().method_5925() == class_1304.class_1305.field_48825 && packet.method_12551() == class_1268.field_5810) {
                    this.method_14364(new class_2653(this.player.field_7498.field_7763, this.player.field_7498.method_37422(),
                            45, itemStack));
                    this.method_14364(new class_2653(this.player.field_7498.field_7763, this.player.field_7498.method_37422(),
                            36 + this.player.method_31548().field_7545, this.player.method_6047()));
                }
            }
        }
    }


    @Inject(method = "onPlayerInteractBlock", at = @At("TAIL"))
    private void polymer$updateMoreBlocks(class_2885 packet, CallbackInfo ci) {
        if (PolymerImpl.RESEND_BLOCKS_AROUND_CLICK) {
            var base = packet.method_12543().method_17777();
            for (class_2350 direction : class_2350.values()) {
                var pos = base.method_10093(direction);
                var state = player.method_51469().method_8320(pos);
                player.field_13987.method_14364(new class_2626(pos, state));

                if (state.method_31709()) {
                    var be = player.method_37908().method_8321(pos);
                    if (be != null) {
                        player.field_13987.method_14364(class_2622.method_38585(be));
                    }
                }
            }
        }

        /*var stack = this.player.getStackInHand(packet.getHand());

        if (stack.getItem() instanceof PolymerItem virtualItem) {
            var data = PolymerItemUtils.getItemSafely(virtualItem, stack, this.player);
            if (data.item() instanceof BlockItem || data.item() instanceof BucketItem) {
                this.onPlayerInteractItem(new PlayerInteractItemC2SPacket(packet.getHand(), 0));
            }
        }*/
    }

    @Inject(method = "onClickSlot", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayerEntity;updateLastActionTime()V", shift = At.Shift.AFTER))
    private void polymer$storeArmor(class_2813 packet, CallbackInfo ci) {
        if (this.player.field_7512 == this.player.field_7498) {
            for (class_1799 stack : this.player.method_31548().field_7548) {
                polymerCore$armorItems.add(stack.method_7972());
            }
        }
    }

    @Inject(method = "onClickSlot", at = @At("TAIL"))
    private void polymer$updateArmor(class_2813 packet, CallbackInfo ci) {
        if (this.player.field_7512 == this.player.field_7498 && packet.method_12192() != -999) {
            int x = 0;
            for (class_1799 stack : this.player.method_31548().field_7548) {
                if (stack.method_7909() instanceof PolymerItem && !class_1799.method_7973(this.polymerCore$armorItems.get(x), stack)) {
                    this.method_14364(new class_2653(this.player.field_7498.field_7763,
                            this.player.field_7498.method_37422(),
                            8 - x,
                            stack));

                    if (packet.method_12192() != 8 - x) {
                        this.method_14364(new class_2653(this.player.field_7498.field_7763,
                                this.player.field_7498.method_37422(),
                                packet.method_12192(),
                                this.player.field_7498.method_7611(packet.method_12192()).method_7677()));
                    }

                    this.method_14364(new class_2653(-1,
                            0,
                            0,
                            this.player.field_7512.method_34255()));
                    return;
                }
                x++;
            }
        }

        this.polymerCore$armorItems.clear();
    }
}
