package eu.pb4.polymer.core.mixin.item;

import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3971;
import net.minecraft.class_3975;
import net.minecraft.class_8786;

@Mixin(class_3971.class)
public class StonecutterScreenHandlerMixin {
    @Shadow
    @Final
    private class_1937 world;
    @Shadow private List<class_8786<class_3975>> availableRecipes;
    @Unique
    private class_3222 polymerCore$player;

    @Inject(method = "<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V", at = @At("TAIL"))
    private void polymerCore$storePlayer(int syncId, class_1661 playerInventory, class_3914 context, CallbackInfo ci) {
        this.polymerCore$player = playerInventory.field_7546 instanceof class_3222 player ? player : null;
    }

    @Inject(method = "updateInput", at = @At("TAIL"))
    private void polymerCore$fixOrdering(class_1263 input, class_1799 stack, CallbackInfo ci) {
        if (!stack.method_7960() && this.polymerCore$player != null) {
            var list = new ArrayList<>(this.availableRecipes);

            list.sort(Comparator.comparing(
                    (recipe) -> PolymerItemUtils.getPolymerItemStack(recipe.comp_1933().method_8110(this.world.method_30349()), this.world.method_30349(), this.polymerCore$player).method_7922()
            ));
            this.availableRecipes = list;
        }
    }
}
