package eu.pb4.polymer.core.mixin.item.component;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import eu.pb4.polymer.core.impl.TransformingComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_4174;
import net.minecraft.class_4174.class_9423;

@Mixin(class_4174.class)
public abstract class FoodComponentMixin implements TransformingComponent {
    @Shadow @Final private int nutrition;

    @Shadow @Final private boolean canAlwaysEat;

    @Shadow @Final private float eatSeconds;

    @Shadow @Final private List<class_4174.class_9423> effects;

    @Shadow @Final private float saturation;

    @Shadow public abstract Optional<class_1799> usingConvertsTo();

    @Override
    public Object polymer$getTransformed(PacketContext context) {
        if (!polymer$requireModification(context)) {
            return this;
        }

        return new class_4174(this.nutrition, this.saturation, this.canAlwaysEat, this.eatSeconds, this.usingConvertsTo(), List.of());
    }

    @Override
    public boolean polymer$requireModification(PacketContext context) {
        for (var effect : this.effects) {
            if (effect.comp_2496().method_5579().comp_349() instanceof PolymerObject) {
                return true;
            }
        }
        return false;
    }
}
