package eu.pb4.polymer.core.mixin.other;


import I;
import eu.pb4.polymer.core.api.other.PolymerSoundEvent;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import java.util.ArrayList;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_9129;

@Mixin(targets = "net/minecraft/network/codec/PacketCodecs$18", priority = 500)
public abstract class PacketCodecsRegistryEntryListMixin {
    @ModifyVariable(method = "encode(Lnet/minecraft/network/RegistryByteBuf;Lnet/minecraft/registry/entry/RegistryEntryList;)V", at = @At("HEAD"), argsOnly = true)
    private class_6885 polymer$changeData(class_6885 registryEntryList, class_9129 registryByteBuf) {
        if (registryEntryList.method_45925().isEmpty()) {
            var player = PolymerUtils.getPlayerContext();

            if (player != null) {
                var arr = new ArrayList<class_6880>();
                for (var i = 0; i < registryEntryList.method_40247(); i++) {
                    var val = registryEntryList.method_40240(i);
                    if (val.comp_349() instanceof PolymerSoundEvent syncedObject) {
                        var replacement = syncedObject.getPolymerReplacement(PolymerUtils.getPlayerContext());

                        if (replacement instanceof PolymerSoundEvent) {
                            arr.add(class_6880.method_40223(replacement));
                        }

                        arr.add(class_7923.field_41172.method_47983(replacement));
                    } else if ((val.comp_349() instanceof PolymerSyncedObject<?> s && s.canSyncRawToClient(player)) || !(val.comp_349() instanceof PolymerObject)) {
                        arr.add(val);
                    }
                }
            }
        }

        return registryEntryList;
    }

}