package eu.pb4.polymer.core.mixin.other;


import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(targets = "net/minecraft/network/codec/PacketCodecs$16", priority = 500)
public abstract class PacketCodecsRegistryMixin {

    @Shadow @Final private class_5321 field_48575;

    @ModifyVariable(method = "encode(Lnet/minecraft/network/RegistryByteBuf;Ljava/lang/Object;)V", at = @At("HEAD"), argsOnly = true)
    private Object polymer$changeData(Object val, class_9129 buf) {
        var player = PolymerUtils.getPlayerContext();
        
        if (player != null) {
            if (val instanceof PolymerSyncedObject<?> polymerSyncedObject) {
                var obj = polymerSyncedObject.getPolymerReplacement(player);

                if (obj != null) {
                    return obj;
                }
            } else if (val instanceof class_6880<?> registryEntry) {
                var value = registryEntry.comp_349();
                if (value instanceof PolymerSyncedObject<?> polymerSyncedObject) {
                    var obj = polymerSyncedObject.getPolymerReplacement(player);

                    if (obj != null) {
                        //noinspection unchecked
                        return buf.method_56349().method_30530(this.field_48575).method_47983(obj);
                    }
                }
            }
        }

        return val;
    }
}