/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.block;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import eu.pb4.polymer.common.api.events.BooleanEvent;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.core.api.block.BlockMapper;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.api.other.PolymerComponent;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.TransformingComponent;
import eu.pb4.polymer.core.impl.compat.polymc.PolyMcUtils;
import eu.pb4.polymer.core.impl.interfaces.BlockStateExtra;
import eu.pb4.polymer.core.mixin.block.BlockEntityUpdateS2CPacketAccessor;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Arrays;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import net.minecraft.class_9336;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public final class PolymerBlockUtils {
    public static final int NESTED_DEFAULT_DISTANCE = 32;
    public static final Predicate<class_2680> IS_POLYMER_BLOCK_STATE_PREDICATE = state -> state.method_26204() instanceof PolymerBlock;
    public static final BooleanEvent<MineEventListener> SERVER_SIDE_MINING_CHECK = new BooleanEvent();
    public static final SimpleEvent<BreakingProgressListener> BREAKING_PROGRESS_UPDATE = new SimpleEvent();
    public static final BooleanEvent<BiPredicate<class_3218, class_4076>> SEND_LIGHT_UPDATE_PACKET = new BooleanEvent();
    private static final class_2487 STATIC_COMPOUND = new class_2487();
    private static final Set<class_2591<?>> BLOCK_ENTITY_TYPES = new ObjectOpenCustomHashSet(CommonImplUtils.IDENTITY_HASH);
    private static boolean requireStrictBlockUpdates = false;

    private PolymerBlockUtils() {
    }

    public static void registerBlockEntity(class_2591<?> ... types) {
        BLOCK_ENTITY_TYPES.addAll(Arrays.asList(types));
        for (class_2591<?> type : types) {
            RegistrySyncUtils.setServerEntry((class_2378)class_7923.field_41181, type);
        }
    }

    public static boolean isPolymerBlockEntityType(class_2591<?> type) {
        return BLOCK_ENTITY_TYPES.contains(type);
    }

    public static boolean forceLightUpdates(class_2680 blockState) {
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof PolymerBlock) {
            PolymerBlock virtualBlock = (PolymerBlock)class_22482;
            if (virtualBlock.forceLightUpdates(blockState)) {
                return true;
            }
            return ((BlockStateExtra)blockState).polymer$isPolymerLightSource();
        }
        return false;
    }

    public static class_2680 getPolymerBlockState(class_2680 state) {
        return PolymerBlockUtils.getPolymerBlockState(state, null);
    }

    public static class_2680 getPolymerBlockState(class_2680 state, @Nullable class_3222 player) {
        return BlockMapper.getFrom(player).toClientSideState(state, player);
    }

    public static class_2248 getPolymerBlock(class_2248 block, @Nullable class_3222 player) {
        return BlockMapper.getFrom(player).toClientSideState(block.method_9564(), player).method_26204();
    }

    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState, int maxDistance) {
        PolymerBlock newBlock;
        class_2248 class_22482;
        class_2680 out = block.getPolymerBlockState(blockState);
        for (int req = 0; (class_22482 = out.method_26204()) instanceof PolymerBlock && (newBlock = (PolymerBlock)class_22482) != block && req < maxDistance; ++req) {
            out = newBlock.getPolymerBlockState(out);
        }
        return out;
    }

    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState, int maxDistance, @Nullable class_3222 player) {
        PolymerBlock newBlock;
        class_2248 class_22482;
        if (player == null) {
            return PolymerBlockUtils.getBlockStateSafely(block, blockState, maxDistance);
        }
        class_2680 out = block.getPolymerBlockState(blockState, player);
        for (int req = 0; (class_22482 = out.method_26204()) instanceof PolymerBlock && (newBlock = (PolymerBlock)class_22482) != block && req < maxDistance; ++req) {
            out = newBlock.getPolymerBlockState(blockState, player);
        }
        return out;
    }

    public static class_2680 getBlockBreakBlockStateSafely(PolymerBlock block, class_2680 blockState, int maxDistance, @Nullable class_3222 player) {
        PolymerBlock newBlock;
        class_2248 class_22482;
        if (player == null) {
            return PolymerBlockUtils.getBlockStateSafely(block, blockState, maxDistance);
        }
        class_2680 out = block.getPolymerBreakEventBlockState(blockState, player);
        for (int req = 0; (class_22482 = out.method_26204()) instanceof PolymerBlock && (newBlock = (PolymerBlock)class_22482) != block && req < maxDistance; ++req) {
            out = newBlock.getPolymerBreakEventBlockState(blockState, player);
        }
        return out;
    }

    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState, @Nullable class_3222 player) {
        return PolymerBlockUtils.getBlockStateSafely(block, blockState, 32, player);
    }

    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState) {
        return PolymerBlockUtils.getBlockStateSafely(block, blockState, 32);
    }

    public static class_2622 createBlockEntityPacket(class_2338 pos, class_2591<?> type, @Nullable class_2487 nbtCompound) {
        return BlockEntityUpdateS2CPacketAccessor.createBlockEntityUpdateS2CPacket(pos.method_10062(), type, nbtCompound != null ? nbtCompound : STATIC_COMPOUND);
    }

    @ApiStatus.Experimental
    public static void requireStrictBlockUpdates() {
        requireStrictBlockUpdates = true;
    }

    public static boolean isStrictBlockUpdateRequired() {
        return requireStrictBlockUpdates;
    }

    public static boolean shouldMineServerSide(class_3222 player, class_2338 pos, class_2680 state) {
        PolymerItem item;
        PolymerBlock block;
        class_2248 class_22482 = state.method_26204();
        return class_22482 instanceof PolymerBlock && (block = (PolymerBlock)class_22482).handleMiningOnServer(player.method_6047(), state, pos, player) || (class_22482 = player.method_6047().method_7909()) instanceof PolymerItem && (item = (PolymerItem)class_22482).handleMiningOnServer(player.method_6047(), state, pos, player) || SERVER_SIDE_MINING_CHECK.invoke(x -> x.onBlockMine(state, pos, player));
    }

    public static class_2680 getServerSideBlockState(class_2680 state, class_3222 player) {
        return PolyMcUtils.toVanilla(PolymerBlockUtils.getPolymerBlockState(state, player), player);
    }

    public static class_2487 transformBlockEntityNbt(PacketContext context, class_2591<?> type, class_2487 original) {
        class_6903 ops;
        DataResult comp;
        class_1799 stack;
        class_7225.class_7874 lookup;
        if (original.method_33133()) {
            return original;
        }
        class_2487 override = null;
        class_7225.class_7874 class_78742 = lookup = context.getRegistryWrapperLookup() != null ? context.getRegistryWrapperLookup() : PolymerImplUtils.FALLBACK_LOOKUP;
        if (original.method_10573("Items", 9)) {
            class_2499 list = original.method_10554("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 nbt = list.method_10602(i);
                class_1799 stack2 = class_1799.method_57359((class_7225.class_7874)lookup, (class_2487)nbt);
                if (!PolymerItemUtils.isPolymerServerItem(stack2, context)) continue;
                if (override == null) {
                    override = original.method_10553();
                }
                nbt = nbt.method_10553();
                nbt.method_10551("id");
                nbt.method_10551("components");
                nbt.method_10551("count");
                stack2 = PolymerItemUtils.getPolymerItemStack(stack2, context);
                override.method_10554("Items", 10).method_10606(i, (class_2520)(stack2.method_7960() ? new class_2487() : stack2.method_57376(lookup, (class_2520)nbt)));
            }
        }
        if (original.method_10573("item", 10) && PolymerItemUtils.isPolymerServerItem(stack = class_1799.method_57359((class_7225.class_7874)lookup, (class_2487)original.method_10562("item")), context)) {
            if (override == null) {
                override = original.method_10553();
            }
            stack = PolymerItemUtils.getPolymerItemStack(stack, context);
            override.method_10566("item", stack.method_57375(lookup));
        }
        if (original.method_10573("components", 10) && (comp = class_9323.field_50234.decode((DynamicOps)(ops = lookup.method_57093((DynamicOps)class_2509.field_11560)), (Object)original.method_10562("components"))).isSuccess()) {
            class_9323 map = (class_9323)((Pair)comp.getOrThrow()).getFirst();
            class_9323.class_9324 builder = null;
            for (class_9336 component : map) {
                TransformingComponent transformingComponent;
                Object object = component.comp_2444();
                if (object instanceof TransformingComponent && (transformingComponent = (TransformingComponent)object).polymer$requireModification(context)) {
                    if (builder == null) {
                        builder = class_9323.method_57827();
                        builder.method_57839(map);
                    }
                    builder.method_57840(component.comp_2443(), transformingComponent.polymer$getTransformed(context));
                    continue;
                }
                if (PolymerComponent.canSync(component.comp_2443(), component.comp_2444(), context)) continue;
                if (builder == null) {
                    builder = class_9323.method_57827();
                    builder.method_57839(map);
                }
                builder.method_57840(component.comp_2443(), null);
            }
            if (builder != null) {
                if (override == null) {
                    override = original.method_10553();
                }
                override.method_10566("components", (class_2520)class_9323.field_50234.encodeStart((DynamicOps)ops, (Object)builder.method_57838()).result().orElse(new class_2487()));
            }
        }
        return override != null ? override : original;
    }

    @FunctionalInterface
    public static interface MineEventListener {
        public boolean onBlockMine(class_2680 var1, class_2338 var2, class_3222 var3);
    }

    @FunctionalInterface
    public static interface BreakingProgressListener {
        public void onBreakingProgressUpdate(class_3222 var1, class_2338 var2, class_2680 var3, int var4);
    }
}

