/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.entity;

import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.entity.InternalEntityHelpers;
import eu.pb4.polymer.core.api.entity.PolymerVillagerProfession;
import eu.pb4.polymer.core.impl.interfaces.EntityAttachedPacket;
import eu.pb4.polymer.core.impl.networking.PolymerServerProtocol;
import eu.pb4.polymer.core.mixin.entity.EntityAccessor;
import eu.pb4.polymer.core.mixin.entity.PlayerListS2CPacketAccessor;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2703;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class PolymerEntityUtils {
    private static final Set<class_1299<?>> ENTITY_TYPES = new ObjectOpenCustomHashSet(CommonImplUtils.IDENTITY_HASH);
    private static final Set<class_1320> ENTITY_ATTRIBUTES = new ObjectOpenCustomHashSet(CommonImplUtils.IDENTITY_HASH);
    private static final Map<class_3852, PolymerVillagerProfession> VILLAGER_PROFESSIONS = new Object2ObjectOpenCustomHashMap(CommonImplUtils.IDENTITY_HASH);

    private PolymerEntityUtils() {
    }

    public static int requestFreeId() {
        return EntityAccessor.getCURRENT_ID().incrementAndGet();
    }

    public static void registerType(class_1299<?> ... types) {
        ENTITY_TYPES.addAll(Arrays.asList(types));
        for (class_1299<?> type : types) {
            RegistrySyncUtils.setServerEntry((class_2378)class_7923.field_41177, type);
        }
    }

    @SafeVarargs
    public static void registerAttribute(class_6880<class_1320> ... attributes) {
        for (class_6880<class_1320> type : attributes) {
            ENTITY_ATTRIBUTES.add((class_1320)type.comp_349());
            RegistrySyncUtils.setServerEntry((class_2378)class_7923.field_41190, (Object)((class_1320)type.comp_349()));
        }
    }

    public static void registerProfession(class_3852 profession, PolymerVillagerProfession mapper) {
        VILLAGER_PROFESSIONS.put(profession, mapper);
        RegistrySyncUtils.setServerEntry((class_2378)class_7923.field_41195, (Object)profession);
    }

    @Nullable
    public static PolymerVillagerProfession getPolymerProfession(class_3852 profession) {
        return VILLAGER_PROFESSIONS.get(profession);
    }

    public static boolean isPolymerEntityType(class_1299<?> type) {
        return ENTITY_TYPES.contains(type);
    }

    public static boolean isPolymerEntityAttribute(class_6880<class_1320> type) {
        return ENTITY_ATTRIBUTES.contains(type.comp_349());
    }

    public static class_2945.class_2946<?>[] getDefaultTrackedData(class_1299<?> type) {
        return InternalEntityHelpers.getExampleTrackedDataOfEntityType(type);
    }

    public static <T extends class_1297> Class<T> getEntityClass(class_1299<T> type) {
        return InternalEntityHelpers.getEntityClass(type);
    }

    public static boolean isLivingEntity(class_1299<?> type) {
        return InternalEntityHelpers.isLivingEntity(type);
    }

    public static boolean isMobEntity(class_1299<?> type) {
        return InternalEntityHelpers.isMobEntity(type);
    }

    public static class_2703 createMutablePlayerListPacket(EnumSet<class_2703.class_5893> actions) {
        class_2703 packet = new class_2703(actions, List.of());
        ((PlayerListS2CPacketAccessor)packet).setEntries(new ArrayList<class_2703.class_2705>());
        return packet;
    }

    public static boolean canHoldEntityContext(class_2596<?> packet) {
        return packet instanceof EntityAttachedPacket;
    }

    public static <T extends class_2596<class_2602>> T setEntityContext(T packet, class_1297 entity) {
        return EntityAttachedPacket.setIfEmpty(packet, entity);
    }

    public static <T extends class_2596<class_2602>> T forceSetEntityContext(T packet, class_1297 entity) {
        return EntityAttachedPacket.set(packet, entity);
    }

    @Nullable
    public static class_1297 getEntityContext(class_2596<?> packet) {
        return EntityAttachedPacket.get(packet);
    }

    public static void sendEntityType(class_3222 player, int entityId, class_1299<?> entityType) {
        PolymerServerProtocol.sendEntityInfo(player.field_13987, entityId, entityType);
    }

    @Deprecated
    public static boolean isRegisteredEntityType(class_1299<?> type) {
        return ENTITY_TYPES.contains(type);
    }
}

