/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.item;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.api.events.BooleanEvent;
import eu.pb4.polymer.common.api.events.FunctionEvent;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.core.api.other.PolymerComponent;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.TransformingComponent;
import eu.pb4.polymer.core.impl.compat.polymc.PolyMcUtils;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import net.minecraft.class_5135;
import net.minecraft.class_5250;
import net.minecraft.class_6538;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8053;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9282;
import net.minecraft.class_9285;
import net.minecraft.class_9290;
import net.minecraft.class_9300;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.minecraft.class_9720;
import net.minecraft.class_9792;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public final class PolymerItemUtils {
    public static final String POLYMER_STACK = "$polymer:stack";
    private static final String POLYMC_STACK = "PolyMcOriginal";
    public static final MapCodec<class_1799> POLYMER_STACK_CODEC = class_1799.field_24671.fieldOf("$polymer:stack");
    public static final MapCodec<class_1799> POLYMER_STACK_UNCOUNTED_CODEC = class_1799.field_49747.fieldOf("$polymer:stack");
    public static final MapCodec<Boolean> POLYMER_STACK_HAS_COUNT_CODEC = Codec.BOOL.optionalFieldOf("$polymer:counted", (Object)false);
    public static final MapCodec<class_2960> POLYMER_STACK_ID_CODEC = class_2960.field_25139.fieldOf("id").fieldOf("$polymer:stack");
    private static final Codec<Map<class_2960, class_2520>> COMPONENTS_CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        class_2520 nbt = (class_2520)dynamic.convert((DynamicOps)class_2509.field_11560).getValue();
        return DataResult.success((Object)(nbt == dynamic.getValue() ? nbt.method_10707() : nbt));
    }, nbt -> new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10707())));
    public static final MapCodec<Map<class_2960, class_2520>> POLYMER_STACK_COMPONENTS_CODEC = COMPONENTS_CODEC.optionalFieldOf("components", Map.of()).fieldOf("$polymer:stack");
    private static final MapCodec<class_1799> POLYMC_STACK_CODEC = class_1799.field_49747.fieldOf("PolyMcOriginal");
    private static final MapCodec<class_2960> POLYMC_STACK_ID_CODEC = class_2960.field_25139.fieldOf("id").fieldOf("PolyMcOriginal");
    private static final MapCodec<Map<class_2960, class_2520>> POLYMC_STACK_COMPONENTS_CODEC = COMPONENTS_CODEC.optionalFieldOf("components", Map.of()).fieldOf("PolyMcOriginal");
    public static final class_2583 CLEAN_STYLE = class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1068);
    public static final BooleanEvent<Predicate<class_1799>> ITEM_CHECK = new BooleanEvent();
    public static final FunctionEvent<ItemModificationEventHandler, class_1799> ITEM_MODIFICATION_EVENT = new FunctionEvent();
    private static final class_9331<?>[] COMPONENTS_TO_COPY = new class_9331[]{class_9334.field_49635, class_9334.field_49634, class_9334.field_49611, class_9334.field_49607, class_9334.field_50077, class_9334.field_50071, class_9334.field_50075, class_9334.field_50076, class_9334.field_49616, class_9334.field_49615, class_9334.field_49629, class_9334.field_50072, class_9334.field_49636, class_9334.field_49619, class_9334.field_49620, class_9334.field_50074, class_9334.field_49635, class_9334.field_49634, class_9334.field_49639, class_9334.field_49650, class_9334.field_50073, class_9334.field_49614, class_9334.field_49633, class_9334.field_49643, class_9334.field_49651, class_9334.field_49631, class_9334.field_52175, class_9334.field_49653, class_9334.field_49606, class_9334.field_49622};
    private static final List<HideableTooltip> HIDEABLE_TOOLTIPS = List.of(HideableTooltip.of(class_9334.field_49636, class_9285::method_58423), HideableTooltip.of(class_9334.field_49607, class_8053::method_58421), HideableTooltip.ofNeg(class_9334.field_49633, class_9304::method_57543, class_9304::method_58449), HideableTooltip.ofNeg(class_9334.field_49643, class_9304::method_57543, class_9304::method_58449), HideableTooltip.of(class_9334.field_49630, class_9300::method_58435), HideableTooltip.of(class_9334.field_49635, class_6538::method_58402), HideableTooltip.of(class_9334.field_49634, class_6538::method_58402), HideableTooltip.of(class_9334.field_52175, class_9792::method_60749));
    private static final Set<class_1741> ARMOR_MATERIALS = new ReferenceOpenHashSet();

    private PolymerItemUtils() {
    }

    public static class_1799 getPolymerItemStack(class_1799 itemStack, PacketContext context) {
        return PolymerItemUtils.getPolymerItemStack(itemStack, context.getRegistryWrapperLookup() != null ? context.getRegistryWrapperLookup() : PolymerImplUtils.FALLBACK_LOOKUP, context.getPlayer());
    }

    public static class_1799 getPolymerItemStack(class_1799 itemStack, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        return PolymerItemUtils.getPolymerItemStack(itemStack, PolymerUtils.getTooltipType(player), lookup, player);
    }

    public static class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipContext, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        if (PolymerItemUtils.getPolymerIdentifier(itemStack) != null) {
            return itemStack;
        }
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof PolymerItem) {
            PolymerItem item = (PolymerItem)class_17922;
            return item.getPolymerItemStack(itemStack, tooltipContext, lookup, player);
        }
        if (PolymerItemUtils.isPolymerServerItem(itemStack, player)) {
            return PolymerItemUtils.createItemStack(itemStack, tooltipContext, lookup, player);
        }
        if (ITEM_CHECK.invoke(x -> x.test(itemStack))) {
            return PolymerItemUtils.createItemStack(itemStack, tooltipContext, lookup, player);
        }
        return itemStack;
    }

    public static class_1799 getRealItemStack(class_1799 itemStack, class_7225.class_7874 lookup) {
        block6: {
            class_9279 custom = (class_9279)itemStack.method_57824(class_9334.field_49628);
            if (custom != null && custom.method_57450(POLYMER_STACK)) {
                try {
                    Boolean counted = custom.method_57446(POLYMER_STACK_HAS_COUNT_CODEC).result().orElse(Boolean.FALSE);
                    class_1799 x = (class_1799)(counted != false ? POLYMER_STACK_CODEC : POLYMER_STACK_UNCOUNTED_CODEC).decode((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup), (MapLike)class_2509.field_11560.method_29163((class_2520)custom.method_57463()).getOrThrow()).getOrThrow();
                    if (!counted.booleanValue()) {
                        x.method_7939(itemStack.method_7947());
                    }
                    return x;
                }
                catch (Throwable exception) {
                    if (!CommonImpl.LOG_MORE_ERRORS) break block6;
                    PacketContext context = PacketContext.get();
                    class_2520 nbt = null;
                    try {
                        nbt = itemStack.method_57375(lookup);
                    }
                    catch (Throwable e) {
                        CommonImpl.LOGGER.error("Failed to encode ItemStack for debugging! See lower warning for more info!", exception);
                    }
                    CommonImpl.LOGGER.warn("Failed to decode seemingly polymeric ItemStack for {}!\nClient item data: {}", new Object[]{context.getGameProfile() != null ? context.getGameProfile().getName() : "<UNKNOWN>", nbt != null ? class_2512.method_36118((class_2520)nbt) : "<ERROR>", exception});
                }
            }
        }
        return itemStack;
    }

    @Nullable
    public static class_2960 getPolymerIdentifier(class_1799 itemStack) {
        return PolymerItemUtils.getPolymerIdentifier((class_9279)itemStack.method_57824(class_9334.field_49628));
    }

    public static class_2960 getPolymerIdentifier(@Nullable class_9279 custom) {
        if (custom != null && custom.method_57450(POLYMER_STACK)) {
            try {
                return custom.method_57446(POLYMER_STACK_ID_CODEC).result().orElse(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static class_2960 getServerIdentifier(class_1799 itemStack) {
        return PolymerItemUtils.getServerIdentifier((class_9279)itemStack.method_57824(class_9334.field_49628));
    }

    @Nullable
    public static class_2960 getServerIdentifier(@Nullable class_9279 nbtData) {
        if (nbtData == null) {
            return null;
        }
        class_2960 x = PolymerItemUtils.getPolymerIdentifier(nbtData);
        if (x != null) {
            return x;
        }
        if (nbtData.method_57450(POLYMC_STACK)) {
            try {
                return nbtData.method_57446(POLYMC_STACK_ID_CODEC).result().orElse(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Map<class_2960, class_2520> getServerComponents(class_1799 stack) {
        return PolymerItemUtils.getServerComponents((class_9279)stack.method_57824(class_9334.field_49628));
    }

    @Nullable
    public static Map<class_2960, class_2520> getPolymerComponents(class_1799 stack) {
        return PolymerItemUtils.getPolymerComponents((class_9279)stack.method_57824(class_9334.field_49628));
    }

    @Nullable
    public static Map<class_2960, class_2520> getServerComponents(@Nullable class_9279 nbtData) {
        if (nbtData == null) {
            return null;
        }
        Map<class_2960, class_2520> x = PolymerItemUtils.getPolymerComponents(nbtData);
        if (x != null) {
            return x;
        }
        if (nbtData.method_57450(POLYMC_STACK)) {
            try {
                return nbtData.method_57446(POLYMC_STACK_COMPONENTS_CODEC).result().orElse(Map.of());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Map<class_2960, class_2520> getPolymerComponents(@Nullable class_9279 nbtData) {
        if (nbtData == null || PolymerItemUtils.getPolymerIdentifier(nbtData) == null) {
            return null;
        }
        return nbtData.method_57446(POLYMER_STACK_COMPONENTS_CODEC).result().orElse(Map.of());
    }

    public static boolean isPolymerServerItem(class_1799 itemStack) {
        return PolymerItemUtils.isPolymerServerItem(itemStack, PolymerUtils.getPlayerContext());
    }

    public static boolean isPolymerServerItem(class_1799 itemStack, PacketContext context) {
        return PolymerItemUtils.isPolymerServerItem(itemStack, context.getPlayer());
    }

    public static boolean isPolymerServerItem(class_1799 itemStack, @Nullable class_3222 player) {
        class_9282 display;
        if (PolymerItemUtils.getPolymerIdentifier(itemStack) != null) {
            return false;
        }
        if (itemStack.method_7909() instanceof PolymerItem) {
            return true;
        }
        PacketContext ctx = PacketContext.get();
        if (player != null && ctx.getPlayer() != player) {
            ctx = PacketContext.of((class_3222)player);
        }
        for (Map.Entry x2 : itemStack.method_57380().method_57846()) {
            TransformingComponent t;
            Object object;
            if (!PolymerComponent.canSync((class_9331)x2.getKey(), ((Optional)x2.getValue()).orElse(null), ctx)) {
                return true;
            }
            if (x2.getValue() == null || !((Optional)x2.getValue()).isPresent() || !((object = ((Optional)x2.getValue()).get()) instanceof TransformingComponent) || !(t = (TransformingComponent)object).polymer$requireModification(ctx)) continue;
            return true;
        }
        if (itemStack.method_57826(class_9334.field_49633) && ((class_9285)itemStack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326)).comp_2394()) {
            for (class_6880 ench : ((class_9304)itemStack.method_57825(class_9334.field_49633, (Object)class_9304.field_49385)).method_57534()) {
                List attributes = ((class_1887)ench.comp_349()).method_60034(class_9701.field_51668);
                if (attributes == null) continue;
                for (class_9720 attr : attributes) {
                    if (!PolymerEntityUtils.isPolymerEntityAttribute((class_6880<class_1320>)attr.comp_2718()) || !class_5135.method_26873((class_1299)class_1299.field_6097).method_27310(attr.comp_2718())) continue;
                    return true;
                }
            }
        }
        if (CompatStatus.POLYMER_RESOURCE_PACK && (display = (class_9282)itemStack.method_57824(class_9334.field_49644)) != null) {
            return PolymerResourcePackUtils.isColorTaken((int)display.comp_2384());
        }
        return ITEM_CHECK.invoke(x -> x.test(itemStack));
    }

    public static class_1799 createMinimalItemStack(class_1799 itemStack, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        class_1792 item = itemStack.method_7909();
        class_9280 x = (class_9280)itemStack.method_57824(class_9334.field_49637);
        int cmd = x != null ? x.comp_2382() : -1;
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof PolymerItem) {
            PolymerItem virtualItem = (PolymerItem)class_17922;
            ItemWithMetadata data = PolymerItemUtils.getItemSafely(virtualItem, itemStack, player);
            item = data.item();
            cmd = data.customModelData();
        }
        class_1799 out = new class_1799((class_1935)item, itemStack.method_7947());
        try {
            PolymerCommonUtils.executeWithoutNetworkingLogic(() -> out.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)((class_2487)POLYMER_STACK_CODEC.encoder().encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup), (Object)itemStack).getOrThrow()))));
        }
        catch (Throwable e) {
            out.method_57379(class_9334.field_49628, (Object)((class_9279)class_9279.field_49302.method_57447((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup), POLYMER_STACK_ID_CODEC, (Object)class_7923.field_41178.method_10221((Object)itemStack.method_7909())).getOrThrow()));
        }
        if (cmd != -1) {
            out.method_57379(class_9334.field_49637, (Object)new class_9280(cmd));
        }
        return out;
    }

    public static int getSafeColor(int inputColor) {
        if (inputColor % 2 == 1) {
            return Math.max(0, inputColor - 1);
        }
        return inputColor;
    }

    public static class_1799 createItemStack(class_1799 itemStack, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        return PolymerItemUtils.createItemStack(itemStack, PolymerUtils.getTooltipType(player), lookup, player);
    }

    public static class_1799 createItemStack(class_1799 itemStack, class_1836 tooltipContext, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        boolean storeCount;
        class_1792 item = itemStack.method_7909();
        int cmd = -1;
        int color = -1;
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof PolymerItem) {
            PolymerItem virtualItem = (PolymerItem)class_17922;
            ItemWithMetadata data = PolymerItemUtils.getItemSafely(virtualItem, itemStack, player);
            item = data.item();
            cmd = data.customModelData();
            color = data.color();
            storeCount = virtualItem.shouldStorePolymerItemStackCount();
        } else {
            storeCount = false;
        }
        class_1799 out = new class_1799((class_1935)item, itemStack.method_7947());
        for (class_9331 x : out.method_57353().method_57831()) {
            if (itemStack.method_57353().method_57829(x) != null) continue;
            out.method_57379(x, null);
        }
        PacketContext ctx = PacketContext.get();
        if (player != null && ctx.getPlayer() != player) {
            ctx = PacketContext.of((class_3222)player);
        }
        for (int i = 0; i < COMPONENTS_TO_COPY.length; ++i) {
            class_9331<?> key = COMPONENTS_TO_COPY[i];
            Object x = itemStack.method_57824(key);
            if (x instanceof TransformingComponent) {
                TransformingComponent t = (TransformingComponent)x;
                out.method_57379(key, t.polymer$getTransformed(ctx));
                continue;
            }
            out.method_57379(key, itemStack.method_57824(key));
        }
        try {
            PolymerCommonUtils.executeWithoutNetworkingLogic(() -> {
                class_9279 comp = class_9279.method_57456((class_2487)((class_2487)(storeCount ? POLYMER_STACK_CODEC : POLYMER_STACK_UNCOUNTED_CODEC).encoder().encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup), (Object)itemStack).getOrThrow()));
                if (storeCount) {
                    out.method_57379(class_9334.field_49628, (Object)((class_9279)comp.method_57447((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup), POLYMER_STACK_HAS_COUNT_CODEC, (Object)true).getOrThrow()));
                } else {
                    out.method_57379(class_9334.field_49628, (Object)comp);
                }
            });
        }
        catch (Throwable e) {
            out.method_57379(class_9334.field_49628, (Object)((class_9279)class_9279.field_49302.method_57447((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup), POLYMER_STACK_ID_CODEC, (Object)class_7923.field_41178.method_10221((Object)itemStack.method_7909())).getOrThrow()));
        }
        if (cmd == -1 && itemStack.method_57826(class_9334.field_49637)) {
            out.method_57379(class_9334.field_49637, (Object)((class_9280)itemStack.method_57824(class_9334.field_49637)));
        } else if (cmd != -1) {
            out.method_57379(class_9334.field_49637, (Object)new class_9280(cmd));
        }
        if (color == -1 && itemStack.method_57826(class_9334.field_49644)) {
            out.method_57379(class_9334.field_49644, (Object)new class_9282(PolymerItemUtils.getSafeColor(((class_9282)itemStack.method_57824(class_9334.field_49644)).comp_2384()), false));
        } else if (color != -1) {
            out.method_57379(class_9334.field_49644, (Object)new class_9282(color, false));
        }
        out.method_57379(class_9334.field_49638, (Object)class_3902.field_17274);
        for (HideableTooltip x : HIDEABLE_TOOLTIPS) {
            Object a = out.method_57824(x.type);
            if (a == null || !x.shouldSet.test(a)) continue;
            out.method_57379(x.type, x.setter.setTooltip(a, false));
        }
        out.method_57379(class_9334.field_49641, (Object)itemStack.method_7958());
        try {
            List tooltip = itemStack.method_7950(player != null ? class_1792.class_9635.method_59528((class_1937)player.method_37908()) : class_1792.class_9635.field_51353, (class_1657)player, tooltipContext);
            if (!tooltip.isEmpty()) {
                out.method_57379(class_9334.field_50239, (Object)((class_2561)tooltip.remove(0)));
                if (itemStack.method_7909() instanceof PolymerItem) {
                    ((PolymerItem)itemStack.method_7909()).modifyClientTooltip(tooltip, itemStack, player);
                }
                ArrayList<class_5250> lore = new ArrayList<class_5250>();
                for (TransformingComponent t : tooltip) {
                    lore.add(class_2561.method_43473().method_10852((class_2561)t).method_10862(CLEAN_STYLE));
                }
                out.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
            }
        }
        catch (Throwable e) {
            if (PolymerImpl.LOG_MORE_ERRORS) {
                PolymerImpl.LOGGER.error("Failed to get tooltip of " + String.valueOf(itemStack), e);
            }
            out.method_57379(class_9334.field_50239, (Object)((class_2561)itemStack.method_57825(class_9334.field_50239, (Object)itemStack.method_7909().method_7864(itemStack))));
        }
        return (class_1799)ITEM_MODIFICATION_EVENT.invoke(col -> {
            class_1799 custom = out;
            for (ItemModificationEventHandler in : col) {
                custom = in.modifyItem(itemStack, custom, player);
            }
            return custom;
        });
    }

    public static ItemWithMetadata getItemSafely(PolymerItem item, class_1799 stack, @Nullable class_3222 player, int maxDistance) {
        PolymerItem newItem;
        class_1792 out = item.getPolymerItem(stack, player);
        PolymerItem lastVirtual = item;
        for (int req = 0; out instanceof PolymerItem && (newItem = (PolymerItem)out) != item && req < maxDistance; ++req) {
            out = newItem.getPolymerItem(stack, player);
            lastVirtual = newItem;
        }
        return new ItemWithMetadata(out, lastVirtual.getPolymerCustomModelData(stack, player), lastVirtual.getPolymerArmorColor(stack, player));
    }

    public static ItemWithMetadata getItemSafely(PolymerItem item, class_1799 stack, @Nullable class_3222 player) {
        return PolymerItemUtils.getItemSafely(item, stack, player, 32);
    }

    @SafeVarargs
    public static void registerArmorMaterial(class_6880<class_1741> ... types) {
        for (class_6880<class_1741> type : types) {
            RegistrySyncUtils.setServerEntry((class_2378)class_7923.field_48976, (Object)((class_1741)type.comp_349()));
            ARMOR_MATERIALS.add((class_1741)type.comp_349());
        }
    }

    public static boolean isPolymerArmorMaterial(class_6880<class_1741> type) {
        return ARMOR_MATERIALS.contains(type.comp_349());
    }

    @Deprecated
    public static void markAsPolymer(class_9331<?> ... types) {
        PolymerComponent.registerDataComponent(types);
    }

    @Deprecated
    public static boolean isPolymerComponent(class_9331<?> type) {
        return PolymerComponent.isPolymerComponent(type);
    }

    public static class_1799 getClientItemStack(class_1799 stack, class_3222 player) {
        class_1799 out = PolymerItemUtils.getPolymerItemStack(stack, (class_7225.class_7874)player.method_56673(), player);
        if (CompatStatus.POLYMC) {
            out = PolyMcUtils.toVanilla(out, player);
        }
        return out;
    }

    public record ItemWithMetadata(class_1792 item, int customModelData, int color) {
    }

    private record HideableTooltip<T>(class_9331<T> type, Predicate<T> shouldSet, TooltipSetter<T> setter) {
        public static <T> HideableTooltip<T> of(class_9331<T> type, TooltipSetter<T> setter) {
            return new HideableTooltip<Object>(type, x -> true, setter);
        }

        public static <T> HideableTooltip<T> of(class_9331<T> type, Predicate<T> shouldSet, TooltipSetter<T> setter) {
            return new HideableTooltip<T>(type, shouldSet, setter);
        }

        public static <T> HideableTooltip<T> ofNeg(class_9331<T> type, Predicate<T> shouldntSet, TooltipSetter<T> setter) {
            return new HideableTooltip<T>(type, shouldntSet.negate(), setter);
        }

        static interface TooltipSetter<T> {
            public T setTooltip(T var1, boolean var2);
        }
    }

    @FunctionalInterface
    public static interface ItemModificationEventHandler {
        public class_1799 modifyItem(class_1799 var1, class_1799 var2, class_3222 var3);
    }
}

