/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.core.api.block.BlockMapper;
import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.api.other.PolymerStat;
import eu.pb4.polymer.core.api.utils.PolymerSyncUtils;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.networking.PolymerServerProtocol;
import eu.pb4.polymer.core.impl.ui.CreativeTabListUi;
import eu.pb4.polymer.core.impl.ui.CreativeTabUi;
import eu.pb4.polymer.core.impl.ui.PotionUi;
import eu.pb4.polymer.core.mixin.block.PalettedContainerAccessor;
import eu.pb4.polymer.networking.impl.ExtClientConnection;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1675;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3908;
import net.minecraft.class_3916;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5628;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8609;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class Commands {
    public static void register(LiteralArgumentBuilder<class_2168> command, class_7157 access) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").requires(CommonImplUtils.permission((String)"command.stats", (int)0))).executes(Commands::statsGeneral)).then(class_2170.method_9244((String)"type", (ArgumentType)class_7733.method_45603((class_7157)access, (class_5321)class_7924.field_41226)).executes(Commands::stats)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"effects").requires(CommonImplUtils.permission((String)"command.effects", (int)0))).executes(Commands::effects))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"client-item").requires(CommonImplUtils.permission((String)"command.client-item", (int)3))).executes(Commands::displayClientItem)).then(class_2170.method_9247((String)"get").executes(Commands::getClientItem)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"export-registry").requires(CommonImplUtils.permission((String)"command.export-registry", (int)3))).executes(Commands::dumpRegistries))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"target-block").requires(CommonImplUtils.permission((String)"command.target-block", (int)3))).executes(Commands::targetBlock))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"target-item").requires(CommonImplUtils.permission((String)"command.target-item", (int)3))).executes(Commands::targetItem))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pick").requires(CommonImplUtils.permission((String)"command.pick", (int)0))).executes(ctx -> Commands.pickTarget((CommandContext<class_2168>)ctx, false))).then(class_2170.method_9247((String)"withnbt").executes(ctx -> Commands.pickTarget((CommandContext<class_2168>)ctx, true))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"creative").requires(CommonImplUtils.permission((String)"command.creative", (int)0))).then(class_2170.method_9244((String)"itemGroup", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            List<class_1761> groups = PolymerItemGroupUtils.getItemGroups(((class_2168)context.getSource()).method_9207());
            class_2172.method_9268(groups, (String)remaining, arg_0 -> ((class_2378)class_7923.field_44687).method_10221(arg_0), group -> builder.suggest(class_7923.field_44687.method_10221(group).toString(), (Message)group.method_7737()));
            return builder.buildFuture();
        }).executes(Commands::creativeTab))).executes(Commands::creativeTab));
    }

    private static int pickTarget(CommandContext<class_2168> serverCommandSourceCommandContext, boolean withNbt) throws CommandSyntaxException {
        class_238 box;
        class_3222 player = ((class_2168)serverCommandSourceCommandContext.getSource()).method_9207();
        double range = player.method_55755();
        class_243 min = player.method_5836(0.0f);
        class_243 rot = player.method_5828(0.0f);
        class_243 max = min.method_1031(rot.field_1352 * range, rot.field_1351 * range, rot.field_1350 * range);
        class_3966 entityHit = class_1675.method_18075((class_1297)player, (class_243)min, (class_243)max, (class_238)(box = player.method_5829().method_18804(rot.method_1021(range)).method_1009(1.0, 1.0, 1.0)), entity -> !player.method_7325() && entity.method_5863(), (double)range);
        if (entityHit != null) {
            PolymerImplUtils.pickEntity(player, entityHit.method_17782());
            return 1;
        }
        class_239 hit = player.method_5745(player.method_55754(), 0.0f, false);
        if (hit instanceof class_3965) {
            class_3965 result = (class_3965)hit;
            if (hit.method_17783() != class_239.class_240.field_1333) {
                PolymerImplUtils.pickBlock(player, result.method_17777(), withNbt);
                return 2;
            }
        }
        return 0;
    }

    public static void registerDev(LiteralArgumentBuilder<class_2168> dev) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)dev.then(class_2170.method_9247((String)"reload-world").executes(ctx -> {
            PolymerUtils.reloadWorld(((class_2168)ctx.getSource()).method_44023());
            return 0;
        }))).then(class_2170.method_9247((String)"get-mapper").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)BlockMapper.getFrom(((class_2168)ctx.getSource()).method_44023()).getMapperName()), false);
            return 0;
        }))).then(class_2170.method_9247((String)"reset-mapper").executes(ctx -> {
            BlockMapper.resetMapper(((class_2168)ctx.getSource()).method_44023());
            return 0;
        }))).then(class_2170.method_9247((String)"run-sync").executes(ctx -> {
            PolymerSyncUtils.synchronizePolymerRegistries(((class_2168)ctx.getSource()).method_44023().field_13987);
            return 0;
        }))).then(class_2170.method_9247((String)"protocol-info").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Protocol supported by your client:"), false);
            for (Object2IntMap.Entry entry : ExtClientConnection.of((class_8609)((class_2168)ctx.getSource()).method_44023().field_13987).polymerNet$getSupportMap().object2IntEntrySet()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("- " + String.valueOf(entry.getKey()) + " = " + entry.getIntValue())), false);
            }
            return 0;
        }))).then(class_2170.method_9247((String)"validate_states").executes(ctx -> {
            PolymerServerProtocol.sendDebugValidateStatesPackets(((class_2168)ctx.getSource()).method_44023().field_13987);
            return 0;
        }))).then(class_2170.method_9247((String)"set-pack-status").then(class_2170.method_9244((String)"status", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(ctx -> {
            Boolean status = (Boolean)ctx.getArgument("status", Boolean.class);
            PolymerCommonUtils.setHasResourcePack((class_3222)((class_2168)ctx.getSource()).method_9207(), (UUID)class_5242.method_27645((CommandContext)ctx, (String)"uuid"), (boolean)status);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("New resource pack status: " + status)), false);
            return 0;
        }))))).then(class_2170.method_9247((String)"get-pack-status").executes(ctx -> {
            boolean status = PolymerUtils.hasResourcePack(((class_2168)ctx.getSource()).method_44023(), PolymerResourcePackUtils.getMainUuid());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Resource pack status: " + status)), false);
            return 0;
        }))).then(class_2170.method_9247((String)"chunk_section_info").executes(ctx -> {
            class_2791 chunk = ((class_2168)ctx.getSource()).method_9225().method_22350(((class_2168)ctx.getSource()).method_44023().method_24515());
            class_2826 s = chunk.method_38259(((class_2168)ctx.getSource()).method_9225().method_31602(((class_2168)ctx.getSource()).method_44023().method_31478()));
            class_2841.class_6561 a = ((PalettedContainerAccessor)s.method_12265()).getData();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Chunk: " + String.valueOf(chunk.method_12004()) + " Palette: " + String.valueOf(a.comp_119()) + " |  Storage: " + String.valueOf(a.comp_118()) + " | Bits: " + a.comp_118().method_34896())), false);
            return 0;
        }));
    }

    private static int targetBlock(CommandContext<class_2168> context) {
        class_3965 raycast = (class_3965)((class_2168)context.getSource()).method_44023().method_5745(10.0, 0.0f, true);
        StringBuilder builder = new StringBuilder();
        class_2680 state = ((class_2168)context.getSource()).method_9225().method_8320(raycast.method_17777());
        builder.append(class_7923.field_41175.method_10221((Object)state.method_26204()));
        if (!state.method_26204().method_9595().method_11659().isEmpty()) {
            builder.append("[");
            Iterator iterator = state.method_26204().method_9595().method_11659().iterator();
            while (iterator.hasNext()) {
                class_2769 property = (class_2769)iterator.next();
                builder.append(property.method_11899());
                builder.append("=");
                builder.append(property.method_11901(state.method_11654(property)));
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            builder.append("]");
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)builder.toString()), false);
        return 0;
    }

    private static int targetItem(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1799 itemStack = ((class_2168)context.getSource()).method_9207().method_6047();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_54154((class_2960)class_7923.field_41178.method_10221((Object)itemStack.method_7909())), false);
        return 0;
    }

    private static int dumpRegistries(CommandContext<class_2168> context) {
        String path = PolymerImplUtils.dumpRegistry();
        if (path != null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Exported registry state as " + path)), false);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Couldn't export registry!"));
        }
        return 0;
    }

    private static int effects(CommandContext<class_2168> context) throws CommandSyntaxException {
        new PotionUi(((class_2168)context.getSource()).method_44023());
        return 1;
    }

    private static int statsGeneral(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        ArrayList<class_9262> list = new ArrayList<class_9262>();
        int line = 0;
        class_5250 text = null;
        for (class_3448 statType : class_7923.field_41193) {
            if (text == null) {
                text = class_2561.method_43470((String)"");
            }
            text.method_10852((class_2561)class_2561.method_43473().method_27693(class_7923.field_41193.method_10221((Object)statType).toString()).method_27693("\n").method_27694(x -> x.method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1078).method_10958(new class_2558(class_2558.class_2559.field_11750, "/polymer stats " + String.valueOf(class_7923.field_41193.method_10221((Object)statType))))));
            if (++line != 13) continue;
            list.add(class_9262.method_57137((Object)text));
            text = null;
            line = 0;
        }
        if (text != null) {
            list.add(class_9262.method_57137(text));
        }
        final class_1799 stack = new class_1799((class_1935)class_1802.field_8360);
        stack.method_57379(class_9334.field_49606, (Object)new class_9302(class_9262.method_57137((Object)"/polymer start"), player.method_7334().getName(), 0, list, false));
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43473();
            }

            @Nullable
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_3916 lectern = new class_3916(this, syncId){

                    public boolean method_7613(class_1799 stack, class_1735 slot) {
                        return false;
                    }

                    public boolean method_7615(class_1735 slot) {
                        return false;
                    }

                    public boolean method_7604(class_1657 player, int id) {
                        if (id == 3) {
                            return false;
                        }
                        return super.method_7604(player, id);
                    }

                    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
                    }
                };
                lectern.method_7611(0).method_53512(stack);
                return lectern;
            }
        });
        return 1;
    }

    private static int stats(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        ArrayList<class_9262> list = new ArrayList<class_9262>();
        int line = 0;
        class_5250 text = null;
        class_3448 type = (class_3448)class_7733.method_45602(context, (String)"type", (class_5321)class_7924.field_41226).comp_349();
        for (Object statObj : type.method_14959()) {
            class_2561 title;
            if (!PolymerUtils.isServerOnly(statObj) || !type.method_14958(statObj)) continue;
            class_3445 stat = type.method_14956(statObj);
            if (text == null) {
                text = class_2561.method_43470((String)"");
            }
            int statVal = player.method_14248().method_15025(stat);
            if (statObj instanceof class_2960) {
                class_2960 stat1 = (class_2960)statObj;
                title = PolymerStat.getName(stat1);
            } else if (statObj instanceof class_1792) {
                class_1792 item = (class_1792)statObj;
                title = item.method_7848();
            } else if (statObj instanceof class_2248) {
                class_2248 item = (class_2248)statObj;
                title = item.method_9518();
            } else if (statObj instanceof class_1299) {
                class_1299 item = (class_1299)statObj;
                title = item.method_5897();
            } else {
                title = class_2561.method_43471((String)class_156.method_646((String)type.method_14959().method_30517().method_29177().method_12832(), (class_2960)type.method_14959().method_10221(statObj)));
            }
            text.method_10852(title).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(stat.method_14953(statVal) + "\n")).method_27692(class_124.field_1063));
            if (++line != 13) continue;
            list.add(class_9262.method_57137((Object)text));
            text = null;
            line = 0;
        }
        if (text != null) {
            list.add(class_9262.method_57137(text));
        }
        final class_1799 stack = new class_1799((class_1935)class_1802.field_8360);
        stack.method_57379(class_9334.field_49606, (Object)new class_9302(class_9262.method_57137((Object)"/polymer start"), player.method_7334().getName(), 0, list, false));
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43473();
            }

            @Nullable
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_3916 lectern = new class_3916(this, syncId){

                    public boolean method_7613(class_1799 stack, class_1735 slot) {
                        return false;
                    }

                    public boolean method_7615(class_1735 slot) {
                        return false;
                    }

                    public boolean method_7604(class_1657 player, int id) {
                        if (id == 3) {
                            return false;
                        }
                        return super.method_7604(player, id);
                    }

                    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
                    }
                };
                lectern.method_7611(0).method_53512(stack);
                return lectern;
            }
        });
        return 1;
    }

    private static int creativeTab(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_44023().method_7337()) {
            try {
                class_2960 id = (class_2960)context.getArgument("itemGroup", class_2960.class);
                class_1761 itemGroup = (class_1761)class_7923.field_44687.method_10223(id);
                if (itemGroup != null) {
                    new CreativeTabUi(((class_2168)context.getSource()).method_44023(), itemGroup);
                    return 2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            new CreativeTabListUi(((class_2168)context.getSource()).method_44023());
            return 1;
        }
        return 0;
    }

    private static int displayClientItem(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        class_1799 stack = PolymerItemUtils.getPolymerItemStack(player.method_6047(), (class_7225.class_7874)((class_2168)context.getSource()).method_30497(), player).method_7972();
        stack.method_57381(class_9334.field_49628);
        ((class_2168)context.getSource()).method_9226(() -> new class_5628("").method_32305(stack.method_57358((class_7225.class_7874)((class_2168)context.getSource()).method_30497())), false);
        return 1;
    }

    private static int getClientItem(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        class_1799 stack = PolymerItemUtils.getPolymerItemStack(player.method_6047(), (class_7225.class_7874)((class_2168)context.getSource()).method_30497(), player);
        stack.method_57381(class_9334.field_49628);
        player.method_7270(stack);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Given client representation to player"), true);
        return 1;
    }
}

