/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.client.networking;

import com.mojang.brigadier.StringReader;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.core.api.client.ClientPolymerBlock;
import eu.pb4.polymer.core.api.client.ClientPolymerEntityType;
import eu.pb4.polymer.core.api.client.ClientPolymerEntry;
import eu.pb4.polymer.core.api.client.ClientPolymerItem;
import eu.pb4.polymer.core.api.client.PolymerClientUtils;
import eu.pb4.polymer.core.api.utils.PolymerClientDecoded;
import eu.pb4.polymer.core.impl.ClientMetadataKeys;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.ServerMetadataKeys;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import eu.pb4.polymer.core.impl.client.interfaces.ClientBlockStorageInterface;
import eu.pb4.polymer.core.impl.client.interfaces.ClientEntityExtension;
import eu.pb4.polymer.core.impl.client.interfaces.ClientItemGroupExtension;
import eu.pb4.polymer.core.impl.networking.S2CPackets;
import eu.pb4.polymer.core.impl.networking.entry.DebugBlockStateEntry;
import eu.pb4.polymer.core.impl.networking.entry.IdValueEntry;
import eu.pb4.polymer.core.impl.networking.entry.PolymerBlockEntry;
import eu.pb4.polymer.core.impl.networking.entry.PolymerBlockStateEntry;
import eu.pb4.polymer.core.impl.networking.entry.PolymerEntityEntry;
import eu.pb4.polymer.core.impl.networking.entry.PolymerItemEntry;
import eu.pb4.polymer.core.impl.networking.entry.PolymerTagEntry;
import eu.pb4.polymer.core.impl.networking.payloads.PolymerGenericListPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerBlockUpdateS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerEntityS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerItemGroupApplyUpdateS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerItemGroupContentAddS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerItemGroupContentClearS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerItemGroupDefineS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerItemGroupRemoveS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerSectionUpdateS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerSyncClearS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerSyncFinishedS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerSyncStartedS2CPayload;
import eu.pb4.polymer.core.impl.other.EventRunners;
import eu.pb4.polymer.core.impl.other.ImplPolymerRegistry;
import eu.pb4.polymer.core.mixin.other.ItemGroupsAccessor;
import eu.pb4.polymer.networking.api.client.PolymerClientNetworking;
import eu.pb4.polymer.networking.impl.NetImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_155;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2481;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4614;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8673;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class PolymerClientProtocolHandler {
    public static final Map<class_2960, Consumer<?>> GENERIC_LIST_HANDLERS = new HashMap();
    private static long syncStarted = -1L;

    public static void register() {
        PolymerClientNetworking.registerPlayHandler(PolymerBlockUpdateS2CPayload.class, PolymerClientProtocolHandler::handleSetBlock);
        PolymerClientNetworking.registerPlayHandler(PolymerSectionUpdateS2CPayload.class, PolymerClientProtocolHandler::handleWorldSectionUpdate);
        PolymerClientNetworking.registerPlayHandler(PolymerEntityS2CPayload.class, PolymerClientProtocolHandler::handleEntity);
        PolymerClientNetworking.registerCommonHandler(PolymerSyncStartedS2CPayload.class, (handler, version, buf) -> {
            syncStarted = System.currentTimeMillis();
            PolymerClientUtils.ON_SYNC_STARTED.invoke(EventRunners.RUN);
        });
        PolymerClientNetworking.registerCommonHandler(PolymerSyncFinishedS2CPayload.class, (handler, version, buf) -> {
            if (PolymerImpl.LOG_SYNC_TIME_CLIENT) {
                PolymerImpl.LOGGER.info("Polymer Sync took {} ms", (Object)(System.currentTimeMillis() - syncStarted));
            }
            PolymerClientUtils.ON_SYNC_FINISHED.invoke(EventRunners.RUN);
        });
        PolymerClientNetworking.registerCommonHandler(PolymerItemGroupDefineS2CPayload.class, PolymerClientProtocolHandler::handleItemGroupDefine);
        PolymerClientNetworking.registerCommonHandler(PolymerItemGroupContentAddS2CPayload.class, PolymerClientProtocolHandler::handleItemGroupContentsAdd);
        PolymerClientNetworking.registerCommonHandler(PolymerItemGroupContentClearS2CPayload.class, PolymerClientProtocolHandler::handleItemGroupContentsClear);
        PolymerClientNetworking.registerCommonHandler(PolymerItemGroupRemoveS2CPayload.class, PolymerClientProtocolHandler::handleItemGroupRemove);
        PolymerClientNetworking.registerCommonHandler(PolymerItemGroupApplyUpdateS2CPayload.class, PolymerClientProtocolHandler::handleItemGroupApplyUpdates);
        PolymerClientNetworking.registerCommonHandler(PolymerSyncClearS2CPayload.class, (client, handler, payload) -> InternalClientRegistry.clear());
        PolymerClientNetworking.registerCommonHandler(PolymerSyncClearS2CPayload.class, (client, handler, payload) -> InternalClientRegistry.clear());
        PolymerClientNetworking.registerCommonHandler(PolymerGenericListPayload.class, PolymerClientProtocolHandler::handleGenericList);
        PolymerClientProtocolHandler.registerGenericListHandler(S2CPackets.SYNC_BLOCK, PolymerBlockEntry.class, (T entry) -> InternalClientRegistry.BLOCKS.set(entry.identifier(), entry.numId(), new ClientPolymerBlock(entry.identifier(), entry.numId(), entry.text(), entry.visual(), (class_2248)class_7923.field_41175.method_10223(entry.identifier()))));
        PolymerClientProtocolHandler.registerGenericListHandler(S2CPackets.SYNC_ITEM, PolymerItemEntry.class, (T entry) -> {
            Optional regEntry = class_7923.field_41178.method_40264(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)entry.identifier()));
            InternalClientRegistry.ITEMS.set(entry.identifier(), entry.numId(), new ClientPolymerItem(entry.identifier(), entry.representation(), regEntry.isPresent() ? (class_1792)((class_6880.class_6883)regEntry.get()).comp_349() : null));
        });
        PolymerClientProtocolHandler.registerGenericListHandler(S2CPackets.SYNC_BLOCKSTATE, PolymerBlockStateEntry.class, (T entry) -> InternalClientRegistry.BLOCK_STATES.method_10203(new ClientPolymerBlock.State(entry.properties(), InternalClientRegistry.BLOCKS.method_10200(entry.blockId()), PolymerClientProtocolHandler.blockStateOrNull(entry.properties(), InternalClientRegistry.BLOCKS.method_10200(entry.blockId()))), entry.numId()));
        PolymerClientProtocolHandler.registerGenericListHandler(S2CPackets.SYNC_ENTITY, PolymerEntityEntry.class, (T entry) -> InternalClientRegistry.ENTITY_TYPES.set(entry.identifier(), entry.rawId(), new ClientPolymerEntityType(entry.identifier(), entry.name(), (class_1299)class_7923.field_41177.method_10223(entry.identifier()))));
        PolymerClientProtocolHandler.registerGenericListHandler(S2CPackets.SYNC_VILLAGER_PROFESSION, InternalClientRegistry.VILLAGER_PROFESSIONS, class_7923.field_41195);
        PolymerClientProtocolHandler.registerGenericListHandler(S2CPackets.SYNC_BLOCK_ENTITY, InternalClientRegistry.BLOCK_ENTITY, class_7923.field_41181);
        PolymerClientProtocolHandler.registerGenericListHandler(S2CPackets.SYNC_STATUS_EFFECT, InternalClientRegistry.STATUS_EFFECT, class_7923.field_41174);
        PolymerClientProtocolHandler.registerGenericListHandler(S2CPackets.SYNC_FLUID, InternalClientRegistry.FLUID, class_7923.field_41173);
        PolymerClientProtocolHandler.registerGenericListHandler(S2CPackets.SYNC_TAGS, PolymerTagEntry.class, PolymerClientProtocolHandler::registerTag);
        PolymerClientProtocolHandler.registerGenericListHandler(S2CPackets.DEBUG_VALIDATE_STATES, DebugBlockStateEntry.class, PolymerClientProtocolHandler::handleDebugValidateStates);
        PolymerClientNetworking.AFTER_METADATA_RECEIVED.register(() -> {
            InternalClientRegistry.setVersion(PolymerClientNetworking.getServerVersion(), (class_2497)PolymerClientNetworking.getMetadata((class_2960)ServerMetadataKeys.MINECRAFT_PROTOCOL, (class_4614)class_2497.field_21037));
            class_2481 limitedF3 = (class_2481)PolymerClientNetworking.getMetadata((class_2960)ServerMetadataKeys.LIMITED_F3, (class_4614)class_2481.field_21025);
            InternalClientRegistry.limitedF3 = limitedF3 != null && limitedF3.method_10698() != 0;
        });
        PolymerClientNetworking.AFTER_DISABLE.register(InternalClientRegistry::disable);
        PolymerClientNetworking.BEFORE_METADATA_SYNC.register(() -> {
            PolymerClientNetworking.setClientMetadata((class_2960)ClientMetadataKeys.ADVANCED_TOOLTIP, (class_2520)class_2481.method_23234((boolean)class_310.method_1551().field_1690.field_1827));
            PolymerClientNetworking.setClientMetadata((class_2960)ClientMetadataKeys.BLOCKSTATE_BITS, (class_2520)class_2497.method_23247((int)class_3532.method_15342((int)class_2248.field_10651.method_10204())));
            PolymerClientNetworking.setClientMetadata((class_2960)ClientMetadataKeys.MINECRAFT_PROTOCOL, (class_2520)class_2497.method_23247((int)class_155.method_31372()));
        });
    }

    private static <T> void registerGenericListHandler(class_2960 id, Class<T> targetClass, Consumer<T> consumer) {
        GENERIC_LIST_HANDLERS.put(id, consumer);
    }

    private static <T> void registerGenericListHandler(class_2960 id, ImplPolymerRegistry<ClientPolymerEntry<T>> polymerRegistry, class_2378<T> vanillaRegistry) {
        PolymerClientProtocolHandler.registerGenericListHandler(id, IdValueEntry.class, (T entry) -> polymerRegistry.set(entry.id(), entry.rawId(), ClientPolymerEntry.of(entry.id(), vanillaRegistry)));
    }

    private static void registerTag(PolymerTagEntry tagEntry) {
        ImplPolymerRegistry<ClientPolymerEntry<?>> reg = InternalClientRegistry.BY_VANILLA_ID.get(tagEntry.registry());
        if (reg != null) {
            for (PolymerTagEntry.TagData tag : tagEntry.tags()) {
                reg.createTag(tag.id(), tag.ids());
            }
        }
    }

    private static void handleDebugValidateStates(DebugBlockStateEntry entry) {
        if (CommonImpl.DEVELOPER_MODE) {
            class_338 chat = class_310.method_1551().field_1705.method_1743();
            class_2680 state = (class_2680)class_2248.field_10651.method_10200(entry.numId());
            if (state == null) {
                chat.method_1812((class_2561)class_2561.method_43470((String)("Missing BlockState! | " + entry.numId() + " | Server: " + entry.asString())));
            } else {
                DebugBlockStateEntry debug = DebugBlockStateEntry.of(state, null, 0);
                if (!debug.equals(entry)) {
                    chat.method_1812((class_2561)class_2561.method_43470((String)("Mismatched BlockState! | " + entry.numId() + " | Server: " + entry.asString() + " | Client: " + debug.asString())));
                }
            }
        }
    }

    @Nullable
    private static class_2680 blockStateOrNull(Map<String, String> states, ClientPolymerBlock clientPolymerBlock) {
        if (clientPolymerBlock.registryEntry() != null) {
            StringBuilder path = new StringBuilder(clientPolymerBlock.identifier().toString());
            if (!states.isEmpty()) {
                path.append("[");
                Iterator<Map.Entry<String, String>> iterator = states.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    path.append(entry.getKey()).append("=").append(entry.getValue());
                    if (!iterator.hasNext()) continue;
                    path.append(",");
                }
                path.append("]");
            }
            try {
                class_2259.class_7211 parsed = class_2259.method_41955((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(path.toString()), (boolean)false);
                return parsed.comp_622();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static void handleItemGroupApplyUpdates(class_310 client, class_8673 handler, PolymerItemGroupApplyUpdateS2CPayload payload) {
        if (InternalClientRegistry.enabled) {
            class_310.method_1551().execute(() -> {
                if (ItemGroupsAccessor.getDisplayContext() != null) {
                    ItemGroupsAccessor.callUpdateEntries(ItemGroupsAccessor.getDisplayContext());
                }
                PolymerClientUtils.ON_SEARCH_REBUILD.invoke(EventRunners.RUN);
            });
        }
    }

    private static void handleItemGroupDefine(class_310 client, class_8673 handler, PolymerItemGroupDefineS2CPayload payload) {
        if (InternalClientRegistry.enabled) {
            class_310.method_1551().execute(() -> {
                InternalClientRegistry.clearTabs(t -> t.getIdentifier().equals((Object)payload.groupId()));
                InternalClientRegistry.createItemGroup(payload.groupId(), payload.name(), payload.icon());
            });
        }
    }

    private static void handleItemGroupRemove(class_310 client, class_8673 handler, PolymerItemGroupRemoveS2CPayload payload) {
        if (InternalClientRegistry.enabled) {
            class_310.method_1551().execute(() -> InternalClientRegistry.clearTabs(x -> x.getIdentifier().equals((Object)payload.groupId())));
        }
    }

    private static void handleItemGroupContentsAdd(class_310 client, class_8673 handler, PolymerItemGroupContentAddS2CPayload payload) {
        if (InternalClientRegistry.enabled) {
            class_310.method_1551().execute(() -> {
                class_1761 group = InternalClientRegistry.getItemGroup(payload.groupId());
                if (group != null) {
                    ClientItemGroupExtension groupAccess = (ClientItemGroupExtension)group;
                    for (class_1799 stack : payload.stacksMain()) {
                        groupAccess.polymer$addStackGroup(stack);
                    }
                    for (class_1799 stack : payload.stacksSearch()) {
                        groupAccess.polymer$addStackSearch(stack);
                    }
                }
            });
        }
    }

    private static void handleItemGroupContentsClear(class_310 client, class_8673 handler, PolymerItemGroupContentClearS2CPayload payload) {
        if (InternalClientRegistry.enabled) {
            class_310.method_1551().execute(() -> {
                class_1761 group = InternalClientRegistry.getItemGroup(payload.groupId());
                if (group != null) {
                    ClientItemGroupExtension groupAccess = (ClientItemGroupExtension)group;
                    groupAccess.polymer$clearStacks();
                }
            });
        }
    }

    private static void handleEntity(class_310 client, class_634 handler, PolymerEntityS2CPayload payload) {
        if (InternalClientRegistry.enabled) {
            class_310.method_1551().execute(() -> {
                class_1297 entity = handler.method_2890().method_8469(payload.entityId());
                if (entity != null) {
                    ((ClientEntityExtension)entity).polymer$setId(payload.typeId());
                }
            });
        }
    }

    private static void handleSetBlock(class_310 client, class_634 handler, PolymerBlockUpdateS2CPayload payload) {
        if (InternalClientRegistry.enabled) {
            class_310.method_1551().execute(() -> {
                ClientPolymerBlock.State block = (ClientPolymerBlock.State)InternalClientRegistry.BLOCK_STATES.method_10200(payload.blockId());
                if (block != null) {
                    class_2338 pos = payload.pos();
                    class_2818 chunk = class_310.method_1551().field_1687.method_2935().method_2857(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()), class_2806.field_12803, false);
                    if (chunk != null) {
                        ((ClientBlockStorageInterface)chunk).polymer$setClientBlock(pos.method_10263(), pos.method_10264(), pos.method_10260(), block);
                        PolymerClientUtils.ON_BLOCK_UPDATE.invoke(c -> c.accept(pos, block));
                        if (block.blockState() != null && PolymerClientDecoded.checkDecode(block.blockState().method_26204())) {
                            chunk.method_12010(pos, block.blockState(), false);
                        }
                    }
                }
            });
        }
    }

    private static void handleWorldSectionUpdate(class_310 client, class_634 handler, PolymerSectionUpdateS2CPayload payload) {
        if (InternalClientRegistry.enabled) {
            class_4076 sectionPos = payload.chunkPos();
            class_310.method_1551().execute(() -> {
                class_2826 section;
                class_2818 chunk = class_310.method_1551().field_1687.method_2935().method_2857(sectionPos.method_10263(), sectionPos.method_10260(), class_2806.field_12803, false);
                short[] blockPos = payload.pos();
                int[] states = payload.blocks();
                if (chunk != null && (section = chunk.method_38259(chunk.method_31603(sectionPos.method_10264()))) instanceof ClientBlockStorageInterface) {
                    ClientBlockStorageInterface storage = (ClientBlockStorageInterface)section;
                    class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(0, 0, 0);
                    for (int i = 0; i < states.length; ++i) {
                        short pos = blockPos[i];
                        ClientPolymerBlock.State block = (ClientPolymerBlock.State)InternalClientRegistry.BLOCK_STATES.method_10200(states[i]);
                        if (block == null) continue;
                        int x = class_4076.method_30551((short)pos);
                        int y = class_4076.method_30552((short)pos);
                        int z = class_4076.method_30553((short)pos);
                        mutableBlockPos.method_10103(sectionPos.method_19527() + x, sectionPos.method_19527() + y, sectionPos.method_19527() + z);
                        PolymerClientUtils.ON_BLOCK_UPDATE.invoke(c -> c.accept(mutableBlockPos, block));
                        storage.polymer$setClientBlock(x, y, z, block);
                        if (block.blockState() == null || !PolymerClientDecoded.checkDecode(block.blockState().method_26204())) continue;
                        section.method_16675(x, y, z, block.blockState());
                    }
                }
            });
        }
    }

    private static <T> void handleGenericList(class_310 client, class_8673 handle, PolymerGenericListPayload<?> payload) {
        if (!InternalClientRegistry.enabled) {
            return;
        }
        Consumer<?> consumer = GENERIC_LIST_HANDLERS.get(payload.id().comp_2242());
        if (consumer != null) {
            try {
                for (Object entry : payload.entries()) {
                    consumer.accept(entry);
                }
            }
            catch (Throwable e) {
                NetImpl.LOGGER.error("Handing of packet '" + String.valueOf(payload.id()) + "' failed!", e);
            }
        }
    }

    static interface EntryReader<T> {
        @Nullable
        public T read(class_2540 var1, int var2);
    }
}

