/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.mixin.block;

import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2781;
import net.minecraft.class_2846;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_5134;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3225.class})
public abstract class ServerPlayerInteractionManagerMixin {
    @Shadow
    protected class_3222 field_14008;
    @Shadow
    protected class_3218 field_14007;
    @Shadow
    private int field_20326;
    @Unique
    private int polymer$sequence = 0;
    @Unique
    private float polymer$currentBreakingProgress;
    @Unique
    private int polymer$blockBreakingCooldown;
    @Unique
    private boolean polymer$hasMiningFatigue;

    @Shadow
    public abstract void method_21717(class_2338 var1, int var2, String var3);

    @Inject(method={"continueMining"}, at={@At(value="TAIL")})
    private void polymer_breakIfTakingTooLong(class_2680 state, class_2338 pos, int i, CallbackInfoReturnable<Float> cir) {
        if (this.polymer$shouldMineServerSide(pos, state)) {
            if (this.polymer$blockBreakingCooldown > 0) {
                --this.polymer$blockBreakingCooldown;
                return;
            }
            this.polymer$currentBreakingProgress += state.method_26165((class_1657)this.field_14008, (class_1922)this.field_14008.method_37908(), pos);
            if (this.polymer$currentBreakingProgress >= 1.0f) {
                this.polymer$blockBreakingCooldown = 5;
                this.polymer$currentBreakingProgress = 0.0f;
                this.field_14008.field_13987.method_14364((class_2596)new class_2620(-1, pos, -1));
                this.method_21717(pos, this.polymer$sequence, "destroyed");
                PolymerBlockUtils.BREAKING_PROGRESS_UPDATE.invoke(x -> x.onBreakingProgressUpdate(this.field_14008, pos, state, -1));
            } else {
                int k = this.polymer$currentBreakingProgress > 0.0f ? (int)(this.polymer$currentBreakingProgress * 10.0f) : -1;
                this.field_14008.field_13987.method_14364((class_2596)new class_2620(-1, pos, k));
                this.polymer$sendMiningFatigue();
                PolymerBlockUtils.BREAKING_PROGRESS_UPDATE.invoke(x -> x.onBreakingProgressUpdate(this.field_14008, pos, state, k));
            }
        } else if (this.polymer$hasMiningFatigue) {
            this.polymer$clearMiningEffect();
        }
    }

    @Inject(method={"processBlockBreakingAction"}, at={@At(value="HEAD")})
    private void polymer_packetReceivedInject(class_2338 pos, class_2846.class_2847 action, class_2350 direction, int worldHeight, int sequence, CallbackInfo ci) {
        this.polymer$sequence = sequence;
        class_2680 state = this.field_14008.method_37908().method_8320(pos);
        if (this.polymer$shouldMineServerSide(pos, state)) {
            if (action == class_2846.class_2847.field_12968) {
                float delta;
                this.polymer$currentBreakingProgress = 0.0f;
                float ogDelta = state.method_26165((class_1657)this.field_14008, (class_1922)this.field_14007, pos);
                class_2248 class_22482 = state.method_26204();
                if (class_22482 instanceof PolymerBlock) {
                    PolymerBlock virtualBlock = (PolymerBlock)class_22482;
                    state = PolymerBlockUtils.getBlockStateSafely(virtualBlock, state, this.field_14008);
                }
                if ((delta = state.method_26165((class_1657)this.field_14008, (class_1922)this.field_14007, pos)) >= 1.0f && ogDelta < 1.0f) {
                    this.field_14008.field_13987.method_14364((class_2596)new class_2626(pos, state));
                }
                if (ogDelta < 1.0f) {
                    this.polymer$sendMiningFatigue();
                }
            } else if (action == class_2846.class_2847.field_12971) {
                if (this.polymer$hasMiningFatigue) {
                    this.polymer$clearMiningEffect();
                }
                this.field_14008.field_13987.method_14364((class_2596)new class_2620(-1, pos, -1));
                class_2680 finalState = state;
                PolymerBlockUtils.BREAKING_PROGRESS_UPDATE.invoke(x -> x.onBreakingProgressUpdate(this.field_14008, pos, finalState, -1));
            }
        } else if (this.polymer$hasMiningFatigue) {
            this.polymer$clearMiningEffect();
        }
    }

    @Inject(method={"processBlockBreakingAction"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;setBlockBreakingInfo(ILnet/minecraft/util/math/BlockPos;I)V", ordinal=0)})
    private void polymer$clearBreakingTime(class_2338 pos, class_2846.class_2847 action, class_2350 direction, int worldHeight, int sequence, CallbackInfo ci) {
        this.polymer$currentBreakingProgress = 0.0f;
    }

    @Inject(method={"processBlockBreakingAction"}, at={@At(value="TAIL")})
    private void polymer$enforceBlockBreakingCooldown(class_2338 pos, class_2846.class_2847 action, class_2350 direction, int worldHeight, int sequence, CallbackInfo ci) {
        if (this.polymer$shouldMineServerSide(pos, this.field_14008.method_37908().method_8320(pos))) {
            if (action == class_2846.class_2847.field_12968) {
                this.field_20326 += this.polymer$blockBreakingCooldown;
            }
        } else if (this.polymer$hasMiningFatigue) {
            this.polymer$clearMiningEffect();
        }
    }

    @Inject(method={"finishMining"}, at={@At(value="HEAD")})
    private void polymer$clearEffects(class_2338 pos, int sequence, String reason, CallbackInfo ci) {
        this.polymer$clearMiningEffect();
    }

    @Unique
    private boolean polymer$shouldMineServerSide(class_2338 pos, class_2680 state) {
        return PolymerBlockUtils.shouldMineServerSide(this.field_14008, pos, state);
    }

    @Unique
    private void polymer$sendMiningFatigue() {
        this.polymer$hasMiningFatigue = true;
        class_1324 x = new class_1324(class_5134.field_49076, a -> {});
        x.method_6192(-9999.0);
        this.field_14008.field_13987.method_14364((class_2596)new class_2781(this.field_14008.method_5628(), List.of(x)));
    }

    @Unique
    private void polymer$clearMiningEffect() {
        this.polymer$hasMiningFatigue = false;
        class_1324 x = new class_1324(class_5134.field_49076, a -> {});
        x.method_6192(-9999.0);
        this.field_14008.field_13987.method_14364((class_2596)new class_2781(this.field_14008.method_5628(), List.of(Objects.requireNonNull(this.field_14008.method_5996(class_5134.field_49076)))));
    }

    @Redirect(method={"processBlockBreakingAction"}, at=@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V"), require=0)
    private void polymer$noOneCaresAboutMismatch(Logger instance, String s, Object o, Object o2) {
    }
}

