package eu.pb4.polymer.networking.impl;

import com.mojang.authlib.GameProfile;
import eu.pb4.polymer.networking.api.server.EarlyConfigurationNetworkHandler;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2596;
import net.minecraft.class_3248;
import net.minecraft.class_8791;
import net.minecraft.class_9157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

@ApiStatus.Internal
public class EarlyConfigurationConnectionMagic {
    private static final List<Function<EarlyConfigurationNetworkHandler.Context, EarlyConfigurationNetworkHandler>> CONSTRUCTORS = new ArrayList<>();

    public static void handle(GameProfile profile, class_8791 options, class_3248 loginHandler, MinecraftServer server, class_2535 connection, Consumer<ContextImpl> finish) {
        var iterator = new ArrayList<>(CONSTRUCTORS).iterator();

        var ctx = new ContextImpl(server, profile, connection, loginHandler, new ArrayList<>(), (c) -> {
            while (iterator.hasNext()) {
                var handler = iterator.next().apply(c);
                if (handler != null) {
                    return;
                }
            }
            finish.accept(c);
        }, new AtomicReference<>(options));


        connection.method_56330(class_9157.field_48698,
                new FallbackServerPacketHandler(class_2539.field_45671, ctx.options()::set, ctx.storedPackets()::add, loginHandler::method_10839));

        ctx.continueRunning().accept(ctx);
    }

    public static void register(Function<EarlyConfigurationNetworkHandler.Context, @Nullable EarlyConfigurationNetworkHandler> constructor) {
        CONSTRUCTORS.add(constructor);
    }

    static {
        register(PolymerHandshakeHandlerImplLogin::create);
    }

    public record ContextImpl(
            MinecraftServer server,
            GameProfile profile,
            class_2535 connection,
            class_3248 loginHandler,
            List<class_2596<?>> storedPackets,
            Consumer<ContextImpl> continueRunning,
            AtomicReference<class_8791> options
    ) implements EarlyConfigurationNetworkHandler.Context {
    }
}
