package eu.pb4.polymer.networking.impl;

import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.networking.api.PolymerNetworking;
import eu.pb4.polymer.networking.api.server.PolymerHandshakeHandler;
import eu.pb4.polymer.networking.api.server.PolymerServerNetworking;
import eu.pb4.polymer.networking.api.server.PolymerServerPacketHandler;
import eu.pb4.polymer.networking.impl.packets.DisableS2CPayload;
import eu.pb4.polymer.networking.impl.packets.HandshakePayload;
import eu.pb4.polymer.networking.impl.packets.HelloS2CPayload;
import eu.pb4.polymer.networking.impl.packets.MetadataPayload;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.class_2520;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_8609;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

import java.util.HashMap;
import java.util.List;

@ApiStatus.Internal
public class ServerPacketRegistry {
    public static final HashMap<Class<?>, List<PolymerServerPacketHandler<class_8609, ?>>> COMMON_PACKET_LISTENERS = new HashMap<>();
    public static final HashMap<Class<?>, List<PolymerServerPacketHandler<class_3244, ?>>> PLAY_PACKET_LISTENERS = new HashMap<>();
    public static final HashMap<Class<?>, List<PolymerServerPacketHandler<class_8610, ?>>> CONFIG_PACKET_LISTENERS = new HashMap<>();

    public static final HashMap<class_2960, class_2520> METADATA = new HashMap<>();
    public static void register() {
        PolymerNetworking.registerCommonVersioned(HandshakePayload.ID, 2, HandshakePayload.CODEC);
        PolymerNetworking.registerCommonVersioned(MetadataPayload.ID, 2, MetadataPayload.CODEC);
        PolymerNetworking.registerS2CVersioned(DisableS2CPayload.ID, 2, class_9139.method_56431(new DisableS2CPayload()));
        PolymerNetworking.registerS2CVersioned(HelloS2CPayload.ID, 2, class_9139.method_56431(new HelloS2CPayload()));

        PolymerServerNetworking.registerCommonHandler(HandshakePayload.class,
                (server, handler, packet) -> handleHandshake(PolymerHandshakeHandler.of(server, handler), packet));
        PolymerServerNetworking.registerCommonHandler(MetadataPayload.class,
                (server, handler, packet) -> handleMetadata(PolymerHandshakeHandler.of(server, handler), packet));
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    public static boolean handle(MinecraftServer server, class_8609 handler, class_8710 packet) {
        var packetHandlers = COMMON_PACKET_LISTENERS.get(packet.getClass());
        boolean handled = false;
        if (packetHandlers != null) {
            for (var pHandler : packetHandlers) {
                ((PolymerServerPacketHandler) pHandler).onPacket(server, handler, packet);
            }
            handled = !packetHandlers.isEmpty();
        }

        if (handler instanceof class_3244 playNetworkHandler) {
            var packetHandlers2 = PLAY_PACKET_LISTENERS.get(packet.getClass());
            if (packetHandlers2 != null) {
                for (var pHandler : packetHandlers2) {
                    ((PolymerServerPacketHandler) pHandler).onPacket(server, playNetworkHandler, packet);
                }
                handled = handled || !packetHandlers2.isEmpty();
            }
        } else if (handler instanceof class_8610 networkHandler) {
            var packetHandlers2 = CONFIG_PACKET_LISTENERS.get(packet.getClass());
            if (packetHandlers2 != null) {
                for (var pHandler : packetHandlers2) {
                    ((PolymerServerPacketHandler) pHandler).onPacket(server, networkHandler, packet);
                }
                handled = handled || !packetHandlers2.isEmpty();
            }
        }

        return handled;
    }
    public static void sendHandshake(PolymerHandshakeHandler handler) {
        handler.sendPacket(new class_2658(new HandshakePayload(CommonImpl.VERSION, ClientPackets.VERSION_REGISTRY)));
    }

    private static void sendMetadata(PolymerHandshakeHandler handler) {
        handler.sendPacket(new class_2658(new MetadataPayload(METADATA)));
    }

    public static void handleHandshake(PolymerHandshakeHandler handler, HandshakePayload payload) {
        var versionMap = new Object2IntOpenHashMap<class_2960>();

        payload.packetVersions().forEach((id, versions) -> {
            versionMap.put(id, ServerPackets.getBestSupported(id, versions));
        });

        handler.getServer().execute(() -> {
            handler.set(handler.getPolymerVersion(), versionMap);
            handler.setLastPacketTime(HandshakePayload.ID.comp_2242());

            sendHandshake(handler);
            sendMetadata(handler);
        });
    }

    public static void handleMetadata(PolymerHandshakeHandler handler, MetadataPayload payload) {
        payload.map().forEach(handler::setMetadataValue);
    }
}
