package eu.pb4.polymer.networking.impl;

import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.impl.CommonConnectionExt;
import eu.pb4.polymer.networking.api.server.EarlyConfigurationNetworkHandler;
import eu.pb4.polymer.networking.api.server.PolymerHandshakeHandler;
import eu.pb4.polymer.networking.impl.packets.HandshakePayload;
import eu.pb4.polymer.networking.impl.packets.HelloS2CPayload;
import eu.pb4.polymer.networking.impl.packets.MetadataPayload;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_2520;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_6374;

@ApiStatus.Internal
public final class PolymerHandshakeHandlerImplLogin extends EarlyConfigurationNetworkHandler implements PolymerHandshakeHandler {
    public static int PING_ID = 0x91776;

    private int pings = 0;
    private final Object2LongMap<class_2960> lastUpdate = new Object2LongOpenHashMap<>();
    private final ExtConnection extClientConnection;

    private PolymerHandshakeHandlerImplLogin(Context context) {
        super(class_2960.method_60655("polymer", "early_handshake"), context);
        this.sendPacket(new HelloS2CPayload());
        this.sendPing(PING_ID);
        this.extClientConnection = ExtConnection.of(this.getConnection());
    }

    @Nullable
    public static EarlyConfigurationNetworkHandler create(Context context) {
        if (PolymerCommonUtils.isBedrockPlayer(context.profile())) {
            return null;
        }
        return new PolymerHandshakeHandlerImplLogin(context);
    }

    public void set(String polymerVersion, Object2IntMap<class_2960> protocolVersions) {
        this.extClientConnection.polymerNet$setVersion(polymerVersion);
        for (var entry : protocolVersions.object2IntEntrySet()) {
            this.extClientConnection.polymerNet$setSupportedVersion(entry.getKey(), entry.getIntValue());
        }
    }

    @Override
    public void setMetadataValue(class_2960 identifier, class_2520 value) {
        this.extClientConnection.polymerNet$getMetadataMap().put(identifier, value);
    }

    public boolean isPolymer() {
        return this.extClientConnection.polymerNet$hasPolymer();
    }

    public String getPolymerVersion() {
        return this.extClientConnection.polymerNet$version();
    }

    public int getSupportedProtocol(class_2960 identifier) {
        return this.extClientConnection.polymerNet$getSupportedVersion(identifier);
    }

    @Override
    public void setLastPacketTime(class_2960 identifier) {
        this.lastUpdate.put(identifier, System.currentTimeMillis());
    }

    @Override
    public long getLastPacketTime(class_2960 identifier) {
        return this.lastUpdate.getLong(identifier);
    }

    @Override
    public @Nullable class_3222 getPlayer() {
        return null;
    }

    @Override
    public void apply(class_3244 handler) {
        var polymerHandler = PacketListenerImplExtension.of(handler);

        for (var entry : this.lastUpdate.keySet()) {
            polymerHandler.polymerNet$savePacketTime(entry);
        }
    }

    @Override
    public boolean getPackStatus(UUID uuid) {
        return ((CommonConnectionExt) this.getConnection()).polymerCommon$hasResourcePack(uuid);
    }

    @Override
    public void reset() {
        this.extClientConnection.polymerNet$getSupportMap().clear();
    }

    @Override
    public void setPackStatus(UUID uuid, boolean status) {
        ((CommonConnectionExt) this.getConnection()).polymerCommon$setResourcePack(uuid, status);
    }

    @Override
    public boolean tryHandleCustomPayload(class_2817 packet) {
        if (packet.comp_1647() instanceof HandshakePayload handshakePayload) {
            try {
                ServerPacketRegistry.handleHandshake(this, handshakePayload);
            } catch (Throwable e) {
                NetImpl.LOGGER.error("Packet Handling failed!", e);
            }
            return true;
        }  if (packet.comp_1647() instanceof MetadataPayload payload) {
            try {
                ServerPacketRegistry.handleMetadata(this, payload);
            } catch (Throwable e) {
                NetImpl.LOGGER.error("Packet Handling failed!", e);
            }
            return true;
        } else {
            return false;
        }
    }
    @Override
    public void method_52394(class_6374 packet) {
        if (packet.method_36960() == PING_ID) {
            switch (this.pings++) {
                case 0 -> this.sendPing(PING_ID);
                case 1 -> this.continueJoining();
            }
        }
    }
}