/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.networking.api.server;

import com.mojang.authlib.GameProfile;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.networking.impl.EarlyConfigurationConnectionMagic;
import eu.pb4.polymer.networking.mixin.ClientConnectionAccessor;
import java.util.function.Function;
import net.minecraft.class_11411;
import net.minecraft.class_11752;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2661;
import net.minecraft.class_2670;
import net.minecraft.class_2803;
import net.minecraft.class_2817;
import net.minecraft.class_2827;
import net.minecraft.class_2856;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_6373;
import net.minecraft.class_6374;
import net.minecraft.class_7633;
import net.minecraft.class_8710;
import net.minecraft.class_8735;
import net.minecraft.class_8736;
import net.minecraft.class_8791;
import net.minecraft.class_9091;
import net.minecraft.class_9220;
import net.minecraft.class_9812;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.ContextProvidingPacketListener;

public class EarlyConfigurationNetworkHandler
implements class_8735,
class_7633,
ContextProvidingPacketListener {
    private final EarlyConfigurationConnectionMagic.ContextImpl context;
    private final class_2960 identifier;
    private volatile long lastResponse = 0L;
    private volatile int keepAliveSent = 0;
    private volatile int keepAliveReceived = 0;
    private volatile int pingsId = 1024;
    private volatile boolean canContinue = true;
    private volatile boolean alreadyContinued;

    public static void register(Function<Context, EarlyConfigurationNetworkHandler> constructor) {
        EarlyConfigurationConnectionMagic.register(constructor);
    }

    public EarlyConfigurationNetworkHandler(class_2960 identifier, Context context) {
        this.context = (EarlyConfigurationConnectionMagic.ContextImpl)context;
        this.identifier = identifier;
        ((ClientConnectionAccessor)this.context.connection()).setPacketListener((class_2547)this);
        this.sendKeepAlive();
    }

    public final class_2960 getId() {
        return this.identifier;
    }

    public void handleDisconnect(class_9812 reason) {
    }

    public void handleKeepAlive(long time) {
    }

    public boolean handleCustomPayload(class_2817 packet) {
        return false;
    }

    public final void method_18784() {
        if (this.lastResponse == 1200L) {
            this.disconnect((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.slow_login"));
        } else if (this.lastResponse == 20L) {
            this.sendKeepAlive();
        }
        ++this.lastResponse;
        this.onTick();
    }

    protected void onTick() {
    }

    public final void method_52393(class_2827 packet) {
        this.lastResponse = -20L;
        ++this.keepAliveReceived;
        if (this.canContinue) {
            this.handleKeepAlive(packet.method_12267());
        } else if (!this.alreadyContinued && this.keepAliveReceived >= this.keepAliveSent) {
            this.alreadyContinued = true;
            this.context.server().execute(() -> this.context.continueRunning().accept(this.context));
        }
    }

    public void method_52394(class_6374 packet) {
    }

    public final void sendPacket(class_2596<?> packet) {
        this.context.connection().method_10743(packet);
    }

    protected void sendPacket(class_8710 payload) {
        this.sendPacket((class_2596<?>)new class_2658(payload));
    }

    public final void sendKeepAlive(long value) {
        ++this.keepAliveSent;
        this.sendPacket((class_2596<?>)new class_2670(value));
    }

    public final void sendKeepAlive() {
        this.sendKeepAlive(System.currentTimeMillis());
    }

    public final void sendPing(int id) {
        this.sendPacket((class_2596<?>)new class_6373(id));
    }

    public final int sendPing() {
        int id = this.pingsId++;
        this.sendPing(id);
        return id;
    }

    public final void method_52392(class_2817 packet) {
        if (!this.handleCustomPayload(packet)) {
            this.context.storedPackets().add((class_2596<?>)packet);
        }
    }

    public void method_52395(class_2856 packet) {
    }

    public void method_12069(class_2803 packet) {
        this.context.options().set(packet.comp_1963());
    }

    public void method_71953(class_11411 customClickActionC2SPacket) {
    }

    public void method_10839(class_9812 info) {
        this.context.storedPackets().clear();
        this.handleDisconnect(info);
    }

    public final class_2535 getConnection() {
        return this.context.connection();
    }

    public final void disconnect(class_2561 reason) {
        try {
            CommonImpl.LOGGER.info("Disconnecting {} on {}: {}", new Object[]{this.getConnectionInfo(), this.getId(), reason.getString()});
            this.sendPacket((class_2596<?>)new class_2661(reason));
            this.context.connection().method_10747(reason);
            this.context.storedPackets().clear();
        }
        catch (Exception var3) {
            CommonImpl.LOGGER.error("Error whilst disconnecting player", (Throwable)var3);
        }
    }

    public final MinecraftServer getServer() {
        return this.context.server();
    }

    public final void continueJoining() {
        if (this.canContinue) {
            this.canContinue = false;
            this.sendKeepAlive();
        }
    }

    public final String getConnectionInfo() {
        if (this.getGameProfile() != null) {
            GameProfile var10000 = this.getGameProfile();
            return String.valueOf(var10000) + " (" + String.valueOf(this.context.connection().method_10755()) + ")";
        }
        return String.valueOf(this.context.connection().method_10755());
    }

    public boolean method_48106() {
        return this.getConnection().method_10758();
    }

    public void method_52408(class_8736 packet) {
    }

    public void method_56909(class_9220 packet) {
    }

    public void method_73259(class_11752 packet) {
    }

    public void method_55851(class_9091 packet) {
    }

    @Nullable
    public final class_3222 getPlayerForPacketTweaker() {
        return null;
    }

    public final GameProfile getGameProfile() {
        return this.context.profile();
    }

    public GameProfile getGameProfileForPacketTweaker() {
        return this.context.profile();
    }

    public class_8791 getClientOptionsForPacketTweaker() {
        return this.context.options().get();
    }

    protected final class_3248 getLoginNetworkHandler() {
        return this.context.loginHandler();
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        public MinecraftServer server();

        public GameProfile profile();
    }
}

