package eu.pb4.polymer.networking.api.server;

import eu.pb4.polymer.networking.impl.PolymerHandshakeHandlerImplLate;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8609;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;

@ApiStatus.NonExtendable
public interface PolymerHandshakeHandler {
    void sendPacket(class_2596<?> packet);
    void set(String polymerVersion, Object2IntMap<class_2960> protocolVersions);
    void setMetadataValue(class_2960 identifier, class_2520 value);

    boolean isPolymer();

    String getPolymerVersion();

    int getSupportedProtocol(class_2960 identifier);

    void setLastPacketTime(class_2960 identifier);

    long getLastPacketTime(class_2960 identifier);

    MinecraftServer getServer();

    @Nullable
    class_3222 getPlayer();

    static PolymerHandshakeHandler of(MinecraftServer server, class_8609 handler) {
        return PolymerHandshakeHandlerImplLate.of(server, handler);
    }

    void apply(class_3244 handler);

    boolean getPackStatus(UUID uuid);

    void reset();

    void setPackStatus(UUID uuid, boolean status);
}