/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.networking.impl;

import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.networking.api.PolymerNetworking;
import eu.pb4.polymer.networking.api.server.PolymerHandshakeHandler;
import eu.pb4.polymer.networking.api.server.PolymerServerNetworking;
import eu.pb4.polymer.networking.api.server.PolymerServerPacketHandler;
import eu.pb4.polymer.networking.impl.ClientPackets;
import eu.pb4.polymer.networking.impl.ServerPackets;
import eu.pb4.polymer.networking.impl.packets.DisableS2CPayload;
import eu.pb4.polymer.networking.impl.packets.HandshakePayload;
import eu.pb4.polymer.networking.impl.packets.HelloS2CPayload;
import eu.pb4.polymer.networking.impl.packets.MetadataPayload;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_8609;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ServerPacketRegistry {
    public static final HashMap<Class<?>, List<PolymerServerPacketHandler<class_8609, ?>>> COMMON_PACKET_LISTENERS = new HashMap();
    public static final HashMap<Class<?>, List<PolymerServerPacketHandler<class_3244, ?>>> PLAY_PACKET_LISTENERS = new HashMap();
    public static final HashMap<Class<?>, List<PolymerServerPacketHandler<class_8610, ?>>> CONFIG_PACKET_LISTENERS = new HashMap();
    public static final HashMap<class_2960, class_2520> METADATA = new HashMap();

    public static void register() {
        PolymerNetworking.registerCommonVersioned(HandshakePayload.ID, 2, HandshakePayload.CODEC);
        PolymerNetworking.registerCommonVersioned(MetadataPayload.ID, 2, MetadataPayload.CODEC);
        PolymerNetworking.registerS2CVersioned(DisableS2CPayload.ID, 2, class_9139.method_56431((Object)new DisableS2CPayload()));
        PolymerNetworking.registerS2CVersioned(HelloS2CPayload.ID, 2, class_9139.method_56431((Object)new HelloS2CPayload()));
        PolymerServerNetworking.registerCommonHandler(HandshakePayload.class, (server, handler, packet) -> ServerPacketRegistry.handleHandshake(PolymerHandshakeHandler.of(server, handler), packet));
        PolymerServerNetworking.registerCommonHandler(MetadataPayload.class, (server, handler, packet) -> ServerPacketRegistry.handleMetadata(PolymerHandshakeHandler.of(server, handler), packet));
    }

    public static boolean handle(MinecraftServer server, class_8609 handler, class_8710 packet) {
        List<PolymerServerPacketHandler<class_8609, ?>> packetHandlers = COMMON_PACKET_LISTENERS.get(packet.getClass());
        boolean handled = false;
        if (packetHandlers != null) {
            for (PolymerServerPacketHandler<class_8609, ?> pHandler : packetHandlers) {
                pHandler.onPacket(server, handler, packet);
            }
            boolean bl = handled = !packetHandlers.isEmpty();
        }
        if (handler instanceof class_3244) {
            class_3244 playNetworkHandler = (class_3244)handler;
            List<PolymerServerPacketHandler<class_3244, ?>> packetHandlers2 = PLAY_PACKET_LISTENERS.get(packet.getClass());
            if (packetHandlers2 != null) {
                for (PolymerServerPacketHandler<class_3244, ?> pHandler : packetHandlers2) {
                    pHandler.onPacket(server, playNetworkHandler, packet);
                }
                handled = handled || !packetHandlers2.isEmpty();
            }
        } else if (handler instanceof class_8610) {
            class_8610 networkHandler = (class_8610)handler;
            List<PolymerServerPacketHandler<class_8610, ?>> packetHandlers2 = CONFIG_PACKET_LISTENERS.get(packet.getClass());
            if (packetHandlers2 != null) {
                for (PolymerServerPacketHandler<class_8610, ?> pHandler : packetHandlers2) {
                    pHandler.onPacket(server, networkHandler, packet);
                }
                handled = handled || !packetHandlers2.isEmpty();
            }
        }
        return handled;
    }

    public static void sendHandshake(PolymerHandshakeHandler handler) {
        handler.sendPacket((class_2596<?>)new class_2658((class_8710)new HandshakePayload(CommonImpl.VERSION, ClientPackets.VERSION_REGISTRY)));
    }

    private static void sendMetadata(PolymerHandshakeHandler handler) {
        handler.sendPacket((class_2596<?>)new class_2658((class_8710)new MetadataPayload(METADATA)));
    }

    public static void handleHandshake(PolymerHandshakeHandler handler, HandshakePayload payload) {
        Object2IntOpenHashMap versionMap = new Object2IntOpenHashMap();
        payload.packetVersions().forEach((id, versions) -> versionMap.put(id, ServerPackets.getBestSupported(id, versions)));
        handler.getServer().execute(() -> {
            handler.set(handler.getPolymerVersion(), (Object2IntMap<class_2960>)versionMap);
            handler.setLastPacketTime(HandshakePayload.ID.comp_2242());
            ServerPacketRegistry.sendHandshake(handler);
            ServerPacketRegistry.sendMetadata(handler);
        });
    }

    public static void handleMetadata(PolymerHandshakeHandler handler, MetadataPayload payload) {
        payload.map().forEach(handler::setMetadataValue);
    }
}

