package eu.pb4.polymer.networking.impl;

import eu.pb4.polymer.common.impl.CommonClientConnectionExt;
import eu.pb4.polymer.networking.api.server.PolymerHandshakeHandler;
import eu.pb4.polymer.networking.api.server.PolymerServerNetworking;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5629;
import net.minecraft.class_8609;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.*;
import org.jetbrains.annotations.ApiStatus;

import java.util.UUID;

@ApiStatus.Internal
public class PolymerHandshakeHandlerImplLate implements PolymerHandshakeHandler {
    private final MinecraftServer server;
    private final class_8609 handler;
    private final NetworkHandlerExtension polymerHandler;
    private final ExtClientConnection extClientConnection;

    public PolymerHandshakeHandlerImplLate(MinecraftServer server, class_8609 handler) {
        this.server = server;
        this.handler = handler;
        this.polymerHandler = NetworkHandlerExtension.of(handler);
        this.extClientConnection = ExtClientConnection.of(handler);

        //PolymerSyncUtils.PREPARE_HANDSHAKE.invoke((c -> c.accept(this)));
    }

    public void sendPacket(class_2596<?> packet) {
        this.handler.method_14364(packet);
    }

    public void set(String polymerVersion, Object2IntMap<class_2960> protocolVersions) {
        this.extClientConnection.polymerNet$setVersion(polymerVersion);
        for (var entry : protocolVersions.object2IntEntrySet()) {
            this.extClientConnection.polymerNet$setSupportedVersion(entry.getKey(), entry.getIntValue());
        }
    }

    @Override
    public void setMetadataValue(class_2960 identifier, class_2520 value) {
        this.extClientConnection.polymerNet$getMetadataMap().put(identifier, value);
    }

    public boolean isPolymer() {
        return this.extClientConnection.polymerNet$hasPolymer();
    }

    public String getPolymerVersion() {
        return this.extClientConnection.polymerNet$version();
    }

    public int getSupportedProtocol(class_2960 identifier) {
        return this.extClientConnection.polymerNet$getSupportedVersion(identifier);
    }

    @Override
    public void setLastPacketTime(class_2960 identifier) {
        this.polymerHandler.polymerNet$savePacketTime(identifier);
    }

    @Override
    public long getLastPacketTime(class_2960 identifier) {
        return this.polymerHandler.polymerNet$lastPacketUpdate(identifier);

    }

    public MinecraftServer getServer() {
        return server;
    }

    public class_3222 getPlayer() {
        if (this.handler instanceof class_5629 playerAssociatedNetworkHandler) {
            return playerAssociatedNetworkHandler.method_32311();
        }
        return null;
    }

    public static PolymerHandshakeHandler of(MinecraftServer server, class_8609 handler) {
        return new PolymerHandshakeHandlerImplLate(server, handler);
    }

    @Override
    public void apply(class_3244 handler) {
        // No need to apply, as it applies by default!
        PolymerServerNetworking.ON_PLAY_SYNC.invoke(x -> x.accept(handler, this));
    }

    @Override
    public boolean getPackStatus(UUID uuid) {
        return ((CommonClientConnectionExt) this.polymerHandler).polymerCommon$hasResourcePack(uuid);
    }

    @Override
    public void reset() {
        this.extClientConnection.polymerNet$getSupportMap().clear();
    }

    @Override
    public void setPackStatus(UUID uuid, boolean status) {
        ((CommonClientConnectionExt) this.polymerHandler).polymerCommon$setResourcePack(uuid, status);
    }
}