package eu.pb4.polymer.networking.mixin;

import eu.pb4.polymer.networking.impl.ExtCustomPayloadCodec;
import io.netty.buffer.ByteBuf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

@Mixin(targets = "net/minecraft/network/packet/CustomPayload$1")
public class CustomPayloadCodecMixin implements ExtCustomPayloadCodec {
    @Unique
    private Map<class_2960, class_9139<ByteBuf, ?>> codecs = Map.of();
    @Inject(method = "getCodec", at = @At("HEAD"), cancellable = true)
    private void supportCustomPayloads(class_2960 id, CallbackInfoReturnable<class_9139<class_2540, ?>> cir) {
        var x = codecs.get(id);
        if (x != null) {
            cir.setReturnValue(x.method_56430());
        }
    }

    @Override
    public void polymer$setCodecMap(Map<class_2960, class_9139<ByteBuf, ?>> codecs) {
        this.codecs = codecs;
    }
}
