package eu.pb4.polymer.networking.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import eu.pb4.polymer.networking.impl.*;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3248;
import net.minecraft.class_8593;
import net.minecraft.class_8735;
import net.minecraft.class_8791;
import net.minecraft.class_8792;
import net.minecraft.class_9127;
import net.minecraft.class_9157;
import net.minecraft.class_9812;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.concurrent.atomic.AtomicReference;

@Mixin(class_3248.class)
public abstract class ServerLoginNetworkHandlerMixin implements NetworkHandlerExtension {
    @Shadow @Final
    class_2535 connection;

    @Shadow @Nullable private GameProfile profile;

    @Shadow public abstract void onEnterConfiguration(class_8593 packet);

    @Shadow @Final
    MinecraftServer server;

    @Shadow public abstract void onDisconnected(class_9812 info);

    @Unique
    private boolean polymerNet$ignoreCall = false;

    @Nullable
    @Unique
    private AtomicReference<class_8791> polymerNet$overrideOptions;

    @Override
    public long polymerNet$lastPacketUpdate(class_2960 packet) {
        return 0;
    }

    @Override
    public void polymerNet$savePacketTime(class_2960 packet) {
    }

    @Override
    public class_2535 polymerNet$getConnection() {
        return this.connection;
    }

    @WrapWithCondition(method = "onEnterConfiguration", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/ClientConnection;transitionOutbound(Lnet/minecraft/network/state/NetworkState;)V"))
    private boolean dontDuplicateCalls(class_2535 instance, class_9127<?> newState) {
        return NetImpl.IS_DISABLED;
    }

    @WrapOperation(method = "onEnterConfiguration", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/ClientConnection;transitionInbound(Lnet/minecraft/network/state/NetworkState;Lnet/minecraft/network/listener/PacketListener;)V"))
    private void dontDuplicateCalls2(class_2535 instance, class_9127<class_2547> state, class_2547 packetListener, Operation<Void> original) {
        if (NetImpl.IS_DISABLED) {
            original.call(instance, state, packetListener);
        } else {
            ((ClientConnectionAccessor) instance).setPacketListener(packetListener);
        }
    }

    @Inject(method = "onEnterConfiguration", at = @At("HEAD"), cancellable = true)
    private void polymerNet$prePlayHandshakeHackfest(class_8593 packet, CallbackInfo ci) {
        if (this.polymerNet$ignoreCall || NetImpl.IS_DISABLED) {
            return;
        }
        ci.cancel();
        this.connection.method_56329(class_9157.field_48699);
        var defaultOptions = class_8791.method_53821();
        EarlyConfigurationConnectionMagic.handle(this.profile, defaultOptions, (class_3248) (Object) this, this.server, connection, (context) -> {
            ((ExtClientConnection) connection).polymerNet$wrongPacketConsumer(context.storedPackets()::add);

            if (connection.method_10758()) {
                this.polymerNet$ignoreCall = true;
                if (context.options().get() != defaultOptions) {
                    this.polymerNet$overrideOptions = context.options();
                }
                this.onEnterConfiguration(packet);
                ((ExtClientConnection) connection).polymerNet$wrongPacketConsumer(null);
                //this.connection.enableAutoRead();
                if (this.connection.method_10744() instanceof class_8735 listener) {
                    for (var packetx : context.storedPackets()) {
                        try {
                            //noinspection unchecked
                            ((class_2596<class_8735>) packetx).method_65081(listener);
                        } catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    @ModifyArg(method = "onEnterConfiguration", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerConfigurationNetworkHandler;<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/network/ClientConnection;Lnet/minecraft/server/network/ConnectedClientData;)V"))
    private class_8792 polymerNet$swapClientData(class_8792 clientData) {
        if (this.polymerNet$overrideOptions != null) {
            return new class_8792(clientData.comp_1959(), clientData.comp_1960(), this.polymerNet$overrideOptions.get(), clientData.comp_2202());
        }
        return clientData;
    }
}
