package eu.pb4.polymer.networking.api.server;

import com.mojang.authlib.GameProfile;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.networking.impl.EarlyConfigurationConnectionMagic;
import eu.pb4.polymer.networking.mixin.ConnectionAccessor;
import net.minecraft.class_11411;
import net.minecraft.class_11752;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2661;
import net.minecraft.class_2670;
import net.minecraft.class_2803;
import net.minecraft.class_2817;
import net.minecraft.class_2827;
import net.minecraft.class_2856;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_6373;
import net.minecraft.class_6374;
import net.minecraft.class_7633;
import net.minecraft.class_8710;
import net.minecraft.class_8735;
import net.minecraft.class_8736;
import net.minecraft.class_8791;
import net.minecraft.class_9091;
import net.minecraft.class_9220;
import net.minecraft.class_9812;
import net.minecraft.network.protocol.common.*;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.ContextProvidingPacketListener;

import java.util.function.Function;

/**
 * This api exposes Polymer's early play packets utilities.
 * <p>
 * Use carefully, as client might not be initialized, or it might have leftover state from previous EarlyPlay handlers
 * Use this only if you know what you are doing and you need to do sync/packets before player joins a world.
 */

public class EarlyConfigurationNetworkHandler implements class_8735, class_7633, ContextProvidingPacketListener {

    private final EarlyConfigurationConnectionMagic.ContextImpl context;
    private final class_2960 identifier;
    private volatile long lastResponse = 0;
    private volatile int keepAliveSent = 0;
    private volatile int keepAliveReceived = 0;
    private volatile int pingsId = 1024;
    private volatile boolean canContinue = true;
    private volatile boolean alreadyContinued;
    public EarlyConfigurationNetworkHandler(class_2960 identifier, Context context) {
        this.context = (EarlyConfigurationConnectionMagic.ContextImpl) context;
        this.identifier = identifier;

        ((ConnectionAccessor) this.context.connection()).setPacketListener(this);
        this.sendKeepAlive();
    }

    public static void register(Function<Context, EarlyConfigurationNetworkHandler> constructor) {
        EarlyConfigurationConnectionMagic.register(constructor);
    }

    public final class_2960 getId() {
        return this.identifier;
    }

    public void handleDisconnect(class_9812 reason) {

    }

    public void handleKeepAlive(long time) {

    }

    public boolean tryHandleCustomPayload(class_2817 packet) {
        return false;
    }


    @Override
    public final void method_18784() {
        if (this.lastResponse == 1200) {
            this.disconnect(class_2561.method_43471("multiplayer.disconnect.slow_login"));
        } else if (this.lastResponse == 20) {
            this.sendKeepAlive();
        }
        this.lastResponse++;
        this.onTick();
    }

    protected void onTick() {
    }

    @Override
    public final void method_52393(class_2827 packet) {
        this.lastResponse = -20;
        this.keepAliveReceived++;
        if (this.canContinue) {
            this.handleKeepAlive(packet.method_12267());
        } else if (!this.alreadyContinued && this.keepAliveReceived >= this.keepAliveSent) {
            this.alreadyContinued = true;
            this.context.server().execute(() -> this.context.continueRunning().accept(this.context));
        }
    }

    @Override
    public void method_52394(class_6374 packet) {

    }

    public final void sendPacket(class_2596<?> packet) {
        this.context.connection().method_10743(packet);
    }

    protected void sendPacket(class_8710 payload) {
        this.sendPacket(new class_2658(payload));
    }

    public final void sendKeepAlive(long value) {
        this.keepAliveSent++;
        this.sendPacket(new class_2670(value));
    }

    public final void sendKeepAlive() {
        this.sendKeepAlive(System.currentTimeMillis());
    }

    public final void sendPing(int id) {
        this.sendPacket(new class_6373(id));
    }

    public final int sendPing() {
        var id = this.pingsId++;
        this.sendPing(id);
        return id;
    }

    @Override
    public final void method_52392(class_2817 packet) {
        if (!tryHandleCustomPayload(packet)) {
            this.context.storedPackets().add(packet);
        }
    }

    @Override
    public void method_52395(class_2856 packet) {

    }

    @Override
    public void method_12069(class_2803 packet) {
        this.context.options().set(packet.comp_1963());
    }

    @Override
    public void method_71953(class_11411 customClickActionC2SPacket) {

    }

    @Override
    public void method_10839(class_9812 info) {
        this.context.storedPackets().clear();
        this.handleDisconnect(info);
    }

    public final class_2535 getConnection() {
        return this.context.connection();
    }

    public final void disconnect(class_2561 reason) {
        try {
            CommonImpl.LOGGER.info("Disconnecting {} on {}: {}", this.getConnectionInfo(), this.getId(), reason.getString());
            this.sendPacket(new class_2661(reason));
            this.context.connection().method_10747(reason);
            this.context.storedPackets().clear();
        } catch (Exception var3) {
            CommonImpl.LOGGER.error("Error whilst disconnecting player", var3);
        }

    }

    public final MinecraftServer getServer() {
        return this.context.server();
    }

    public final void continueJoining() {
        if (this.canContinue) {
            this.canContinue = false;
            this.sendKeepAlive();
        }
    }

    public final String getConnectionInfo() {
        if (this.getGameProfile() != null) {
            GameProfile var10000 = this.getGameProfile();
            return var10000 + " (" + this.context.connection().method_10755() + ")";
        } else {
            return String.valueOf(this.context.connection().method_10755());
        }
    }

    @Override
    public boolean method_48106() {
        return this.getConnection().method_10758();
    }

    @Override
    public void method_52408(class_8736 packet) {

    }

    @Override
    public void method_56909(class_9220 packet) {

    }

    @Override
    public void method_73259(class_11752 packet) {

    }

    @Override
    public void method_55851(class_9091 packet) {

    }

    @Override
    public final @Nullable class_3222 getPlayerForPacketTweaker() {
        return null;
    }

    public final GameProfile getGameProfile() {
        return this.context.profile();
    }

    @Override
    public GameProfile getGameProfileForPacketTweaker() {
        return this.context.profile();
    }

    @Override
    public class_8791 getClientOptionsForPacketTweaker() {
        return this.context.options().get();
    }

    protected final class_3248 getLoginNetworkHandler() {
        return this.context.loginHandler();
    }

    @ApiStatus.NonExtendable
    public interface Context {
        MinecraftServer server();

        GameProfile profile();
    }
}
