package eu.pb4.polymer.networking.mixin;

import eu.pb4.polymer.networking.api.util.ServerDynamicPacket;
import eu.pb4.polymer.networking.impl.PacketListenerImplExtension;
import eu.pb4.polymer.networking.impl.ServerPacketRegistry;
import io.netty.channel.ChannelFutureListener;
import it.unimi.dsi.fastutil.objects.*;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_5455;
import net.minecraft.class_8609;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_8609.class)
public abstract class ServerCommonPacketListenerImplMixin implements PacketListenerImplExtension {
    @Unique
    private final Object2LongMap<class_2960> polymerNet$rateLimits = new Object2LongOpenHashMap<>();

    @Shadow
    public abstract void send(class_2596<?> packet);

    @Shadow @Final protected class_2535 connection;

    @Shadow @Final protected MinecraftServer server;

    @Override
    public long polymerNet$lastPacketUpdate(class_2960 packet) {
        return this.polymerNet$rateLimits.getLong(packet);
    }

    @Override
    public void polymerNet$savePacketTime(class_2960 packet) {
        this.polymerNet$rateLimits.put(packet, System.currentTimeMillis());
    }

    @Inject(method = "handleCustomPayload", at = @At("HEAD"), cancellable = true)
    private void polymerNet$catchPackets(class_2817 packet, CallbackInfo ci) {
        if (ServerPacketRegistry.handle(this.server, (class_8609) (Object) this, packet.comp_1647())) {
            this.polymerNet$savePacketTime(packet.comp_1647().method_56479().comp_2242());
            ci.cancel();
        }
    }

    @ModifyVariable(method = "send(Lnet/minecraft/network/protocol/Packet;Lio/netty/channel/ChannelFutureListener;)V", at = @At("HEAD"))
    private class_2596<?> polymerNet$replacePacket(class_2596<?> packet) {
        if (packet instanceof ServerDynamicPacket dynamicPacket) {
            var out = dynamicPacket.createPacket((class_8609) (Object) (this), ((Object) this) instanceof class_3244 h ? h.method_32311() : null);

            if (out != null) {
                return out;
            }
        }

        return packet;
    }

    @Override
    public class_2535 polymerNet$getConnection() {
        return this.connection;
    }

    @Inject(method = "send(Lnet/minecraft/network/protocol/Packet;Lio/netty/channel/ChannelFutureListener;)V", at = @At("HEAD"), cancellable = true)
    private void polymerNet$dontLeakDynamic(class_2596<?> packet, ChannelFutureListener listener, CallbackInfo ci) {
        if (packet instanceof ServerDynamicPacket) {
            ci.cancel();
        }
    }

    @Override
    public @Nullable class_5455 polymer$getDynamicRegistryManager() {
        return this.server.method_30611();
    }
}
